/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata.query;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQueryImpl;
import com.predic8.schema.ComplexType;
import com.predic8.schema.Element;
import com.predic8.schema.SimpleType;
import com.predic8.wsdl.Definitions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class DefinitionsQueryLocallyCachedProxy
extends DefinitionsQueryImpl {
    private static Cache<String, Object> cache = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();

    public DefinitionsQueryLocallyCachedProxy(Definitions definitions) {
        super(definitions);
    }

    @Override
    public List<ComplexType> getComplexSuperTypes(String localName) {
        return this.locallyCached("getComplexSuperTypes" + localName, () -> super.getComplexSuperTypes(localName));
    }

    @Override
    public List<ComplexType> getComplexTypes() {
        return this.locallyCached("getComplexTypes", () -> super.getComplexTypes());
    }

    @Override
    public List<ComplexType> getSuperTypes(String superTypeLocalName) {
        String key = "getSuperTypes" + superTypeLocalName;
        return this.locallyCached(key, () -> super.getSuperTypes(superTypeLocalName));
    }

    @Override
    public boolean hasAncestor(ComplexType complexType, String superTypeLocalName) {
        String key = "hasAncestor" + this.getKey(complexType) + superTypeLocalName;
        return this.locallyCached(key, () -> super.hasAncestor(complexType, superTypeLocalName));
    }

    @Override
    public List<String> getRecordTypes() {
        return this.locallyCached("getRecordTypes", () -> super.getRecordTypes());
    }

    @Override
    public Optional<String> getElement(String localPartName) {
        String key = "getElement" + localPartName;
        return this.locallyCached(key, () -> super.getElement(localPartName));
    }

    @Override
    Map<String, String> getElementNameToNamespaceURIMappings() {
        return this.locallyCached("getElementNameToNamespaceURIMappings", () -> super.getElementNameToNamespaceURIMappings());
    }

    @Override
    List<Element> getAllElements() {
        return this.locallyCached("getAllElements", () -> super.getAllElements());
    }

    @Override
    Optional<SimpleType> getSimpleType(String simpleTypeLocalName) {
        String key = "getSimpleType" + simpleTypeLocalName;
        return this.locallyCached(key, () -> super.getSimpleType(simpleTypeLocalName));
    }

    @Override
    public Optional<String> resolveNamespaceFor(String localPart) {
        String key = "resolveNamespaceFor" + localPart;
        return this.locallyCached(key, () -> super.resolveNamespaceFor(localPart));
    }

    @Override
    Map<String, String> getComplexTypeNameToNamespaceURIMappings() {
        return this.locallyCached("getComplexTypeNameToNamespaceURIMappings", () -> super.getComplexTypeNameToNamespaceURIMappings());
    }

    protected <R> R locallyCached(String cacheKey, Callable<R> supplier) {
        try {
            return (R)cache.get((Object)cacheKey, supplier);
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    protected String getKey(ComplexType complexType) {
        return complexType.getQname().toString();
    }
}

