/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.io.InputStream;
import javax.xml.xpath.XPathExpressionException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.w3c.dom.Document;

public class PaginatedSearch
extends IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> {
    private String xPathResponseResultNodeSet = "//*[local-name() = 'recordList']/* | //*[local-name() = 'searchRowList']/*";
    private InputStream searchQuery;
    private String xPathSearchIdExpression;
    private String searchId;

    public PaginatedSearch(NetSuiteSoapConfig config, InputStream searchQuery, int limit, int pageSize, boolean bodyFieldsOnly, boolean returnSearchColumns) {
        super(config, "//*[local-name() = 'searchResult']", pageSize, limit);
        this.bodyFieldsOnly = bodyFieldsOnly;
        this.returnSearchColumns = returnSearchColumns;
        this.searchQuery = searchQuery;
        this.xPathSearchIdExpression = "//*[local-name() = 'searchResult']/*[local-name() = 'searchId']";
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getFirstPage(NetSuiteSoapConnection connection) {
        return connection.search(this.getConfig(), this.searchQuery, this.bodyFieldsOnly, this.returnSearchColumns, this.pageSize);
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getNextPage(NetSuiteSoapConnection connection) {
        return connection.searchMoreWithId(this.getConfig(), this.searchId, this.pageIndex + 1, this.bodyFieldsOnly, this.returnSearchColumns, this.pageSize);
    }

    @Override
    protected void extractResultFields(Document resultDocument) throws XPathExpressionException {
        super.extractResultFields(resultDocument);
        this.searchId = this.extractSearchId(resultDocument);
    }

    private String extractSearchId(Document document) throws XPathExpressionException {
        return XmlUtils.executeXPath(this.getXPathSearchIdExpression(), document);
    }

    @Override
    protected String getXPathForResultNodeList() {
        return this.xPathResponseResultNodeSet;
    }

    protected String getXPathSearchIdExpression() {
        return this.xPathSearchIdExpression;
    }
}

