/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata;

import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.metadata.DefaultMetadataRetriever;
import com.mulesoft.connector.netsuite.internal.metadata.MetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.util.MetadataUtils;
import java.util.Map;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericMetadataResolver
implements InputTypeResolver,
OutputTypeResolver,
AttributesTypeResolver {
    private static final Logger logger = LoggerFactory.getLogger(GenericMetadataResolver.class);
    private final String operationName;

    protected GenericMetadataResolver(String operationName) {
        this.operationName = operationName;
    }

    public String getCategoryName() {
        return this.operationName + "-resolver";
    }

    public String getResolverName() {
        return this.operationName + "-resolver";
    }

    public String getOperationName() {
        return this.operationName;
    }

    public MetadataType getAttributesType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        return MetadataUtils.buildNetsuiteSoapAttributeMetadataObject(this.createNetsuiteMetadataResolver(context).getInputType(this.operationName), context.getTypeBuilder().withFormat(MetadataFormat.JAVA));
    }

    public MetadataType getInputMetadata(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        Type metadataType = this.createNetsuiteMetadataResolver(context).getInputType(this.operationName);
        if (this.getConnection(context).getWsdlVersion().isPresent()) {
            MetadataUtils.removeWsdlVersionInType(metadataType, this.getConnection(context).getWsdlVersion());
        }
        return metadataType.getBody();
    }

    public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        Type metadataType = this.createNetsuiteMetadataResolver(context).getOutputType(this.operationName);
        if (this.getConnection(context).getWsdlVersion().isPresent()) {
            MetadataUtils.removeWsdlVersionInType(metadataType, this.getConnection(context).getWsdlVersion());
        }
        return metadataType.getBody();
    }

    protected DefaultMetadataRetriever createNetsuiteMetadataResolver(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        return new DefaultMetadataRetriever(this.getWsdlModel(context));
    }

    protected NetSuiteSoapConnection getConnection(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        return (NetSuiteSoapConnection)context.getConnection().orElseThrow(() -> new MetadataResolvingException("No connection available to retrieve the metadata.", FailureCode.CONNECTION_FAILURE));
    }

    private WsdlModel getWsdlModel(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        logger.debug("Retrieving WsdlModel.");
        return this.getConnection(context).getWsdlModel();
    }

    protected MetadataRecordResolver getMetadataRecordResolver(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        return new MetadataRecordResolver(metadataContext, this.createNetsuiteMetadataResolver(metadataContext), this.operationName);
    }

    protected Map<String, String> getComplexToNamespaceUri(MetadataContext metadataContext) throws ConnectionException {
        return (Map)((NetSuiteSoapConnection)metadataContext.getConnection().orElseThrow(() -> new NullPointerException("Connection not found"))).getComplexTypesMap().get();
    }
}

