/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata.factory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class CachedXmlTypeLoader
extends XmlTypeLoader {
    private static final Cache<String, Object> cache = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();

    public CachedXmlTypeLoader(SchemaCollector schemaCollector) {
        super(schemaCollector);
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        String key = "typeIdentifier-" + typeIdentifier;
        return this.locallyCached(key, () -> super.load(typeIdentifier));
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        String key = "typeIdentifier-typeAlias-" + typeIdentifier + typeAlias;
        return this.locallyCached(key, () -> super.load(typeIdentifier, typeAlias));
    }

    public Optional<MetadataType> load(QName qName, String typeAlias) {
        String key = "qName-typeAlias-" + qName + typeAlias;
        return this.locallyCached(key, () -> super.load(qName, typeAlias));
    }

    protected <R> R locallyCached(String cacheKey, Callable<R> supplier) {
        try {
            return (R)cache.get((Object)cacheKey, supplier);
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }
}

