/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.source;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractPollingSource
extends PollingSource<String, NetsuiteSoapAttributes> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPollingSource.class);
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    private ZonedDateTime startDateTime;
    @Connection
    private ConnectionProvider<NetSuiteSoapConnection> connectionProvider;
    @Config
    private NetSuiteSoapConfig config;
    @Parameter
    @Placement(tab="Search preferences")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="10")
    private int pageSize;
    @Parameter
    @Placement(tab="Search preferences")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    private boolean bodyFieldsOnly;
    @Parameter
    private ComponentLocation location;
    private String idFieldName;
    private String waterMarkFieldName;
    @Inject
    private ExtensionsClient extensionsClient;

    public void onRejectedItem(Result<String, NetsuiteSoapAttributes> result, SourceCallbackContext callbackContext) {
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(PollContext<String, NetsuiteSoapAttributes> pollContext) {
        if (pollContext.isSourceStopping()) {
            logger.debug("Source was stopped before next poll");
            return;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        NetSuiteSoapConnection connection = null;
        IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> pagedResults = null;
        try {
            connection = this.getConnection();
            NetsuiteDocumentFactory transformerService = connection.getDocumentFactory();
            ZonedDateTime queryStartDateTime = this.resolveNextStartDate(pollContext);
            try {
                pagedResults = this.getResultsIterator(connection, queryStartDateTime);
                XPathExpression idFieldXPath = xPath.compile(this.getIdFieldExpression());
                XPathExpression waterMarkFieldXPath = xPath.compile(this.getWaterMarkFieldExpression());
                NetSuiteSoapConnection finalConnection = connection;
                Iterator<Result<String, NetsuiteSoapAttributes>> iterator = pagedResults.iterator(() -> finalConnection);
                while (true) {
                    if (iterator.hasNext()) {
                        Result<String, NetsuiteSoapAttributes> eachResult = iterator.next();
                        String output = (String)eachResult.getOutput();
                        Document node = transformerService.transformToDocument(output, Charset.defaultCharset());
                        ZonedDateTime watermark = ZonedDateTime.parse(this.calculateWaterMark((String)waterMarkFieldXPath.evaluate(node, XPathConstants.STRING)));
                        String id = this.calculateId((String)idFieldXPath.evaluate(node, XPathConstants.STRING));
                        pollContext.accept(item -> {
                            item.setWatermark((Serializable)watermark).setResult(Result.builder().output((Object)output).mediaType(MediaType.XML).attributes(eachResult.getAttributes().get()).build());
                            if (StringUtils.isNotBlank((CharSequence)id)) {
                                item.setId(id);
                            }
                        });
                        if (!pollContext.isSourceStopping()) continue;
                        logger.debug("Source was stopped before next poll");
                        return;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (pagedResults != null) {
                    pagedResults.close(connection);
                }
            }
        }
        catch (ConnectionException e) {
            pollContext.onConnectionException(e);
        }
        catch (Exception e) {
            logger.error(String.format("Error fetching items in trigger %s, at line %s of file %s", this.location.getLocation(), this.location.getLineInFile(), this.location.getFileName()), (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected abstract IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> getResultsIterator(NetSuiteSoapConnection var1, ZonedDateTime var2) throws TransformerException, ParserConfigurationException;

    protected String calculateId(String idFieldValue) {
        return StringUtils.isNotBlank((CharSequence)idFieldValue) ? idFieldValue : null;
    }

    protected String calculateWaterMark(String dateFieldValue) {
        if (StringUtils.isNotBlank((CharSequence)dateFieldValue)) {
            return dateFieldValue;
        }
        return null;
    }

    protected ZonedDateTime resolveNextStartDate(PollContext<String, NetsuiteSoapAttributes> pollContext) {
        if (!pollContext.getWatermark().isPresent()) {
            logger.info("No watermark present for source, starting from configured startDateTime {}", (Object)this.startDateTime);
        }
        ZonedDateTime zonedDateTime = pollContext.getWatermark().orElse(Optional.ofNullable(this.startDateTime).orElse(ZonedDateTime.now().minusMinutes(5L)));
        logger.info("Starting source from startDateTime {}", (Object)zonedDateTime);
        return zonedDateTime;
    }

    protected NetSuiteSoapConfig getConfig() {
        return this.config;
    }

    protected ConnectionProvider<NetSuiteSoapConnection> getConnectionProvider() {
        return this.connectionProvider;
    }

    protected NetSuiteSoapConnection getConnection() throws ConnectionException {
        return (NetSuiteSoapConnection)this.connectionProvider.connect();
    }

    protected ZonedDateTime getStartDateTime() {
        return this.startDateTime;
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected boolean isBodyFieldsOnly() {
        return this.bodyFieldsOnly;
    }

    public ExtensionsClient getExtensionsClient() {
        return this.extensionsClient;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getWaterMarkFieldName() {
        return this.waterMarkFieldName;
    }

    public void setWaterMarkFieldName(String waterMarkFieldName) {
        this.waterMarkFieldName = waterMarkFieldName;
    }

    private String getWaterMarkFieldExpression() {
        return "//*[local-name()='" + this.waterMarkFieldName + "']";
    }

    private String getIdFieldExpression() {
        return "//*[local-name()='" + this.idFieldName + "']";
    }
}

