/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.util;

import com.mulesoft.connector.netsuite.internal.util.CustomFieldRefType;

public class CustomKey {
    private final String type;
    private final String internalId;
    private final String scriptId;
    private final String separator;
    private final boolean startsWithSeparator;

    public static CustomKey fromParts(String type, String scriptId, String internalId, String separator) {
        return new CustomKey(type, scriptId, internalId, separator, false);
    }

    public static CustomKey fromKey(String keyWithSeparators, String separator) {
        String[] keyParts;
        boolean startsWithSeparator = keyWithSeparators.startsWith(separator);
        if (startsWithSeparator) {
            keyWithSeparators = keyWithSeparators.substring(separator.length());
        }
        String type = (keyParts = keyWithSeparators.split(separator)).length > 0 ? keyParts[0] : null;
        String scriptId = keyParts.length > 1 ? keyParts[1] : null;
        String internalId = keyParts.length > 2 ? keyParts[2] : null;
        return new CustomKey(type, scriptId, internalId, separator, startsWithSeparator);
    }

    public static CustomKey fromCustomFieldRefType(CustomFieldRefType customFieldRefType, String scriptId, String internalId, String separator) {
        return new CustomKey(customFieldRefType.getNetsuiteValue(), scriptId, internalId, separator, false);
    }

    private CustomKey(String type, String scriptId, String internalId, String separator, boolean startsWithSeparator) {
        this.type = type;
        this.scriptId = scriptId;
        this.internalId = internalId;
        this.separator = separator;
        this.startsWithSeparator = startsWithSeparator;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getType() {
        return this.type;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isCustomRecord() {
        return this.startsWithSeparator;
    }

    public String getKeyForCustomField(boolean omitInternalIdFromCustomFieldNames) {
        return this.getCustomFieldName(omitInternalIdFromCustomFieldNames);
    }

    public String getMetadataFieldKey(boolean omitInternalIdFromCustomFieldNames) {
        return this.getCustomFieldName(omitInternalIdFromCustomFieldNames);
    }

    public String getKeyForCustomRecord() {
        return this.separator + this.getCustomFieldName(false);
    }

    private String getCustomFieldName(boolean omitInternalIdFromCustomFieldNames) {
        if (omitInternalIdFromCustomFieldNames) {
            return String.join((CharSequence)this.separator, this.type, this.scriptId);
        }
        return String.join((CharSequence)this.separator, this.type, this.scriptId, this.internalId);
    }
}

