/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class NamespaceUtils {
    public static final Pattern urnPatternWithVersion = Pattern.compile("urn:[-a-zA-Z@:%.+~#=]{1,256}_([0-9_]+)([-a-zA-Z@:%._+~#=]{1,256})\\.webservices.netsuite.com");
    public static final Pattern urnPatternWithoutVersion = Pattern.compile("(urn:[-a-zA-Z@:%._+~#=]{1,256})(\\.\\w+\\.webservices.netsuite.com)");

    private NamespaceUtils() {
    }

    public static InputStream addWsdlVersionToNS(InputStream message, String wsdlVersion) throws IOException {
        return NamespaceUtils.replaceNamespaces(message, urnPatternWithoutVersion, matcher -> matcher.group().replace(matcher.group(0), matcher.group(1) + "_" + wsdlVersion + matcher.group(2)));
    }

    public static InputStream removeWsdlVersionFromNS(InputStream message) throws IOException {
        return NamespaceUtils.replaceNamespaces(message, urnPatternWithVersion, matcher -> matcher.group().replace("_" + matcher.group(1), ""));
    }

    private static InputStream replaceNamespaces(InputStream message, Pattern pattern, Function<Matcher, String> replacer) throws IOException {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(IOUtils.toString((InputStream)message, (Charset)StandardCharsets.UTF_8));
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacer.apply(matcher));
        }
        matcher.appendTail(sb);
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

