/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.concurrency;

import com.mulesoft.connector.netsuite.internal.citizen.concurrency.Result;
import java.util.Objects;

public class ResultFactory<T> {
    public Result<T> resultWithResponse(T response) {
        return new ResultImpl(response, null);
    }

    public Result<T> resultErrored(RuntimeException ex) {
        return new ResultImpl(null, ex);
    }

    private static class ResultImpl<T>
    implements Result<T> {
        private final T result;
        private final RuntimeException exception;

        private ResultImpl(T result, RuntimeException exception) {
            this.result = result;
            this.exception = exception;
        }

        @Override
        public boolean isErrored() {
            return Objects.nonNull(this.exception);
        }

        @Override
        public RuntimeException getException() {
            return this.exception;
        }

        @Override
        public T getResult() {
            return this.result;
        }
    }
}

