/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.model.Field;
import com.mulesoft.connector.netsuite.internal.citizen.model.Query;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenGetRecordsOutputTypeResolver
implements OutputTypeResolver<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitizenGetRecordsOutputTypeResolver.class);

    public MetadataType getOutputType(MetadataContext context, String query) throws MetadataResolvingException {
        LOGGER.info("Logging input query: <{}>", (Object)query);
        try {
            if (StringUtils.isBlank((CharSequence)query)) {
                LOGGER.error("Query is empty, returning any type.");
                return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).anyType().build();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes());
            Query queryObject = SearchUtils.parse(is);
            boolean fieldsSet = queryObject.getFields() != null && !queryObject.getFields().isEmpty();
            boolean fetchCustomFields = !fieldsSet || queryObject.getFields().stream().map(Field::getElementsList).flatMap(Collection::stream).anyMatch(qname -> qname.toString().contains("CustomField"));
            MetadataType metadataType = CitizenMetadataUtils.loadMetaData(context, SearchUtils.isCustomRecordType(queryObject.getObjectType()) != false ? queryObject.getObjectType() : queryObject.getObjectType().toUpperCase(), fetchCustomFields, false);
            ObjectType originalType = (ObjectType)metadataType;
            if (fieldsSet) {
                ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().label(queryObject.getObjectType());
                HashMap<String, ObjectTypeBuilder> fieldTypeBuilderMap = new HashMap<String, ObjectTypeBuilder>();
                fieldTypeBuilderMap.put("", objectBuilder);
                Map<String, List<String>> attributeMap = this.getAttributeMap(queryObject);
                queryObject.getFields().stream().forEach(fieldStr -> {
                    String fieldToString = fieldStr.getElementsList().stream().map(QName::toString).collect(Collectors.joining(","));
                    try {
                        LOGGER.trace("Filter output metadata with {}", (Object)fieldToString);
                        CitizenMetadataUtils.filterMetadata(fieldStr.getElementsList(), originalType, fieldTypeBuilderMap, attributeMap);
                    }
                    catch (MetadataResolvingException e) {
                        LOGGER.error("Error processing search output metadata", (Throwable)e);
                        throw new NetSuiteSoapModuleException("Error processing search output metadata " + fieldToString, NetSuiteSoapErrorType.NETSUITE_ERROR, e);
                    }
                });
                return objectBuilder.build();
            }
            return metadataType;
        }
        catch (NetsuiteTransformationException e) {
            throw new MetadataResolvingException("An error occurred while parsing the metadata query.", FailureCode.INVALID_METADATA_KEY, (Throwable)((Object)e));
        }
    }

    private Map<String, List<String>> getAttributeMap(Query queryObject) {
        HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
        queryObject.getFields().stream().forEach(fieldStr -> {
            StringBuilder fullPath = new StringBuilder("");
            for (int i = 0; i < fieldStr.getElementsList().size(); ++i) {
                String pathName = fieldStr.getElementsList().get(i).toString();
                if (pathName.startsWith("{_@}")) {
                    String attribute = pathName.replaceAll("\\{_@}", "");
                    if (!attributeMap.containsKey(fullPath.toString())) {
                        attributeMap.put(fullPath.toString(), new ArrayList<String>(Arrays.asList(attribute)));
                    } else {
                        List attributes = (List)attributeMap.get(fullPath.toString());
                        attributes.add(attribute);
                        attributeMap.put(fullPath.toString(), attributes);
                    }
                }
                fullPath = fullPath.append(pathName);
            }
        });
        return attributeMap;
    }

    protected NetSuiteSoapConnection getConnection(MetadataContext context) throws ConnectionException {
        return (NetSuiteSoapConnection)context.getConnection().get();
    }

    public String getCategoryName() {
        return CitizenGetRecordsOutputTypeResolver.class.getSimpleName();
    }
}

