/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenInputRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;

public class CitizenInputExtIdRecordResolver
extends CitizenInputRecordResolver {
    @Override
    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException {
        DefaultObjectType result = (DefaultObjectType)CitizenMetadataUtils.loadMetaData(context, key, true);
        result.getFields().forEach(this::processMetadata);
        this.processAttributes(result);
        return result;
    }

    private void processMetadata(ObjectFieldType object) {
        if (object.getValue() instanceof ObjectType) {
            Collection childFields = ((ObjectType)object.getValue()).getFields();
            for (ObjectFieldType fieldType : childFields) {
                if (!StringUtils.substringAfter((String)fieldType.getValue().toString(), (String)"}").equalsIgnoreCase("RecordRef")) continue;
                Collection grandChildrenFields = ((ObjectType)fieldType.getValue()).getFields();
                grandChildrenFields.removeIf(field -> field.getKey().getName().getLocalPart().equals("name"));
            }
            childFields.forEach(this::processMetadata);
        }
    }

    @Override
    protected void processAttributes(DefaultObjectType result) throws MetadataResolvingException {
        Collection attributes = ((ObjectFieldType)result.getFieldByName("record").orElseThrow(defaultErrSupplier)).getKey().getAttributes();
        attributes.removeIf(attribute -> "internalId".equals(attribute.getKey().getName().getLocalPart()));
    }

    @Override
    public String getResolverName() {
        return CitizenInputExtIdRecordResolver.class.getSimpleName();
    }
}

