/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenActionRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.group.InputRecordKey;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenInputKeysMetadataResolver
implements InputTypeResolver<InputRecordKey>,
TypeKeysResolver {
    private static final Logger logger = LoggerFactory.getLogger(CitizenInputKeysMetadataResolver.class);
    protected static final Supplier<MetadataResolvingException> defaultErrSupplier = () -> new MetadataResolvingException("Could not generate input metadata", FailureCode.UNKNOWN);
    private static final Set<MetadataKey> METADATA_KEYS = Arrays.stream(CitizenActionRecordEnum.values()).map(field -> MetadataKeyBuilder.newKey((String)field.name()).withDisplayName(field.name()).build()).collect(Collectors.toSet());
    private static final List<String> idTypes = Arrays.asList("INTERNAL", "EXTERNAL");

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        try {
            Set<MetadataKey> customObjectKeys = new CitizenMetadataRecordResolver(context).getCustomObjectKeys();
            for (MetadataKey key : Sets.union(METADATA_KEYS, customObjectKeys)) {
                MetadataKeyBuilder topLevelBuilder = MetadataKeyBuilder.newKey((String)key.getId()).withDisplayName(key.getDisplayName()).withPartName(key.getPartName());
                for (String idType : idTypes) {
                    topLevelBuilder.withChild(MetadataKeyBuilder.newKey((String)idType).build());
                }
                keys.add(topLevelBuilder.build());
            }
            return keys;
        }
        catch (ConnectionException | MetadataResolvingException e) {
            logger.error("Error retrieving metadata keys", e);
            throw e;
        }
    }

    public MetadataType getInputMetadata(MetadataContext context, InputRecordKey inputRecordKey) throws MetadataResolvingException {
        logger.debug("Resolving input metadata for record type: {} and id type: {}", (Object)inputRecordKey.getRecordType(), (Object)inputRecordKey.getIdType());
        long start = System.currentTimeMillis();
        DefaultObjectType result = (DefaultObjectType)CitizenMetadataUtils.loadMetaData(context, inputRecordKey.getRecordType(), true);
        this.processAttributes(result, inputRecordKey);
        long stop = System.currentTimeMillis();
        logger.info(String.format("RECORD_INPUT_METADATA-getInputMetadata-CitizenInputKeysMetadataResolver: inputRecordKey: %s, time: %s seconds", inputRecordKey.getRecordType(), (stop - start) / 1000L));
        return result;
    }

    protected void processAttributes(DefaultObjectType result, InputRecordKey inputRecordKey) throws MetadataResolvingException {
        Collection attributes = ((ObjectFieldType)result.getFieldByName("record").orElseThrow(defaultErrSupplier)).getKey().getAttributes();
        if (inputRecordKey.getIdType() != null && inputRecordKey.getIdType().equalsIgnoreCase("INTERNAL")) {
            attributes.removeIf(attribute -> "internalId".equals(attribute.getKey().getName().getLocalPart()));
        } else {
            attributes.clear();
        }
    }

    public String getResolverName() {
        return CitizenInputKeysMetadataResolver.class.getSimpleName();
    }

    public String getCategoryName() {
        return "CITIZEN_NETSUITE_RECORD_CATEGORY";
    }
}

