/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenInputRecordResolver
implements InputTypeResolver<String>,
TypeKeysResolver,
ValueProvider {
    private static final Logger logger = LoggerFactory.getLogger(CitizenInputRecordResolver.class);
    protected static final Supplier<MetadataResolvingException> defaultErrSupplier = () -> new MetadataResolvingException("Could not generate input metadata", FailureCode.UNKNOWN);
    @Connection
    NetSuiteSoapConnection connection;
    @Config
    NetSuiteSoapConfig config;

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        Set<MetadataKey> customObjectKeys = null;
        try {
            customObjectKeys = new CitizenMetadataRecordResolver(context).getCustomObjectKeys();
            return Sets.union(CitizenMetadataUtils.getMetadataKeys(), customObjectKeys);
        }
        catch (ConnectionException | MetadataResolvingException e) {
            logger.error("Error retrieving metadata keys", e);
            throw e;
        }
    }

    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException {
        logger.info("Input resolver for {}", (Object)key);
        long start = System.currentTimeMillis();
        DefaultObjectType result = (DefaultObjectType)CitizenMetadataUtils.loadMetaData(context, key, true);
        this.processAttributes(result);
        long stop = System.currentTimeMillis();
        logger.info(String.format("CUSTOM_FIELDS-getInputMetadata-CitizenInputRecordResolver: key: %s, time: %s seconds", key, (stop - start) / 1000L));
        return result;
    }

    protected void processAttributes(DefaultObjectType result) throws MetadataResolvingException {
        ((ObjectFieldType)result.getFieldByName("record").orElseThrow(defaultErrSupplier)).getKey().getAttributes().clear();
    }

    public String getResolverName() {
        return CitizenInputRecordResolver.class.getSimpleName();
    }

    public String getCategoryName() {
        return "CITIZEN_NETSUITE_RECORD_CATEGORY";
    }

    public Set<Value> resolve() throws ValueResolvingException {
        Set<MetadataKey> customObjectKeys = new CitizenMetadataRecordResolver(this.connection, this.config).getCustomObjectKeys();
        return ValueBuilder.getValuesFor(Sets.union(CitizenMetadataUtils.getMetadataKeys(), customObjectKeys).stream().collect(Collectors.toMap(MetadataKey::getId, MetadataKey::getDisplayName)));
    }
}

