/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CustomFieldWrapper;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldType;
import com.mulesoft.connector.netsuite.internal.citizen.util.CustomObjectUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.TransformationUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.metadata.factory.XmlTypeLoaderFactory;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQuery;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQueryLocallyCachedProxy;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.operation.ItemOperations;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import com.mulesoft.connector.netsuite.internal.util.CustomizationTypeEnum;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.util.Utils;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.metadata.api.annotation.Accessibility;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CitizenMetadataRecordResolver {
    private static final Logger logger = LoggerFactory.getLogger(CitizenMetadataRecordResolver.class);
    private static final Set<CustomizationTypeEnum> UNSUPPORTED_TYPES = new HashSet<CustomizationTypeEnum>(Arrays.asList(CustomizationTypeEnum.ITEM_NUMBER_CUSTOM_FIELD, CustomizationTypeEnum.CUSTOM_LIST, CustomizationTypeEnum.CUSTOM_RECORD_TYPE, CustomizationTypeEnum.CUSTOM_TRANSACTION_TYPE, CustomizationTypeEnum.ITEM_OPTION_CUSTOM_FIELD));
    private static final NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(WsdlVersion.getDefaultWsdlVersionStr(), null, null);
    private static final String IS_MUNIT_TEST = "isMunitTest";
    private static final String DOCUMENT_CITIZEN_LIST_KEY = "DOC_CIT_LIST";
    private static final Boolean isMunitTest = Boolean.valueOf(System.getProperty("isMunitTest"));
    private final String separator;
    private final ItemOperations itemOperations;
    private final RecordOperations recordOperations;
    private final NetSuiteSoapConnection connection;
    private final NetSuiteSoapConfig config;
    private final DefinitionsQuery definitionsQuery;
    LazyValue<XmlTypeLoader> xmlTypeLoader = new LazyValue(this::loadXmlTypeLoader);
    private static final List<String> LIST_TYPES = Arrays.asList(CitizenCustomFieldType.LIST_RECORD.getNetsuiteValue(), CitizenCustomFieldType.MULTIPLE_SELECT.getNetsuiteValue());
    private MetadataCache metadataCache;
    private static final Set<String> VALID_ATTRIBUTES = Sets.newHashSet((Object[])new String[]{"internalId", "type"});

    public CitizenMetadataRecordResolver(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        this((NetSuiteSoapConnection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException("Could not get a connection to resolve metadata", FailureCode.CONNECTION_FAILURE)), (NetSuiteSoapConfig)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Could not get a config to resolve metadata", FailureCode.CONNECTION_FAILURE)));
        this.metadataCache = metadataContext.getCache();
    }

    public CitizenMetadataRecordResolver(NetSuiteSoapConnection connection, NetSuiteSoapConfig config) {
        this.connection = connection;
        this.config = config;
        this.definitionsQuery = new DefinitionsQueryLocallyCachedProxy(connection.getDefinitions());
        this.separator = config.getAdvancedConfig().getSeparator();
        this.itemOperations = new ItemOperations();
        this.recordOperations = new RecordOperations();
    }

    private XmlTypeLoader loadXmlTypeLoader() {
        return XmlTypeLoaderFactory.createCachedXmlTypeLoaderWithLocalDefinitions(this.connection.getDefinitions(), WsdlVersion.getBaseDir(Optional.of(WsdlVersion.getDefaultWsdlVersion())));
    }

    private Optional<String> tryToResolveNamespace(String localName) {
        return this.definitionsQuery.resolveNamespaceFor(localName);
    }

    public void generateCustomMetadataTypes(String recordType, ObjectFieldType objectType, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomLists) {
        logger.debug("Starting custom metadata resolution for {}.", (Object)recordType);
        List<String> customizationTypes = this.getCustomizationTypes(recordType);
        List<Node> allNodes = this.retrieveAndExtractCustomizationRefNodesToMap(customizationTypes);
        logger.info("Retrieving customization types finished for {}.", (Object)recordType);
        List partitions = Lists.partition(allNodes, (int)300);
        ArrayList<CustomFieldWrapper> list = new ArrayList<CustomFieldWrapper>();
        try {
            for (List partition : partitions) {
                logger.info(String.format("Getting a batch... size:%d", partition.size()));
                long start = System.currentTimeMillis();
                Document document = this.retrieveRecordsForBaseRefs(partition);
                List<Node> customizationRecords = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='record']", document, XPathConstants.NODESET));
                long stop = System.currentTimeMillis();
                logger.info(String.format("CUSTOM_FIELDS-generateCustomMetadataTypes-CitizenMetadataRecordResolver: record type: %s, time: %s seconds", recordType, (stop - start) / 1000L));
                logger.info(String.format("CUSTOM_FIELDS-generateCustomMetadataTypes-CitizenMetadataRecordResolver: record type: %s, no. of fetched records: %s", recordType, customizationRecords.size()));
                list.addAll(this.convertCustomizationRecordToMetadataType(customizationRecords, node -> node.getNodeName().endsWith("record"), metadataKeyFunction, fetchCustomLists));
                logger.info("Batch retrieved and loaded.");
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            logger.error("Could not generate metadata for some customizationIds", (Throwable)e);
        }
        this.addCustomFields(objectType, list.stream().sorted(Comparator.comparing(a -> a.getFieldType().getKey().getName().getLocalPart())).collect(Collectors.toList()), CitizenRecordEnum.valueOf(recordType));
    }

    public List<String> getCustomizationTypes(String recordType) {
        return Stream.of(CustomizationTypeEnum.values()).filter(customType -> {
            if (UNSUPPORTED_TYPES.contains(customType)) {
                return false;
            }
            return this.isAcceptedRecordType((CustomizationTypeEnum)((Object)customType), recordType);
        }).map(CustomizationTypeEnum::getNetsuiteValue).collect(Collectors.toList());
    }

    public boolean isAcceptedRecordType(CustomizationTypeEnum customizationTypeEnum, String recordType) {
        return customizationTypeEnum.getAcceptedRecords() != null && Arrays.stream(customizationTypeEnum.getAcceptedRecords()).map(String::toLowerCase).collect(Collectors.toList()).contains(recordType.toLowerCase());
    }

    private void addCustomFields(ObjectFieldType parent, List<CustomFieldWrapper> list, CitizenRecordEnum recordType) {
        ObjectType objectType = (ObjectType)parent.getValue();
        Optional<ObjectFieldType> customFields = objectType.getFields().stream().filter(field -> field.getKey().getName().getLocalPart().equals("customFieldList")).findAny();
        if (customFields.isPresent()) {
            objectType.getFields().remove(customFields.get());
            ObjectFieldTypeBuilder fieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.XML);
            QName name = customFields.get().getKey().getName();
            ObjectKeyBuilder keyBuilder = fieldTypeBuilder.key(name);
            fieldTypeBuilder.label(CitizenMetadataUtils.getLabel(name));
            CitizenMetadataUtils.copyKeyAttributes(customFields.get(), keyBuilder);
            fieldTypeBuilder.value().objectType();
            ObjectFieldType build = fieldTypeBuilder.build();
            Collection fields = ((ObjectType)build.getValue()).getFields();
            list.stream().filter(field -> recordType.appliesTo((CustomFieldWrapper)field, parent)).forEach(customField -> {
                logger.trace("Adding {} to parent element {}.", (Object)customField.getFieldType().getKey().getName(), (Object)parent.getKey().getName());
                fields.add(customField.getFieldType());
            });
            if (!fields.isEmpty()) {
                objectType.getFields().add(build);
            } else {
                logger.trace("No custom fields have been resolved for key: {}.", (Object)parent.getKey().getName());
            }
        }
        objectType.getFields().forEach(field -> {
            if (field.getValue() instanceof ObjectType) {
                this.addCustomFields((ObjectFieldType)field, list, recordType);
            }
        });
    }

    @VisibleForTesting
    protected Document retrieveRecordsForBaseRefs(List<Node> baseRefs) throws ParserConfigurationException, TransformerException, IOException, SAXException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(WsdlVersion.getDefaultWsdlVersionStr(), null, null);
        Document getListRequestDoc = netsuiteDocumentFactory.getListRequest(baseRefs);
        return this.getListResultDocument(getListRequestDoc, netsuiteDocumentFactory);
    }

    private Document getListResultDocument(Document getListRequestDoc, NetsuiteDocumentFactory netsuiteDocumentFactory) throws TransformerException {
        Result<InputStream, NetsuiteSoapAttributes> getListResult = null;
        Document getListResultDocument = null;
        if (isMunitTest != null && isMunitTest.booleanValue() && this.metadataCache != null) {
            Optional element = this.metadataCache.get((Serializable)((Object)DOCUMENT_CITIZEN_LIST_KEY));
            if (!element.isPresent()) {
                getListResult = this.recordOperations.getList(this.config, this.connection, new RecordRefAndTypeParameterGroup(), netsuiteDocumentFactory.transformToInputStream(getListRequestDoc));
                getListResultDocument = netsuiteDocumentFactory.transformToDocument((InputStream)getListResult.getOutput());
                this.metadataCache.put((Serializable)((Object)DOCUMENT_CITIZEN_LIST_KEY), (Serializable)((Object)getListResultDocument));
                element = this.metadataCache.get((Serializable)((Object)DOCUMENT_CITIZEN_LIST_KEY));
            }
            return (Document)element.get();
        }
        getListResult = this.recordOperations.getList(this.config, this.connection, new RecordRefAndTypeParameterGroup(), netsuiteDocumentFactory.transformToInputStream(getListRequestDoc));
        getListResultDocument = netsuiteDocumentFactory.transformToDocument((InputStream)getListResult.getOutput());
        return getListResultDocument;
    }

    protected List<CustomFieldWrapper> convertCustomizationRecordToMetadataType(List<Node> customizationRecords, Function<Node, Boolean> customRecordFilter, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomLists) {
        Document response = fetchCustomLists ? this.getCustomList(customizationRecords, customRecordFilter) : null;
        HashMap customLists = response != null ? TransformationUtils.documentCustomListsToMap(response) : new HashMap();
        List<CustomFieldWrapper> list = customizationRecords.stream().map(node -> {
            try {
                Optional<CitizenCustomFieldRefType> customFieldRefType;
                HashMap<String, Map<String, String>> customFields = new HashMap<String, Map<String, String>>();
                CitizenMetadataRecordResolver.extractCustomFields(node, customFields, customRecordFilter);
                Iterator cfi = customFields.entrySet().iterator();
                if (!cfi.hasNext()) {
                    logger.info(String.format("No custom fields appear for record: <%s internalId:%s>", node.getNodeName(), node.getAttributes().getNamedItem("internalId").getNodeValue()));
                    return null;
                }
                if (customFields.size() > 1) {
                    logger.warn(String.format("Multiple custom fields appear for record: <%s internalId:%s>", node.getNodeName(), node.getAttributes().getNamedItem("internalId").getNodeValue()));
                }
                Map mappedCustomField = (Map)cfi.next().getValue();
                String customListInternalId = null;
                String internalId = (String)mappedCustomField.get("internalId");
                String label = (String)mappedCustomField.get("label");
                String displayType = (String)mappedCustomField.get("displayType");
                String fieldType = (String)mappedCustomField.get("fieldType");
                String scriptId = this.extractScriptId(mappedCustomField);
                String isMandatory = (String)mappedCustomField.get("isMandatory");
                boolean customFieldCustomList = this.isCustomFieldCustomList(mappedCustomField);
                boolean customFieldStandardList = false;
                if (customFieldCustomList || customFieldStandardList) {
                    fieldType = "custom" + fieldType;
                    if (customLists.get(mappedCustomField.get("customListInternalId")) != null) {
                        customListInternalId = (String)mappedCustomField.get("customListInternalId");
                    } else if (customFieldStandardList) {
                        customListInternalId = ((String)mappedCustomField.get("selectRecordType")).replace(" ", "_").toLowerCase();
                    }
                }
                if (!(customFieldRefType = CitizenCustomFieldType.refTypeFromNetSuiteName(fieldType)).isPresent()) {
                    logger.trace("Skipping {}, internalId: {} field as its type: {} is not supported.", new Object[]{label, internalId, fieldType});
                    return null;
                }
                if (!ObjectUtils.allNotNull((Object[])new Object[]{fieldType, scriptId}) && customFieldRefType.isPresent()) {
                    String description = (String)mappedCustomField.get("description");
                    String accessLevel = (String)mappedCustomField.get("accessLevel");
                    String searchLevel = (String)mappedCustomField.get("searchLevel");
                    String customizationData = String.format(" internalId: '%s' fieldType:'%s' label:'%s' description:'%s' isMandatory:'%s' accessLevel:'%s' searchLevel:'%s' ", fieldType, label, description, isMandatory, accessLevel, searchLevel, internalId);
                    logger.warn("Could not recognize field with values :: {}", (Object)customizationData);
                    return null;
                }
                String prefix = (String)metadataKeyFunction.apply(customFieldRefType.get());
                String metadataFieldKey = CitizenMetadataUtils.getMetadataFieldKey(prefix, this.separator, scriptId, internalId, customListInternalId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Metadata field processed: {}", (Object)metadataFieldKey);
                }
                String customFieldRefElementElementName = Utils.toLowerCamelCase(customFieldRefType.get().getNetsuiteValue());
                MetadataType typeRefMetadata = this.getMetadataTypeFromXmlTypeLoader(customFieldRefElementElementName);
                ObjectFieldType result = (ObjectFieldType)((ObjectType)typeRefMetadata).getFields().iterator().next();
                Optional value = ((ObjectType)result.getValue()).getFieldByName("value");
                ObjectFieldTypeBuilder fieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.XML);
                ObjectKeyBuilder keyBuilder = fieldTypeBuilder.key(new QName("urn:core_2020_2.platform.webservices.netsuite.com", metadataFieldKey));
                fieldTypeBuilder.label(label).required(Boolean.valueOf(isMandatory).booleanValue());
                if ("_disabled".equals(displayType)) {
                    logger.trace("Marking {} - internalId: {} field as read only, as it has been disabled.", (Object)label, (Object)internalId);
                    fieldTypeBuilder.accessibility(Accessibility.READ_ONLY);
                }
                switch (customFieldRefType.get()) {
                    case DATE: {
                        CitizenMetadataUtils.addFormatToDateTimeField(fieldTypeBuilder);
                        return new CustomFieldWrapper(fieldTypeBuilder.build(), (Node)node);
                    }
                    case SELECT_LIST: 
                    case SELECT: {
                        CitizenMetadataUtils.copyKeyAttributes((ObjectFieldType)value.get(), keyBuilder);
                        ObjectTypeBuilder builder = fieldTypeBuilder.value().objectType();
                        ((ObjectFieldType)value.get()).getValue().getAnnotations().forEach(arg_0 -> ((ObjectTypeBuilder)builder).with(arg_0));
                        builder.ordered(((ObjectType)((ObjectFieldType)value.get()).getValue()).isOrdered());
                        CitizenMetadataUtils.mapField((ObjectFieldType)((ObjectType)((ObjectFieldType)value.get()).getValue()).getFields().iterator().next(), builder);
                        return new CustomFieldWrapper(fieldTypeBuilder.build(), (Node)node);
                    }
                    case MULTI_SELECT: 
                    case MULTI_SELECT_LIST: {
                        CitizenMetadataUtils.mapField((ObjectFieldType)value.get(), fieldTypeBuilder.value().objectType());
                        return new CustomFieldWrapper(fieldTypeBuilder.build(), (Node)node);
                    }
                }
                return new CustomFieldWrapper(fieldTypeBuilder.value(((ObjectFieldType)value.get()).getValue()).build(), (Node)node);
            }
            catch (XPathExpressionException | MetadataResolvingException e) {
                logger.error(String.format("Could not generate metadata for node %s", node), e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return list;
    }

    private Document getCustomList(List<Node> customizationRecords, Function<Node, Boolean> customRecordFilter) {
        HashMap customFieldMap = new HashMap();
        customizationRecords.forEach(node -> {
            Map mappedCustomField;
            HashMap<String, Map<String, String>> customFields = new HashMap<String, Map<String, String>>();
            CitizenMetadataRecordResolver.extractCustomFields(node, customFields, customRecordFilter);
            Iterator cfi = customFields.entrySet().iterator();
            if (!cfi.hasNext()) {
                return;
            }
            if (customFields.size() > 1) {
                logger.warn(String.format("Multiple custom fields appear for record: <%s internalId:%s>", node.getNodeName(), node.getAttributes().getNamedItem("internalId").getNodeValue()));
            }
            if (this.isCustomFieldCustomList(mappedCustomField = (Map)cfi.next().getValue())) {
                customFieldMap.put(node, mappedCustomField.get("customListInternalId"));
            }
        });
        if (ObjectUtils.isEmpty(customFieldMap)) {
            return null;
        }
        try {
            RecordOperations recordOperations = new RecordOperations();
            InputStream message = netsuiteDocumentFactory.transformToInputStream(CustomObjectUtils.getCustomListRequest(customFieldMap.values()));
            return netsuiteDocumentFactory.transformToDocument((InputStream)recordOperations.getList(this.config, this.connection, new RecordRefAndTypeParameterGroup(), message).getOutput());
        }
        catch (ParserConfigurationException | TransformerException e) {
            logger.error("Could not transform custom list: ", (Throwable)e);
            return null;
        }
    }

    public static void extractCustomFields(Node root, Map<String, Map<String, String>> customFields, Function<Node, Boolean> customRecordFilter) {
        if (customRecordFilter.apply(root).booleanValue()) {
            Map<String, String> customField = CitizenMetadataRecordResolver.readCustomFieldValues(root);
            customFields.put(customField.get("internalId"), customField);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            CitizenMetadataRecordResolver.extractCustomFields(child, customFields, customRecordFilter);
        }
    }

    private static Map<String, String> readCustomFieldValues(Node root) {
        HashMap<String, String> customField = new HashMap<String, String>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            String[] parts = name.split(":");
            String localName = parts[parts.length - 1];
            customField.put(localName, child.getTextContent());
            if (!localName.equals("selectRecordType") || ((Element)child).getAttribute("internalId") == null) continue;
            customField.put("customListInternalId", ((Element)child).getAttribute("internalId"));
        }
        NamedNodeMap attributes = root.getAttributes();
        for (String attributeName : VALID_ATTRIBUTES) {
            Node attributeNode = attributes.getNamedItem(attributeName);
            if (attributeNode == null) continue;
            customField.put(attributeName, attributeNode.getNodeValue());
        }
        return customField;
    }

    private XmlTypeLoader getXmlTypeLoader() throws MetadataResolvingException {
        try {
            return (XmlTypeLoader)this.xmlTypeLoader.get();
        }
        catch (RuntimeException e) {
            throw new MetadataResolvingException("", FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private MetadataType getMetadataTypeFromXmlTypeLoader(String localTypeName) throws MetadataResolvingException {
        Optional<String> namespaceURI = this.tryToResolveNamespace(localTypeName);
        Optional metadataType = this.getXmlTypeLoader().load(new QName(namespaceURI.orElse("http://mulesoft.org/connectors/netsuite"), localTypeName), localTypeName);
        return (MetadataType)metadataType.orElseThrow(() -> new MetadataResolvingException(String.format("Could not resolve metadata from localTypeName loader for localTypeName %s", localTypeName), FailureCode.UNKNOWN));
    }

    @VisibleForTesting
    protected List<Node> retrieveAndExtractCustomizationRefNodesToMap(List<String> customizationTypes) {
        return customizationTypes.stream().map(customizationId -> {
            try {
                return this.retrieveCustomizationRefNodes((String)customizationId);
            }
            catch (NetSuiteSoapModuleException | ParserConfigurationException | TransformerException | XPathExpressionException e) {
                logger.error(String.format("Could not obtain custom Fields from Netsuite for customizationId %s", customizationId), (Throwable)e);
                return Collections.emptyList();
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected List<Node> retrieveCustomizationRefNodes(String customizationId) throws ParserConfigurationException, TransformerException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(WsdlVersion.getDefaultWsdlVersionStr(), null, null);
        Document customizationRequestDoc = netsuiteDocumentFactory.getCustomizationRequest(customizationId);
        Result<InputStream, NetsuiteSoapAttributes> customizationIdsResponse = this.itemOperations.getCustomizationId(this.config, this.connection, netsuiteDocumentFactory.transformToInputStream(customizationRequestDoc));
        NodeList customizationRefNodes = (NodeList)XmlUtils.executeXPath("//*[local-name()='customizationRef']", (InputStream)customizationIdsResponse.getOutput(), XPathConstants.NODESET);
        logger.debug("Retrieving customization ref nodes finished for {}.", (Object)customizationId);
        return XmlUtils.toList(customizationRefNodes);
    }

    public Set<MetadataKey> getCustomObjectKeys() {
        try {
            List<Node> nodes = this.retrieveCustomizationRefNodes(CustomizationTypeEnum.CUSTOM_RECORD_TYPE.getNetsuiteValue());
            String separator = this.config.getAdvancedConfig().getSeparator();
            return nodes.stream().map(node -> MetadataKeyBuilder.newKey((String)CitizenMetadataUtils.getMetadataFieldKey("CustomRecord", separator, CitizenMetadataUtils.getXmlAttribute(node, "scriptId"), CitizenMetadataUtils.getXmlAttribute(node, "internalId"), null)).withDisplayName(node.getTextContent().toUpperCase()).build()).collect(Collectors.toSet());
        }
        catch (ParserConfigurationException | TransformerException | XPathExpressionException e) {
            logger.error("Could not obtain custom record types from Netsuite", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void generateCustomFieldsForCustomType(String recordType, ObjectFieldType objectType, ObjectTypeBuilder builder, String separator, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomLists) {
        logger.debug("Starting custom metadata resolution for {}.", (Object)recordType);
        ArrayList<CustomFieldWrapper> list = new ArrayList<CustomFieldWrapper>();
        try {
            Document document = this.retrieveRecordsForBaseRefs(Collections.singletonList(XMLUtils.getBaseRef(recordType, separator)));
            List<Node> nodes = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[starts-with(local-name(), '" + separator + "')]", document, XPathConstants.NODESET));
            list.addAll(this.convertCustomizationRecordToMetadataType(nodes, node -> node.getNodeName().startsWith(separator), metadataKeyFunction, fetchCustomLists));
            builder.label(XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='recordName']", document, XPathConstants.NODESET)).get(0).getTextContent());
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            logger.error("Could not generate metadata for some customizationIds", (Throwable)e);
        }
        this.addCustomFields(objectType, list.stream().sorted(Comparator.comparing(a -> a.getFieldType().getKey().getName().getLocalPart())).collect(Collectors.toList()), CitizenRecordEnum.CUSTOM_RECORD);
    }

    public boolean isCustomFieldCustomList(Map<String, String> mappedCustomField) {
        return LIST_TYPES.contains(mappedCustomField.get("fieldType")) && TransformationUtils.isPositiveNumber(mappedCustomField.get("customListInternalId"));
    }

    public boolean isCustomFieldStandardList(Map<String, String> mappedCustomField) {
        return LIST_TYPES.contains(mappedCustomField.get("fieldType")) && Sets.union(CitizenMetadataUtils.getMetadataKeys(), this.getCustomObjectKeys()).stream().filter(key -> !Strings.isNullOrEmpty((String)key.getId())).noneMatch(key -> key.getId().replace("_", "").equalsIgnoreCase(Optional.ofNullable(mappedCustomField.get("selectRecordType")).orElse("").replace(" ", "")));
    }

    private String extractScriptId(Map<String, String> mappedCustomField) {
        String scriptId = mappedCustomField.get("scriptId");
        if (scriptId.contains("cseg")) {
            return scriptId.replaceFirst("custentity_", "");
        }
        return scriptId;
    }
}

