/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenOtherCustomFieldTypeEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CustomFieldWrapper;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import java.util.Arrays;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ObjectFieldType;

public enum CitizenRecordEnum {
    CUSTOM_RECORD("{urn:customization_2020_2.setup.webservices.netsuite.com}CustomRecord"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return true;
        }
    }
    ,
    CUSTOMER("{urn:relationships_2020_2.lists.webservices.netsuite.com}Customer"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToCustomer(), field, parent);
        }
    }
    ,
    CUSTOMER_REFUND("{urn:customers_2020_2.transactions.webservices.netsuite.com}CustomerRefund"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isBodyCustomerPayment(), field, parent);
        }
    }
    ,
    EMPLOYEE("{urn:employees_2020_2.lists.webservices.netsuite.com}Employee"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToEmployee(), field, parent);
        }
    }
    ,
    CONTACT("{urn:relationships_2020_2.lists.webservices.netsuite.com}Contact"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToContact(), field, parent);
        }
    }
    ,
    INVENTORY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}InventoryItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    INVOICE("{urn:sales_2020_2.transactions.webservices.netsuite.com}Invoice"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "InvoiceItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    PAYMENT_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}PaymentItem"),
    SALES_ORDER("{urn:sales_2020_2.transactions.webservices.netsuite.com}SalesOrder"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "SalesOrderItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    SUPPORT_CASE("{urn:support_2020_2.lists.webservices.netsuite.com}SupportCase"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToCase(), field, parent);
        }
    }
    ,
    OPPORTUNITY("{urn:sales_2020_2.transactions.webservices.netsuite.com}Opportunity"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "OpportunityItem", field.isBodyOpportunity(), field.isColOpportunity(), field, parent);
        }
    }
    ,
    ESTIMATE("{urn:sales_2020_2.transactions.webservices.netsuite.com}Estimate"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "EstimateItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    CREDIT_MEMO("{urn:customers_2020_2.transactions.webservices.netsuite.com}CreditMemo"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "CreditMemoItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    CUSTOMER_DEPOSIT("{urn:customers_2020_2.transactions.webservices.netsuite.com}CustomerDeposit"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isBodyCustomerPayment(), field, parent);
        }
    }
    ,
    CASH_SALE("{urn:sales_2020_2.transactions.webservices.netsuite.com}CashSale"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "CashSaleItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    CASH_REFUND("{urn:customers_2020_2.transactions.webservices.netsuite.com}CashRefund"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "CashRefundItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    CURRENCY("{urn:accounting_2020_2.lists.webservices.netsuite.com}Currency"),
    CURRENCY_RATE("{urn:accounting_2020_2.lists.webservices.netsuite.com}CurrencyRate"),
    CUSTOMER_PAYMENT("{urn:customers_2020_2.transactions.webservices.netsuite.com}CustomerPayment"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isBodyCustomerPayment(), field, parent);
        }
    }
    ,
    JOURNAL_ENTRY("{urn:general_2020_2.transactions.webservices.netsuite.com}JournalEntry"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "JournalEntryLine", field.isBodyJournal(), field.isColJournal(), field, parent);
        }
    }
    ,
    NON_INVENTORY_PURCHASE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}NonInventoryPurchaseItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToNonInventory(), field, parent);
        }
    }
    ,
    NON_INVENTORY_SALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}NonInventorySaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToNonInventory(), field, parent);
        }
    }
    ,
    NON_INVENTORY_RESALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}NonInventoryResaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToNonInventory(), field, parent);
        }
    }
    ,
    ASSEMBLY_ITEM("{http://mulesoft.org/connectors/netsuite}AssemblyItem", "{urn:accounting_2020_2.lists.webservices.netsuite.com}AssemblyItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToItemAssembly(), field, parent);
        }
    }
    ,
    JOB("{urn:relationships_2020_2.lists.webservices.netsuite.com}Job"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToProject(), field, parent);
        }
    }
    ,
    VENDOR("{urn:relationships_2020_2.lists.webservices.netsuite.com}Vendor"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToVendor(), field, parent);
        }
    }
    ,
    PURCHASE_ORDER("{urn:purchases_2020_2.transactions.webservices.netsuite.com}PurchaseOrder"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "PurchaseOrderItem", field.isBodyPurchase(), field.isColPurchase(), field, parent);
        }
    }
    ,
    VENDOR_BILL("{urn:purchases_2020_2.transactions.webservices.netsuite.com}VendorBill"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "VendorBillItem", field.isBodyPurchase(), field.isColPurchase(), field, parent);
        }
    }
    ,
    TIME_BILL("{urn:employees_2020_2.transactions.webservices.netsuite.com}TimeBill"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "TimeBill", false, field.isColTime(), field, parent);
        }
    }
    ,
    TIME_SHEET("{http://mulesoft.org/connectors/netsuite}TimeSheet", "{urn:employees_2020_2.transactions.webservices.netsuite.com}TimeSheet"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "TimeSheet", false, field.isColTime(), field, parent);
        }
    }
    ,
    RETURN_AUTHORIZATION("{urn:customers_2020_2.transactions.webservices.netsuite.com}ReturnAuthorization"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "ReturnAuthorizationItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    KIT_ITEM("{http://mulesoft.org/connectors/netsuite}KitItem", "{urn:accounting_2020_2.lists.webservices.netsuite.com}KitItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToKit(), field, parent);
        }
    }
    ,
    ITEM_FULFILLMENT("{urn:sales_2020_2.transactions.webservices.netsuite.com}ItemFulfillment"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "ItemFulfillmentItem", field.isBodyItemFulfillment(), field.isColItemFulfillment(), field, parent);
        }
    }
    ,
    SERVICE_PURCHASE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}ServicePurchaseItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToService(), field, parent);
        }
    }
    ,
    SERVICE_SALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}ServiceSaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToService(), field, parent);
        }
    }
    ,
    SERVICE_RESALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}ServiceResaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToService(), field, parent);
        }
    }
    ,
    ITEM_GROUP("{http://mulesoft.org/connectors/netsuite}ItemGroup", "{urn:accounting_2020_2.lists.webservices.netsuite.com}ItemGroup"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToGroup(), field, parent);
        }
    }
    ,
    LOT_NUMBERED_INVENTORY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}LotNumberedInventoryItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    PARTNER("{urn:relationships_2020_2.lists.webservices.netsuite.com}Partner"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    PROSPECT("{urn:relationships_2020_2.lists.webservices.netsuite.com}Customer"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    LEAD("{urn:relationships_2020_2.lists.webservices.netsuite.com}Customer"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    INVENTORY_ADJUSTMENT("{urn:inventory_2020_2.transactions.webservices.netsuite.com}InventoryAdjustment"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    ITEM_RECEIPT("{urn:purchases_2020_2.transactions.webservices.netsuite.com}ItemReceipt"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "ItemReceipt", field.isBodyItemReceipt(), field.isColItemFulfillment(), field, parent);
        }
    }
    ,
    TRANSFER_ORDER("{urn:inventory_2020_2.transactions.webservices.netsuite.com}TransferOrder"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("TransactionSearchBasic", "SalesOrderItem", field.isBodySale(), field.isColSale(), field, parent);
        }
    }
    ,
    OTHER_CHARGE_PURCHASE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}OtherChargePurchaseItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToOtherCharge(), field, parent);
        }
    }
    ,
    OTHER_CHARGE_RESALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}OtherChargeResaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToOtherCharge(), field, parent);
        }
    }
    ,
    OTHER_CHARGE_SALE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}OtherChargeSaleItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToOtherCharge(), field, parent);
        }
    }
    ,
    GIFT_CERTIFICATE_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}GiftCertificateItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToNonInventory(), field, parent);
        }
    }
    ,
    SERIALIZED_ASSEMBLY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}SerializedAssemblyItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToItemAssembly(), field, parent);
        }
    }
    ,
    SERIALIZED_INVENTORY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}SerializedInventoryItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    LOT_NUMBERED_ASSEMBLY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}LotNumberedAssemblyItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToItemAssembly(), field, parent);
        }
    }
    ,
    BILLING_SCHEDULE("{urn:accounting_2020_2.lists.webservices.netsuite.com}BillingSchedule"),
    CLASSIFICATION("{urn:accounting_2020_2.lists.webservices.netsuite.com}Classification"),
    SUBSIDIARY("{urn:accounting_2020_2.lists.webservices.netsuite.com}Subsidiary"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    LOCATION("{urn:accounting_2020_2.lists.webservices.netsuite.com}Location"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    DEPARTMENT("{urn:accounting_2020_2.lists.webservices.netsuite.com}Department"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    PRICE_LEVEL("{urn:accounting_2020_2.lists.webservices.netsuite.com}PriceLevel"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    };

    private final String qname;
    private final String qNameOriginal;

    private CitizenRecordEnum(String qname) {
        this(qname, (String)null);
    }

    private CitizenRecordEnum(String qName, String qNameOriginal) {
        this.qname = qName;
        this.qNameOriginal = qNameOriginal;
    }

    public String getQName() {
        return this.qname;
    }

    public String getQNameForRequest() {
        return this.qNameOriginal != null ? this.qNameOriginal : this.qname;
    }

    public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
        return false;
    }

    public boolean appliesToDefault(boolean appliesTo, CustomFieldWrapper field, ObjectFieldType parent) {
        switch (field.getType()) {
            case "OtherCustomField": {
                return CitizenRecordEnum.appliesToOther(field, parent);
            }
            case "EntityCustomField": {
                return (XMLUtils.getEntity(this.getQName()).equals(CitizenRecordEnum.getParentName(parent)) || this.isStandardSearchBasic(parent)) && appliesTo;
            }
        }
        return appliesTo;
    }

    private boolean isStandardSearchBasic(ObjectFieldType parent) {
        return (XMLUtils.getEntity(this.getQName()) + "SearchBasic").equals(CitizenRecordEnum.getParentName(parent));
    }

    public boolean appliesToItem(String searchClass, String fieldName, boolean isBodyType, boolean isColType, CustomFieldWrapper field, ObjectFieldType parent) {
        switch (field.getType()) {
            case "TransactionBodyCustomField": {
                return (searchClass.equals(CitizenRecordEnum.getParentName(parent)) || XMLUtils.getEntity(this.getQName()).equals(CitizenRecordEnum.getParentName(parent))) && isBodyType;
            }
            case "TransactionColumnCustomField": {
                return fieldName.equals(CitizenRecordEnum.getParentName(parent)) && isColType;
            }
            case "OtherCustomField": {
                return CitizenRecordEnum.appliesToOther(field, parent);
            }
        }
        return false;
    }

    private static Boolean appliesToOther(CustomFieldWrapper field, ObjectFieldType parent) {
        return Arrays.stream(CitizenOtherCustomFieldTypeEnum.values()).filter(s -> s.getObjType().equals(CitizenRecordEnum.getParentName(parent))).anyMatch(s -> s.getRecType().equals(field.getRecTypeName()));
    }

    private static String getParentName(ObjectFieldType parent) {
        return parent.getValue().getAnnotation(TypeIdAnnotation.class).map(typeAnnotation -> XMLUtils.getEntity(typeAnnotation.getValue())).orElse(null);
    }
}

