/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenInputRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenSourceMetadataResolver
implements TypeKeysResolver,
OutputTypeResolver<String> {
    private static final Logger logger = LoggerFactory.getLogger(CitizenInputRecordResolver.class);
    private static final Set<MetadataKey> METADATA_KEYS = Arrays.stream(CitizenSourceRecordEnum.values()).filter(CitizenSourceMetadataResolver::isRecordTypeSupportedForTrigger).map(field -> MetadataKeyBuilder.newKey((String)field.name()).withDisplayName(field.name()).build()).collect(Collectors.toSet());

    public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException {
        logger.info("Output resolver for {}", (Object)key);
        return CitizenMetadataUtils.loadMetaData(context, key, false);
    }

    public Set<MetadataKey> getKeys(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        Set<MetadataKey> customObjectKeys = null;
        try {
            customObjectKeys = new CitizenMetadataRecordResolver(context).getCustomObjectKeys();
            return Sets.union(METADATA_KEYS, customObjectKeys);
        }
        catch (ConnectionException | MetadataResolvingException e) {
            logger.error("Error retrieving metadata keys", e);
            throw e;
        }
    }

    public String getResolverName() {
        return CitizenSourceMetadataResolver.class.getSimpleName();
    }

    public String getCategoryName() {
        return "CITIZEN_NETSUITE_RECORD_CATEGORY_SOURCE";
    }

    public static boolean isRecordTypeSupportedForTrigger(CitizenSourceRecordEnum recordType) {
        return !recordType.getOnNewSearchField().equals("NotSupported");
    }
}

