/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.group.InputRecordKey;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenUpdateOutputResolver
implements OutputTypeResolver<InputRecordKey> {
    private Logger LOGGER = LoggerFactory.getLogger(CitizenUpdateOutputResolver.class);

    public String getResolverName() {
        return CitizenUpdateOutputResolver.class.getSimpleName();
    }

    public MetadataType getOutputType(MetadataContext metadataContext, InputRecordKey key) throws MetadataResolvingException {
        if (StringUtils.isBlank((String)key.getRecordType())) {
            throw new MetadataResolvingException("Record type must be set", FailureCode.INVALID_METADATA_KEY);
        }
        long start = System.currentTimeMillis();
        this.LOGGER.info("Output resolution for {}", (Object)key);
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType();
        objectBuilder.addField().key("internalID").required().value().stringType();
        long stop = System.currentTimeMillis();
        this.LOGGER.info(String.format("RECORD_OUTPUT_METADATA-getOutputType-CitizenUpdateOutputResolver: key: %s, time: %s seconds", key, (stop - start) / 1000L));
        return objectBuilder.build();
    }

    public String getCategoryName() {
        return "CITIZEN_NETSUITE_RECORD_CATEGORY";
    }
}

