/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.GetRecordsEntityProviderKeyMetadataResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenSearchTypeEnum;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRecordsConditionListEntityProvider
extends GetRecordsEntityProviderKeyMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRecordsConditionListEntityProvider.class);
    private static final Set<String> SUPPORTED_TYPES = new HashSet<String>(Arrays.asList("SearchBooleanField", "SearchStringField", "SearchLongField", "SearchTextNumberField", "SearchDoubleField", "SearchDateField", "SearchBooleanCustomField", "SearchStringCustomField", "SearchLongCustomField", "SearchDoubleCustomField", "SearchDateCustomField"));

    public String getCategoryName() {
        return GetRecordsConditionListEntityProvider.class.getSimpleName();
    }

    @Override
    protected String getCustomFieldSuffix(CitizenCustomFieldRefType ref) {
        String fieldName;
        switch (fieldName = ref.getNetsuiteValue().replace("Ref", "")) {
            case "SelectCustomField": {
                return "Search" + fieldName.replace("SelectCustomField", "MultiSelectCustomField");
            }
            case "SelectCustomListField": {
                return "Search" + fieldName.replace("SelectCustomListField", "MultiSelectCustomField");
            }
            case "MultiSelectCustomListField": {
                return "Search" + fieldName.replace("MultiSelectCustomListField", "MultiSelectCustomField");
            }
        }
        return "Search" + fieldName;
    }

    public MetadataType getOutputType(MetadataContext context, String key) throws ConnectionException, MetadataResolvingException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new MetadataResolvingException("Record type cannot be empty", FailureCode.INVALID_METADATA_KEY);
        }
        try {
            LOGGER.info("Output resolver for {}", (Object)key);
            String qName = "{http://mulesoft.org/connectors/netsuite}" + this.getSchemaClass(key);
            LOGGER.debug("Search class used for {}: {}", (Object)key, (Object)qName);
            ObjectType type = CitizenMetadataUtils.loadCitizenMetadata(context, SearchUtils.isCustomRecordType(key) != false ? key : key.toUpperCase(), ref -> this.getCustomFieldSuffix((CitizenCustomFieldRefType)((Object)ref)), true, false, qName);
            ObjectFieldType recordType = (ObjectFieldType)type.getFields().iterator().next();
            this.removeFieldFromRecord(recordType, "type");
            Optional<ObjectFieldType> list = type.getFields().stream().map(ObjectFieldType::getValue).map(ObjectType.class::cast).map(ObjectType::getFields).flatMap(Collection::stream).filter(field -> field.getKey().getName().getLocalPart().equals("customFieldList")).findFirst();
            if (list.isPresent()) {
                ObjectType fieldList = (ObjectType)list.get().getValue();
                fieldList.getFields().forEach(field -> ((ObjectType)recordType.getValue()).getFields().add(field));
                this.removeFieldFromRecord(recordType, "customFieldList");
            } else {
                LOGGER.debug("No custom field list is present");
            }
            String separator = ((NetSuiteSoapConfig)context.getConfig().get()).getAdvancedConfig().getSeparator();
            this.removeRecordRefSearchFields(recordType, separator);
            ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().id(qName).label(this.getSchemaClass(key));
            LOGGER.trace("Remapping fields to search fields");
            ((ObjectType)recordType.getValue()).getFields().forEach(field -> {
                ObjectFieldTypeBuilder newFieldBuilder = objectBuilder.addField();
                CitizenMetadataUtils.mapKey(newFieldBuilder, field, field.getKey().getName(), false);
                field.getValue().getAnnotations().forEach(annotation -> newFieldBuilder.with(annotation));
                field.getDescription().ifPresent(description -> newFieldBuilder.description(description));
                this.setFieldType(newFieldBuilder.value(), (ObjectFieldType)field, separator);
            });
            return objectBuilder.build();
        }
        catch (IllegalArgumentException | ConnectionException iae) {
            throw new MetadataResolvingException("Unsupported record type: " + key, FailureCode.INVALID_METADATA_KEY);
        }
    }

    private void setFieldType(BaseTypeBuilder valueBuilder, ObjectFieldType field, String separator) {
        Optional type = field.getValue().getAnnotation(TypeIdAnnotation.class);
        if (type.isPresent()) {
            String searchType = SearchUtils.getQName(((TypeIdAnnotation)type.get()).getValue()).getLocalPart();
            this.getType(valueBuilder, field, searchType);
        } else if (!field.getKey().getName().getLocalPart().startsWith("Search")) {
            this.getType(valueBuilder, field, "SearchStringField");
        } else {
            this.getType(valueBuilder, field, field.getKey().getName().toString().split(separator)[0]);
        }
    }

    private void getType(BaseTypeBuilder valueBuilder, ObjectFieldType field, String searchType) {
        try {
            QName qname = SearchUtils.getQName(searchType);
            CitizenSearchTypeEnum searchTypeEnum = CitizenSearchTypeEnum.getEnum(qname.getLocalPart());
            searchTypeEnum.setMetadataType(valueBuilder);
        }
        catch (IllegalArgumentException iae) {
            throw new NetSuiteSoapModuleException(String.format("Search field %s has unsupported type %s.", field.getKey().getName(), searchType), NetSuiteSoapErrorType.NETSUITE_ERROR);
        }
    }

    private void removeRecordRefSearchFields(ObjectFieldType recordType, String separator) {
        ((ObjectType)recordType.getValue()).getFields().removeIf(field -> {
            boolean toRemove;
            Optional type = field.getValue().getAnnotation(TypeIdAnnotation.class);
            String key = field.getKey().getName().toString();
            boolean bl = toRemove = type.isPresent() && this.isUnsupported(SearchUtils.getQName(((TypeIdAnnotation)type.get()).getValue()).getLocalPart()) || key.contains("CustomField") && this.isUnsupported(SearchUtils.getQName(key).getLocalPart().split(separator)[0]);
            if (toRemove) {
                LOGGER.trace("Removing unsupported search field {}", (Object)field.getKey().getName().toString());
            }
            return toRemove;
        });
    }

    private boolean isUnsupported(String name) {
        return !SUPPORTED_TYPES.contains(name);
    }

    private void removeFieldFromRecord(ObjectFieldType recordType, String fieldName) {
        ((ObjectType)recordType.getValue()).getFields().removeIf(field -> field.getKey().getName().getLocalPart().equals(fieldName));
    }

    @Override
    protected String getSchemaClass(String entityName) {
        String searchType = SearchUtils.isCustomRecordType(entityName) != false ? "CustomRecordSearchBasic" : CitizenSourceRecordEnum.valueOf(entityName).getSearchType();
        String name = searchType == null ? XMLUtils.getEntity(CitizenRecordEnum.valueOf(entityName).getQName()) + "SearchBasic" : searchType;
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

