/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GetRecordsEntityProviderKeyMetadataResolver
implements TypeKeysResolver,
OutputTypeResolver<String> {
    private static final Logger logger = LoggerFactory.getLogger(GetRecordsEntityProviderKeyMetadataResolver.class);
    private static final Set<MetadataKey> METADATA_KEYS = Arrays.stream(CitizenSourceRecordEnum.values()).map(field -> MetadataKeyBuilder.newKey((String)field.name()).withDisplayName(field.name()).build()).collect(Collectors.toSet());

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        Set<MetadataKey> customObjectKeys = null;
        try {
            customObjectKeys = new CitizenMetadataRecordResolver(context).getCustomObjectKeys();
            return Sets.union(METADATA_KEYS, customObjectKeys);
        }
        catch (ConnectionException | MetadataResolvingException e) {
            logger.error("Error retrieving metadata keys", e);
            throw e;
        }
    }

    protected abstract String getCustomFieldSuffix(CitizenCustomFieldRefType var1);

    public String getResolverName() {
        return this.getCategoryName();
    }

    protected NetSuiteSoapConnection getConnection(MetadataContext context) throws ConnectionException {
        return (NetSuiteSoapConnection)context.getConnection().get();
    }

    protected abstract String getSchemaClass(String var1);
}

