/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata.util;

import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenActionRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.metadata.factory.CachedXmlTypeLoader;
import com.mulesoft.connector.netsuite.internal.util.NetSuiteConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;
import org.mule.wsdl.parser.WsdlSchemasCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class CitizenMetadataUtils {
    public static final String WSDL_NETSUITE_WSDL = NetSuiteConstants.WSDL_DEFAULT_LOCATION + "/netsuite.wsdl";
    private static final Logger logger = LoggerFactory.getLogger(CitizenMetadataUtils.class);
    private static final LazyValue<XmlTypeLoader> typeLoader = new LazyValue(() -> {
        try {
            logger.debug("Starting reading XSD files...");
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(Thread.currentThread().getContextClassLoader().getResource(WSDL_NETSUITE_WSDL).toString());
            WsdlSchemasCollector wsdlSchemasCollector = new WsdlSchemasCollector(def, "UTF-8");
            Map schemas = wsdlSchemasCollector.toInMemorySchemaMap();
            SchemaCollector schemaCollector = SchemaCollector.getInstance();
            schemas.keySet().stream().filter(path -> path.endsWith(".xsd")).forEach(path -> {
                try {
                    logger.trace("Adding XSD file {} ", path);
                    schemaCollector.addSchema(new URL((String)path));
                }
                catch (MalformedURLException e) {
                    throw new NetSuiteSoapModuleException("Unable to process schema files.", NetSuiteSoapErrorType.NETSUITE_ERROR);
                }
            });
            logger.trace("Adding artificial XSD file 'wsdl/connector.xsd'");
            schemaCollector.addSchema(new URL(Thread.currentThread().getContextClassLoader().getResource(NetSuiteConstants.WSDL_DEFAULT_LOCATION + "/connector.xsd").toString()));
            return new CachedXmlTypeLoader(schemaCollector);
        }
        catch (MalformedURLException | WSDLException e) {
            throw new NetSuiteSoapModuleException("Unable to process schema files.", NetSuiteSoapErrorType.NETSUITE_ERROR);
        }
    });

    private CitizenMetadataUtils() {
    }

    public static void unwrapRootFieldAndMap(MetadataContext context, ObjectTypeBuilder builder, ObjectType objectType, String fieldName, String wsdlVersion, String record, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomFields, boolean fetchCustomLists) throws ConnectionException, MetadataResolvingException {
        ObjectFieldType rootField = (ObjectFieldType)objectType.getFields().iterator().next();
        ObjectType rootValue = (ObjectType)rootField.getValue();
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().label(fieldName);
        List mappedFields = rootValue.getFields().stream().filter(field -> !field.getKey().getName().getLocalPart().equals("nullFieldList")).map(field -> CitizenMetadataUtils.mapField(field, objectBuilder)).collect(Collectors.toList());
        rootValue.getFields().clear();
        rootValue.getFields().addAll(mappedFields);
        if (fetchCustomFields || SearchUtils.isCustomRecordType(record).booleanValue()) {
            CitizenMetadataRecordResolver resolver = new CitizenMetadataRecordResolver(context);
            if (SearchUtils.isCustomRecordType(record).booleanValue()) {
                logger.debug("Fetching custom fields for custom object type {}", (Object)record);
                resolver.generateCustomFieldsForCustomType(record, rootField, builder, ((NetSuiteSoapConfig)context.getConfig().get()).getAdvancedConfig().getSeparator(), metadataKeyFunction, fetchCustomLists);
            } else {
                logger.debug("Fetching custom fields for standard type {}", (Object)record);
                resolver.generateCustomMetadataTypes(record, rootField, metadataKeyFunction, fetchCustomLists);
            }
        }
        ObjectFieldTypeBuilder newFieldBuilder = builder.addField();
        QName name = new QName(String.format("urn:core_%s.platform.webservices.netsuite.com", wsdlVersion), fieldName);
        CitizenMetadataUtils.mapKey(newFieldBuilder, rootField, name);
        newFieldBuilder.value((MetadataType)rootValue);
    }

    public static MetadataType loadMetaData(MetadataContext context, String key, boolean fetchCustomLists) throws MetadataResolvingException {
        return CitizenMetadataUtils.loadMetaData(context, key, ref -> ref.getNetsuiteValue(), true, fetchCustomLists);
    }

    public static MetadataType loadMetaData(MetadataContext context, String key, boolean fetchCustomFields, boolean fetchCustomLists) throws MetadataResolvingException {
        return CitizenMetadataUtils.loadMetaData(context, key, ref -> ref.getNetsuiteValue(), fetchCustomFields, fetchCustomLists);
    }

    public static MetadataType loadMetaData(MetadataContext context, String key, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomFields, boolean fetchCustomLists) throws MetadataResolvingException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new MetadataResolvingException("Record type must be set", FailureCode.INVALID_METADATA_KEY);
        }
        try {
            CitizenRecordEnum recordType;
            ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType();
            if (SearchUtils.isCustomRecordType(key).booleanValue()) {
                recordType = CitizenRecordEnum.CUSTOM_RECORD;
            } else {
                recordType = CitizenRecordEnum.valueOf(key);
                objectBuilder.label(key);
            }
            String qName = recordType.getQName();
            ObjectType type = CitizenMetadataUtils.loadStaticMetadata(qName);
            CitizenMetadataUtils.unwrapRootFieldAndMap(context, objectBuilder, type, "record", WsdlVersion.getDefaultWsdlVersionStr(), key, metadataKeyFunction, fetchCustomFields, fetchCustomLists);
            return objectBuilder.build();
        }
        catch (IllegalArgumentException | ConnectionException iae) {
            logger.error("Error generating metadata for {}, ", (Object)key, (Object)iae);
            throw new MetadataResolvingException("Unsupported record type: " + key, FailureCode.INVALID_METADATA_KEY);
        }
    }

    public static ObjectType loadCitizenMetadata(MetadataContext context, String key, Function<CitizenCustomFieldRefType, String> metadataKeyFunction, boolean fetchCustomFields, boolean fetchCustomLists, String qName) throws MetadataResolvingException, ConnectionException {
        ObjectType type = CitizenMetadataUtils.loadStaticMetadata(qName);
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType();
        CitizenMetadataUtils.unwrapRootFieldAndMap(context, objectBuilder, type, "record", WsdlVersion.getDefaultWsdlVersionStr(), key, metadataKeyFunction, fetchCustomFields, fetchCustomLists);
        return objectBuilder.build();
    }

    public static ObjectFieldType mapField(ObjectFieldType field, ObjectTypeBuilder builder) {
        ObjectFieldTypeBuilder newFieldBuilder = CitizenMetadataUtils.createObjectFieldTypeBuilder(field, builder);
        if (field.getValue() instanceof ObjectType) {
            ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType();
            Collection childFields = ((ObjectType)field.getValue()).getFields();
            List<ObjectFieldType> fields = childFields.stream().filter(fieldType -> !fieldType.getKey().getName().getLocalPart().equals("nullFieldList")).map(childField -> CitizenMetadataUtils.mapField(childField, objectBuilder)).collect(Collectors.toList());
            childFields.clear();
            fields.forEach(field1 -> childFields.add(field1));
        }
        if (field.getValue() instanceof DateType) {
            CitizenMetadataUtils.addFormatToDateTimeField(newFieldBuilder);
            return newFieldBuilder.build();
        }
        if (field.getValue() instanceof NumberType) {
            newFieldBuilder.value().numberType();
            return newFieldBuilder.build();
        }
        logger.trace("Remapping field {} finished.", (Object)field.getKey().getName());
        return newFieldBuilder.value(field.getValue()).build();
    }

    private static ObjectFieldTypeBuilder createObjectFieldTypeBuilder(ObjectFieldType field, ObjectTypeBuilder builder) {
        ObjectFieldTypeBuilder newFieldBuilder = builder.addField();
        CitizenMetadataUtils.mapKey(newFieldBuilder, field, field.getKey().getName());
        if (!(field.getValue() instanceof NumberType)) {
            field.getValue().getAnnotations().forEach(annotation -> newFieldBuilder.with(annotation));
        }
        field.getDescription().ifPresent(description -> newFieldBuilder.description(description));
        return newFieldBuilder;
    }

    public static void addFormatToDateTimeField(ObjectFieldTypeBuilder fieldBuilder) {
        fieldBuilder.value().dateTimeType().with((TypeAnnotation)new RegexPatternAnnotation("YYYY-MM-DDThh:mm:ss"));
    }

    public static void mapKey(ObjectFieldTypeBuilder fieldTypeBuilder, ObjectFieldType field, QName name) {
        CitizenMetadataUtils.mapKey(fieldTypeBuilder, field, name, true);
    }

    public static void mapKey(ObjectFieldTypeBuilder fieldTypeBuilder, ObjectFieldType field, QName name, boolean copyAttributes) {
        ObjectKeyBuilder key = CitizenMetadataUtils.mapKeyExceptAttributes(fieldTypeBuilder, field, name);
        if (copyAttributes) {
            CitizenMetadataUtils.copyKeyAttributes(field, key);
        }
    }

    private static ObjectKeyBuilder mapKeyExceptAttributes(ObjectFieldTypeBuilder fieldTypeBuilder, ObjectFieldType field, QName name) {
        field.getKey().getAnnotations().stream().forEach(annotation -> fieldTypeBuilder.withKeyAnnotation(annotation));
        ObjectKeyBuilder key = fieldTypeBuilder.key(name);
        if (name.toString().contains("CustomField")) {
            Optional annotation2 = field.getKey().getAnnotation(LabelAnnotation.class);
            fieldTypeBuilder.label(((LabelAnnotation)annotation2.get()).getValue());
        } else {
            fieldTypeBuilder.label(CitizenMetadataUtils.getLabel(name));
        }
        fieldTypeBuilder.required(field.isRequired());
        fieldTypeBuilder.repeated(field.isRepeated());
        return key;
    }

    public static void mapKey(ObjectFieldTypeBuilder fieldTypeBuilder, ObjectFieldType field, QName name, List<String> attributes) throws MetadataResolvingException {
        ObjectKeyBuilder key = CitizenMetadataUtils.mapKeyExceptAttributes(fieldTypeBuilder, field, name);
        if (attributes != null) {
            CitizenMetadataUtils.filterAndCopyKeyAttributes(field, key, attributes);
        }
    }

    public static String getLabel(QName name) {
        return Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)name.getLocalPart())).map(word -> StringUtils.capitalize((String)word)).collect(Collectors.joining(" "));
    }

    public static void copyKeyAttributes(ObjectFieldType field, ObjectKeyBuilder key) {
        field.getKey().getAttributes().forEach(attr -> CitizenMetadataUtils.mapAttribute(key, attr));
    }

    public static void filterAndCopyKeyAttributes(ObjectFieldType field, ObjectKeyBuilder key, List<String> attributes) throws MetadataResolvingException {
        Set fieldAttr = field.getKey().getAttributes().stream().map(attr -> attr.getKey().getName().toString()).collect(Collectors.toSet());
        for (String attr2 : attributes) {
            if (fieldAttr.contains(attr2)) continue;
            throw new MetadataResolvingException("Could not find attribute " + attr2 + " on " + field.getKey().getName().toString(), FailureCode.INVALID_METADATA_KEY);
        }
        field.getKey().getAttributes().stream().filter(attr -> attributes.contains(attr.getKey().getName().toString())).forEach(attr -> CitizenMetadataUtils.mapAttribute(key, attr));
    }

    private static void mapAttribute(ObjectKeyBuilder key, AttributeFieldType attr) {
        AttributeFieldTypeBuilder attrBuilder = key.addAttribute().name(attr.getKey().getName());
        attrBuilder.required(attr.isRequired());
        attrBuilder.value().stringType();
        if (attr.getKey().isPattern()) {
            attrBuilder.pattern(attr.getKey().getPattern());
        }
    }

    public static LazyValue<XmlTypeLoader> getTypeLoader() {
        return typeLoader;
    }

    public static ObjectFieldTypeBuilder addField(ObjectFieldType fieldType, ObjectTypeBuilder parentBuilder, List<String> attributes) throws MetadataResolvingException {
        ObjectFieldTypeBuilder fieldTypeBuilder = parentBuilder.addField();
        QName name = fieldType.getKey().getName();
        CitizenMetadataUtils.mapKey(fieldTypeBuilder, fieldType, name, attributes);
        return fieldTypeBuilder;
    }

    public static ObjectTypeBuilder copyValue(ObjectFieldType field, ObjectFieldTypeBuilder newFieldBuilder) {
        ObjectTypeBuilder valueBuilder = newFieldBuilder.value().objectType();
        field.getValue().getAnnotations().forEach(annotation -> valueBuilder.with(annotation));
        field.getDescription().ifPresent(description -> valueBuilder.description(description));
        return valueBuilder;
    }

    public static void filterMetadata(List<QName> path, ObjectType originalType, Map<String, ObjectTypeBuilder> fieldTypeBuilderMap, Map<String, List<String>> attributeMap) throws MetadataResolvingException {
        ObjectType current = originalType;
        StringBuilder fullPath = new StringBuilder("");
        for (int i = 0; i < path.size(); ++i) {
            String pathName = path.get(i).toString();
            ObjectTypeBuilder parentField = fieldTypeBuilderMap.get(fullPath.toString());
            boolean isAttribute = pathName.startsWith("{_@}");
            fullPath = fullPath.append(pathName);
            if (isAttribute) continue;
            ObjectFieldType found = current.getFields().stream().filter(field -> field.getKey().getName().toString().equals(pathName)).findFirst().orElseThrow(() -> new MetadataResolvingException(String.format("Could not find %s in path.", pathName), FailureCode.INVALID_METADATA_KEY));
            current = found.getValue();
            if (fieldTypeBuilderMap.containsKey(fullPath.toString())) continue;
            List<String> attributes = attributeMap.get(fullPath.toString());
            ObjectFieldTypeBuilder currentFieldBuilder = CitizenMetadataUtils.addField(found, parentField, attributes);
            if (current instanceof ObjectType) {
                ObjectTypeBuilder typeBuilder = CitizenMetadataUtils.copyValue(found, currentFieldBuilder);
                fieldTypeBuilderMap.put(fullPath.toString(), typeBuilder);
                continue;
            }
            currentFieldBuilder.value((MetadataType)current);
        }
    }

    public static String getMetadataFieldKey(String type, String separator, String scriptId, String internalId, String customListInternalId) {
        return StringUtils.isBlank((CharSequence)customListInternalId) ? String.join((CharSequence)separator, CitizenMetadataUtils.convertPathName(type), scriptId, internalId) : String.join((CharSequence)separator, type, scriptId, internalId, customListInternalId);
    }

    public static String getXmlAttribute(Node node, String key) {
        return node.getAttributes().getNamedItem(key).getTextContent();
    }

    public static String[] splitCustomRecordKey(String recordType, NetSuiteSoapConfig config) {
        String[] parts = recordType.split(config.getAdvancedConfig().getSeparator());
        if (parts.length != 3) {
            throw new NetSuiteSoapModuleException("Invalid custom record metadata key format", NetSuiteSoapErrorType.NETSUITE_ERROR);
        }
        return parts;
    }

    public static Set<MetadataKey> getMetadataKeys() {
        return Arrays.stream(CitizenActionRecordEnum.values()).map(field -> MetadataKeyBuilder.newKey((String)field.name()).withDisplayName(field.name()).build()).collect(Collectors.toSet());
    }

    private static String convertPathName(String pathName) {
        pathName = pathName.contains("MultiSelectCustomListField") ? pathName.replace("MultiSelectCustomListField", "MultiSelectCustomField") : pathName;
        pathName = pathName.contains("SelectCustomListField") ? pathName.replace("SelectCustomListField", "SelectCustomField") : pathName;
        return pathName;
    }

    public static CitizenRecordEnum getRecordEnum(String key) {
        return SearchUtils.isCustomRecordType(key) != false ? CitizenRecordEnum.CUSTOM_RECORD : CitizenRecordEnum.valueOf(key);
    }

    public static ObjectType loadStaticMetadata(String qName) throws MetadataResolvingException {
        return (ObjectType)CitizenMetadataUtils.loadStaticSchema(qName).orElseThrow(() -> new MetadataResolvingException("Could not find record type metadata", FailureCode.INVALID_METADATA_KEY));
    }

    private static Optional<MetadataType> loadStaticSchema(String qName) {
        Optional s = ((XmlTypeLoader)CitizenMetadataUtils.getTypeLoader().get()).load(qName);
        if (s.isPresent()) {
            return s;
        }
        return ((XmlTypeLoader)CitizenMetadataUtils.getTypeLoader().get()).load(CitizenMetadataUtils.underscoreQNameCapitalLetter(qName));
    }

    private static String underscoreQNameCapitalLetter(String qName) {
        String[] qNameParts = qName.split("}");
        return String.format("%s}%s%s", qNameParts[0], Character.valueOf(Character.toLowerCase(qNameParts[1].charAt(0))), qNameParts[1].substring(1));
    }
}

