/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.operation;

import com.google.common.base.CaseFormat;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.error.provider.NetSuiteCitizenErrorTypeProvider;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenActionOutputResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenGetOutputRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenGetRecordsOutputTypeResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenInputExtIdRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenInputKeysMetadataResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenInputRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenUpdateOutputResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.GetRecordsConditionListEntityProvider;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.GetRecordsFieldListEntityProvider;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.group.InputRecordKey;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.provider.IdTypeValueProvider;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.model.Behavior;
import com.mulesoft.connector.netsuite.internal.citizen.pagination.CitizenPaginatedGetRecords;
import com.mulesoft.connector.netsuite.internal.citizen.sampledata.GetRecordsSampleDataProvider;
import com.mulesoft.connector.netsuite.internal.citizen.sampledata.InternalIDSampleDataProvider;
import com.mulesoft.connector.netsuite.internal.citizen.sampledata.RecordSampleDataProvider;
import com.mulesoft.connector.netsuite.internal.citizen.util.FilteringUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.TransformationUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.provider.NetSuiteErrorTypeProvider;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputXmlType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenOperations {
    private static final String EXTERNAL = "EXTERNAL";
    private static final String RECORD_TYPE = "recordType";
    private static final Logger logger = LoggerFactory.getLogger(CitizenOperations.class);
    private final RecordOperations operations = new RecordOperations();
    public static final String INTERNAL_ID = "internalID";
    private static final String MESSAGES_NAMESPACE = "var ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\n";
    private static final String CORE_NAMESPACE = "var ns2 = {uri: \"urn:core_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns2\"} as Namespace\n";
    private static final String ADD_RECORD_OUTPUT = "%dw 2.0\noutput application/xml writeDeclaration=false\nvar ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\n---\ninternalID: payload.ns1#addResponse.ns1#writeResponse.ns1#baseRef.@internalId";
    private static final String GET_RECORD_OUTPUT = "%dw 2.0\noutput application/xml\nvar ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\nvar ns2 = {uri: \"urn:core_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns2\"} as Namespace\nns xsi http://www.w3.org/2001/XMLSchema-instance\n ---\n{\n   ns1#get: {\n       ns2#baseRef @(internalId: payload.id , \"type\": payload.recordType, xsi#\"type\": \"ns2:RecordRef\"): null\n   }\n}";
    private static final String GET_CUSTOM_RECORD_OUTPUT = "%dw 2.0\noutput application/xml\nvar ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\nvar ns2 = {uri: \"urn:core_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns2\"} as Namespace\nns xsi http://www.w3.org/2001/XMLSchema-instance\n ---\n{\n   ns1#get: {\n       ns2#baseRef @(typeId: payload.typeId, internalId: payload.id , xsi#\"type\": \"ns2:CustomRecordRef\"): null\n   }\n}";
    private static final String GET_RECORDS_OUTPUT = "%dw 2.0\noutput application/xml\n ---\npayload";
    private static final String UPDATE_RECORD_OUTPUT = "%dw 2.0\noutput application/xml writeDeclaration=false\nvar ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\n---\ninternalID: payload.ns1#updateResponse.ns1#writeResponse.ns1#baseRef.@internalId";
    private static final String UPSERT_RECORD_XML_EXPRESION_OUTPUT = "%dw 2.0\noutput application/xml writeDeclaration=false\nvar ns1 = {uri: \"urn:messages_\" ++ wsdlVersion ++ \".platform.webservices.netsuite.com\", prefix: \"ns1\"} as Namespace\n---\ninternalID: payload.ns1#upsertResponse.ns1#writeResponse.ns1#baseRef.@internalId";
    private static final String DW_RECORD_EXTRACTION = "(payload.getResponse.readResponse - 'status')";

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @DisplayName(value="Citizen Add Record")
    @Summary(value="Creates a new record in the NetSuite.")
    @OutputResolver(output=CitizenActionOutputResolver.class)
    @SampleData(value=InternalIDSampleDataProvider.class)
    @Ignore
    public Result<InputStream, Void> citizenAddRecord(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @DisplayName(value="Type of Record") @MetadataKeyId(value=CitizenInputRecordResolver.class) String recordType, @TypeResolver(value=CitizenInputExtIdRecordResolver.class) @DisplayName(value="Fields Associated to the Record") @Content TypedValue<InputStream> record) {
        InputStream transformedInput = TransformationUtils.inputStreamToNetsuiteXml((InputStream)record.getValue(), recordType, "", EXTERNAL, "add", config, connection, null);
        logger.debug("Adding a record of {}.", (Object)recordType);
        Result<InputStream, NetsuiteSoapAttributes> response = this.operations.add(config, connection, CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, recordType), transformedInput);
        logger.trace("Adding a record of {} finished.", (Object)recordType);
        return Result.builder().output((Object)connection.getDocumentFactory().transform(ADD_RECORD_OUTPUT, (InputStream)response.getOutput())).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_XML).build();
    }

    @Throws(value={NetSuiteErrorTypeProvider.class})
    @DisplayName(value="Citizen Delete Record")
    @Summary(value="Deletes a record from the NetSuite. Not all records can be deleted. Consult NetSuite documentation.")
    @Ignore
    public Result<Void, Void> citizenDeleteRecord(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @DisplayName(value="Type of Record") @OfValues(value=CitizenInputRecordResolver.class) String recordType, @DisplayName(value="ID Value") @Example(value="101") String id, @DisplayName(value="ID Type") @OfValues(value=IdTypeValueProvider.class) String idType) {
        String recordTypeRef;
        String recordTypeIdentifier;
        String idStatement;
        logger.debug("Deleting a record of {} with {} ID {}.", new Object[]{recordType, idType, id});
        String string = idStatement = idType.equals(EXTERNAL) ? "externalId=\"" + id + "\"" : "internalId=\"" + id + "\"";
        if (SearchUtils.isCustomRecordType(recordType).booleanValue()) {
            String[] parts = CitizenMetadataUtils.splitCustomRecordKey(recordType, config);
            recordTypeIdentifier = idStatement + " typeId=\"" + parts[2] + "\"";
            recordTypeRef = "CustomRecordRef";
        } else {
            recordTypeIdentifier = idStatement + " type=\"" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, recordType) + "\"";
            recordTypeRef = "RecordRef";
        }
        String deleteRawRequest = "<?xml version='1.0' encoding='UTF-8'?>\n<ns0:delete xmlns:ns0=\"urn:messages_2020_2.platform.webservices.netsuite.com\">\n  <ns01:baseRef xmlns:ns01=\"urn:core_2020_2.platform.webservices.netsuite.com\" " + recordTypeIdentifier + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns01:" + recordTypeRef + "\"/>\n</ns0:delete>";
        this.operations.delete(config, connection, null, new ByteArrayInputStream(deleteRawRequest.getBytes(StandardCharsets.UTF_8)));
        logger.trace("Deleting a record of {} with {} ID {} finished.", new Object[]{recordType, idType, id});
        return Result.builder().build();
    }

    @Throws(value={NetSuiteErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @OutputResolver(output=CitizenGetOutputRecordResolver.class)
    @DisplayName(value="Citizen Get Record")
    @Summary(value="Used to retrieve a record by providing the unique id that identifies that record.")
    @SampleData(value=RecordSampleDataProvider.class)
    @Ignore
    public Result<InputStream, Void> citizenGetRecord(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @DisplayName(value="Type of Record") @MetadataKeyId(value=CitizenInputRecordResolver.class) String recordType, @DisplayName(value="ID Value") @Example(value="101") String id, @DisplayName(value="ID Type") @OfValues(value=IdTypeValueProvider.class) String idType) {
        String getRecordOutput;
        logger.debug("Getting a record of {} with {} ID {}.", new Object[]{recordType, idType, id});
        String internalId = idType.equals("INTERNAL") ? id : null;
        String camelCaseRecordType = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, recordType);
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        inputParams.put("id", id);
        if (SearchUtils.isCustomRecordType(recordType).booleanValue()) {
            inputParams.put(RECORD_TYPE, "CustomRecordRef");
            String[] parts = CitizenMetadataUtils.splitCustomRecordKey(recordType, config);
            inputParams.put("typeId", parts[2]);
            getRecordOutput = GET_CUSTOM_RECORD_OUTPUT;
        } else {
            inputParams.put(RECORD_TYPE, camelCaseRecordType);
            getRecordOutput = GET_RECORD_OUTPUT;
        }
        Result<InputStream, NetsuiteSoapAttributes> response = this.operations.get(config, connection, null, connection.getDocumentFactory().transform(internalId != null ? getRecordOutput : getRecordOutput.replace("internal", "external"), inputParams));
        logger.trace("Getting a record of {} with {} ID {} finished.", new Object[]{recordType, idType, id});
        return Result.builder().output((Object)connection.getDocumentFactory().transform(FilteringUtils.getOutputScript("%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payloadObject = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payloadObject, namespace) = (if (payloadObject.customFieldList != null) {\n    namespace#customFieldList: payloadObject.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payloadObject, namespace) =\n  payloadObject match {\n      case is Object -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapValue(payloadObject) =\n  payloadObject match {\n      case is Array -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapRecord(payloadObject, rec) = {\n    record : rec ++\n       ns01#customFieldList: payloadObject.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payloadObject.record.@)): recursive(payloadObject.record, payloadObject.record.#)\n", recordType, DW_RECORD_EXTRACTION), (InputStream)response.getOutput())).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_XML).build();
    }

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @DisplayName(value="Citizen Update Record")
    @Summary(value="Updates an existing record in the NetSuite.")
    @OutputResolver(output=CitizenUpdateOutputResolver.class)
    @SampleData(value=InternalIDSampleDataProvider.class)
    @Ignore
    public Result<InputStream, Void> citizenUpdateRecord(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @MetadataKeyId(value=CitizenInputKeysMetadataResolver.class) @ParameterGroup(name="Input Record Key") InputRecordKey inputRecordKey, @DisplayName(value="ID Value") @Example(value="101") String id, @ParameterGroup(name="Behavior modifiers") Behavior behavior, @TypeResolver(value=CitizenInputKeysMetadataResolver.class) @DisplayName(value="Fields to update") @Content TypedValue<InputStream> record) {
        logger.debug("Updating a record of {} with {} ID {}.", new Object[]{inputRecordKey.getRecordType(), inputRecordKey.getIdType(), id});
        InputStream transformedInput = TransformationUtils.inputStreamToNetsuiteXml((InputStream)record.getValue(), inputRecordKey.getRecordType(), id, inputRecordKey.getIdType(), "update", config, connection, behavior);
        Result<InputStream, NetsuiteSoapAttributes> response = this.operations.update(config, connection, inputRecordKey.getRecordType(), transformedInput);
        logger.trace("Updating a record of {} with {} ID {} finished.", new Object[]{inputRecordKey.getRecordType(), inputRecordKey.getIdType(), id});
        return Result.builder().output((Object)connection.getDocumentFactory().transform(UPDATE_RECORD_OUTPUT, (InputStream)response.getOutput())).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_XML).build();
    }

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @DisplayName(value="Citizen Upsert Record")
    @Summary(value="Adds a new instance or updates instance of an existing record in the NetSuite.")
    @OutputResolver(output=CitizenActionOutputResolver.class)
    @SampleData(value=InternalIDSampleDataProvider.class)
    @Ignore
    public Result<InputStream, Void> citizenUpsertRecord(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @DisplayName(value="Type of Record") @MetadataKeyId(value=CitizenInputRecordResolver.class) String recordType, @DisplayName(value="Record External ID") @Example(value="101") String externalID, @ParameterGroup(name="Behavior modifiers") Behavior behavior, @DisplayName(value="Fields to update") @TypeResolver(value=CitizenInputRecordResolver.class) @Content TypedValue<InputStream> record) {
        logger.debug("Upserting a record of {} with external ID {}.", (Object)recordType, (Object)externalID);
        InputStream transformedInput = TransformationUtils.inputStreamToNetsuiteXml((InputStream)record.getValue(), recordType, externalID, EXTERNAL, "upsert", config, connection, behavior);
        Result<InputStream, NetsuiteSoapAttributes> response = this.operations.upsert(config, connection, recordType, transformedInput);
        logger.trace("Upserting a record of {} with external ID {} finished.", (Object)recordType, (Object)externalID);
        return Result.builder().output((Object)connection.getDocumentFactory().transform(UPSERT_RECORD_XML_EXPRESION_OUTPUT, (InputStream)response.getOutput())).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_XML).build();
    }

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @DisplayName(value="Citizen Get Records")
    @Summary(value="Gets records based on the type and filters.")
    @OutputResolver(output=CitizenGetRecordsOutputTypeResolver.class)
    @SampleData(value=GetRecordsSampleDataProvider.class)
    @Ignore
    public PagingProvider<NetSuiteSoapConnection, TypedValue<String>> citizenGetRecords(@Config NetSuiteSoapConfig config, @MetadataKeyId @Content String query) {
        logger.info("Logging input query: <{}>", (Object)query);
        ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes());
        return new CitizenPaginatedGetRecords(SearchUtils.parse(is), config.getAdvancedConfig().getSeparator());
    }

    @Ignore
    public void citizenGetRecordsInputType(@InputXmlType(schema="citizen-wsdl/query.xsd", qname="query") String queryInput) {
        throw new UnsupportedOperationException("This is a dummy operation. It should not be invoked.");
    }

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @OutputResolver(output=GetRecordsFieldListEntityProvider.class)
    @Ignore
    public InputStream citizenGetRecordsFieldEntityProvider(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @MetadataKeyId(value=GetRecordsFieldListEntityProvider.class) String recordType) {
        throw new UnsupportedOperationException("This is a dummy operation. It should not be invoked.");
    }

    @Throws(value={NetSuiteCitizenErrorTypeProvider.class})
    @MediaType(value="application/xml")
    @OutputResolver(output=GetRecordsConditionListEntityProvider.class)
    @Ignore
    public InputStream citizenGetRecordsConditionsEntityProvider(@Connection NetSuiteSoapConnection connection, @Config NetSuiteSoapConfig config, @MetadataKeyId(value=GetRecordsConditionListEntityProvider.class) String recordType) {
        throw new UnsupportedOperationException("This is a dummy operation. It should not be invoked.");
    }
}

