/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.model.Condition;
import com.mulesoft.connector.netsuite.internal.citizen.model.CustomIdentifier;
import com.mulesoft.connector.netsuite.internal.citizen.model.Field;
import com.mulesoft.connector.netsuite.internal.citizen.model.Query;
import com.mulesoft.connector.netsuite.internal.citizen.util.FilteringUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.PaginatedSearch;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenPaginatedGetRecords
implements PagingProvider<NetSuiteSoapConnection, TypedValue<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitizenPaginatedGetRecords.class);
    private final Query query;
    private PaginatedSearch paginatedSearch;
    private String separator;

    public CitizenPaginatedGetRecords(Query query, String separator) {
        this.separator = separator;
        this.query = query;
    }

    public List<TypedValue<String>> getPage(NetSuiteSoapConnection connection) {
        this.paginatedSearch = Optional.ofNullable(this.paginatedSearch).orElseGet(() -> {
            String body = String.format(this.getSearchRequest(this.query.getObjectType()), this.query.getConditions().stream().filter(conditionFilter -> SearchUtils.isCustomSearchField(this.getField(conditionFilter.getField()), this.separator) == false).map(condition -> String.format("<%1$s %2$s>%3$s</%1$s>", this.getField(condition.getField()), StringUtils.isBlank((String)condition.getOperator()) ? "" : String.format("operator=\"%s\"", condition.getOperator()), this.getSearchValues((Condition)condition, condition.getOperator()))).collect(Collectors.joining()), this.query.getConditions().stream().filter(conditionFilter -> SearchUtils.isCustomSearchField(this.getField(conditionFilter.getField()), this.separator)).map(condition -> this.getCustomSearchField((Condition)condition)).collect(Collectors.joining("", "<ns01:customFieldList>", "</ns01:customFieldList>")));
            body = body.replace("<ns01:customFieldList></ns01:customFieldList>", "");
            LOGGER.debug("Using search request body: {}", (Object)body);
            return new PaginatedSearch(this.paginatedSearch != null ? this.paginatedSearch.getConfig() : null, new ByteArrayInputStream(body.getBytes()), this.query.getLimit(), this.getPageSize(), false, true);
        });
        List<Result<String, NetsuiteSoapAttributes>> page = this.paginatedSearch.getPage(connection);
        if (!this.query.getFields().isEmpty()) {
            LOGGER.debug("Filtering output data");
        }
        LinkedList<TypedValue<String>> typedResults = new LinkedList<TypedValue<String>>();
        for (Result<String, NetsuiteSoapAttributes> item : page) {
            InputStream transformResponse = connection.getDocumentFactory().transform(FilteringUtils.getOutputScript("%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payloadObject = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payloadObject, namespace) = (if (payloadObject.customFieldList != null) {\n    namespace#customFieldList: payloadObject.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payloadObject, namespace) =\n  payloadObject match {\n      case is Object -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapValue(payloadObject) =\n  payloadObject match {\n      case is Array -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapRecord(payloadObject, rec) = {\n    record : rec ++\n       ns01#customFieldList: payloadObject.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payloadObject.record.@)): recursive(payloadObject.record, payloadObject.record.#)\n", this.query.getObjectType(), "payload"), new ByteArrayInputStream(((String)item.getOutput()).getBytes()));
            String value = this.query.getFields().isEmpty() ? IOUtils.toString((InputStream)transformResponse) : FilteringUtils.filterFields(transformResponse, this.query.getFields());
            typedResults.add((TypedValue<String>)new TypedValue((Object)value, DataType.XML_STRING));
        }
        return typedResults;
    }

    @NotNull
    private String getSearchValues(Condition condition, String operator) {
        if (operator == null) {
            return "<searchValue>" + condition.getValues().get(0) + "</searchValue>";
        }
        if (condition.getValues().size() == 1) {
            return "<searchValue>" + condition.getValues().get(0) + "</searchValue>";
        }
        if (operator.equals("anyOf") || operator.equals("noneOf")) {
            return condition.getValues().stream().map(value -> String.format("<searchValue>%s</searchValue>", value)).collect(Collectors.joining());
        }
        if (condition.getValues().size() == 2) {
            return "<searchValue>" + condition.getValues().get(0) + "</searchValue><searchValue2>" + condition.getValues().get(1) + "</searchValue2>";
        }
        return "";
    }

    private int getPageSize() {
        if (this.query.getLimit() < 5) {
            return 5;
        }
        if (this.query.getLimit() > 100) {
            return 100;
        }
        return this.query.getLimit();
    }

    private String getCustomSearchField(Condition condition) {
        CustomIdentifier conditionCustomField = new CustomIdentifier(this.getField(condition.getField()), this.separator);
        return conditionCustomField.getType().equals("SearchBooleanCustomField") ? String.format("<customField scriptId=\"%s\" internalId=\"%s\" xsi:type=\"platformCore:%s\">%s</customField>", conditionCustomField.getScriptId(), conditionCustomField.getInternalId(), conditionCustomField.getType(), this.getSearchValues(condition, condition.getOperator())) : String.format("<customField %s scriptId=\"%s\" internalId=\"%s\" xsi:type=\"platformCore:%s\">%s</customField>", StringUtils.isBlank((String)condition.getOperator()) ? "" : String.format("operator=\"%s\"", condition.getOperator()), conditionCustomField.getScriptId(), conditionCustomField.getInternalId(), conditionCustomField.getType(), this.getSearchValues(condition, condition.getOperator()));
    }

    private String getField(Field field) {
        return field.getElementsList().get(field.getElementsList().size() - 1).getLocalPart();
    }

    private String getSearchRequest(String recordType) {
        CustomIdentifier customRecord = null;
        CitizenSourceRecordEnum recordEnum = null;
        String stageXml = "";
        String costingMethodXml = "";
        String lotItem = "";
        if (SearchUtils.isCustomRecordType(recordType).booleanValue()) {
            customRecord = new CustomIdentifier(recordType, this.separator);
        } else {
            recordEnum = CitizenSourceRecordEnum.valueOf(recordType.toUpperCase());
            costingMethodXml = this.getCostingMethodXml(recordEnum);
            stageXml = this.getStageXml(recordEnum);
            lotItem = this.getIsLotItemXml(recordEnum);
        }
        if (customRecord == null) {
            CitizenRecordEnum citizenRecordEnum = CitizenRecordEnum.valueOf(recordType);
            String request = recordEnum.getSearchType() == null ? "<?xml version='1.0' encoding='UTF-8'?>\n<ns0:search xmlns:ns0=\"urn:messages_2020_2.platform.webservices.netsuite.com\">\n  <ns0:searchRecord  xmlns:platformCore=\"urn:core_2020_2.platform.webservices.netsuite.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns01=\"urn:common_2020_2.platform.webservices.netsuite.com\" xsi:type=\"ns01:" + XMLUtils.getEntity(citizenRecordEnum.getQName()) + "SearchBasic\">\n       %s        %s   </ns0:searchRecord>\n</ns0:search>" : "<?xml version='1.0' encoding='UTF-8'?>\n<ns0:search xmlns:ns0=\"urn:messages_2020_2.platform.webservices.netsuite.com\">\n  <ns0:searchRecord  xmlns:platformCore=\"urn:core_2020_2.platform.webservices.netsuite.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns01=\"urn:common_2020_2.platform.webservices.netsuite.com\" xsi:type=\"ns01:" + recordEnum.getSearchType(citizenRecordEnum.getQName()) + "\">\n       %s        %s " + (recordEnum.getType() == null ? "" : "            <type xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n               <searchValue xmlns=\"\">" + recordEnum.getType() + "</searchValue>\n            </type>\n") + (recordEnum.getSubType() == null ? "" : "           <subType xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n               <searchValue xmlns=\"\">" + recordEnum.getSubType() + "</searchValue>\n            </subType>\n") + costingMethodXml + lotItem + stageXml + "  </ns0:searchRecord>\n</ns0:search>";
            return request;
        }
        return "<?xml version='1.0' encoding='UTF-8'?>\n<ns0:search xmlns:ns0=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:ns3=\"urn:common_2020_2.platform.webservices.netsuite.com\">  <ns0:searchRecord  xmlns:platformCore=\"urn:core_2020_2.platform.webservices.netsuite.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns01=\"urn:common_2020_2.platform.webservices.netsuite.com\" xsi:type=\"ns3:CustomRecordSearchBasic\"><ns3:recType internalId=\"" + customRecord.getInternalId() + "\"></ns3:recType>       %s        %s   </ns0:searchRecord>\n</ns0:search>";
    }

    private String getCostingMethodXml(CitizenSourceRecordEnum recordEnum) {
        String costingMethod = recordEnum.getCostingMethod();
        if (costingMethod == null) {
            return "";
        }
        return String.format("<costingMethod xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n               <searchValue xmlns=\"\">%s</searchValue>\n            </costingMethod>\n", costingMethod);
    }

    private String getIsLotItemXml(CitizenSourceRecordEnum recordEnum) {
        return recordEnum.getIsLotItem() ? "<isLotItem xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\">\n                <searchValue xmlns=\"urn:core_2020_2.platform.webservices.netsuite.com\">true</searchValue>\n</isLotItem>\n" : "";
    }

    private String getStageXml(CitizenSourceRecordEnum recordEnum) {
        String searchStage = recordEnum.getSearchStage();
        if (searchStage == null) {
            return "";
        }
        return String.format("<stage xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n                <searchValue xmlns=\"\">%s</searchValue>\n            </stage>", searchStage);
    }

    public Optional<Integer> getTotalResults(NetSuiteSoapConnection connection) {
        return this.paginatedSearch.getTotalResults(connection);
    }

    public void close(NetSuiteSoapConnection connection) throws MuleException {
        this.paginatedSearch.close(connection);
    }
}

