/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.sampledata;

import com.google.common.base.CaseFormat;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSampleDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSampleDataProvider.class);
    protected static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    protected static final int PAGE_SIZE = 5;
    protected static final String DW_RECORD_EXTRACTION = "payload";
    protected static final String XML_TYPE = "<type xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\"><searchValue xmlns=\"\">%s</searchValue></type>";
    protected static final String XML_SUBTYPE = "<subType xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\"><searchValue xmlns=\"\">%s</searchValue></subType>";
    @Parameter
    private String recordType;
    @Config
    private NetSuiteSoapConfig config;
    @Connection
    private NetSuiteSoapConnection connection;

    protected Result<InputStream, NetsuiteSoapAttributes> getSample(String outputScript) throws SampleDataException {
        try {
            String searchType;
            String searchField;
            String searchValueType = null;
            String searchValue = ZonedDateTime.now().format(MULE_DATETIME_FORMAT);
            String xmlType = XML_TYPE;
            if (this.recordType.equals("PAYMENT_ITEM")) {
                searchField = "created";
                searchType = "ItemSearchBasic";
                searchValueType = "_payment";
            } else {
                CitizenSourceRecordEnum record = CitizenSourceRecordEnum.valueOf(this.recordType);
                searchField = record.getOnNewSearchField();
                if (record.getSubType() != null) {
                    searchValueType = record.getSubType();
                    searchType = record.getSearchType();
                    xmlType = XML_SUBTYPE;
                } else if (record.getType() == null) {
                    searchType = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.recordType) + "SearchBasic";
                } else {
                    searchType = record.getSearchType(CitizenRecordEnum.valueOf(this.recordType).getQName());
                    searchValueType = record.getType();
                }
            }
            String searchBody = "<search xmlns=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:common=\"urn:common_2020_2.platform.webservices.netsuite.com\"><searchRecord xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"common:" + searchType + "\"><" + searchField + " xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"before\"><searchValue xmlns=\"\">" + searchValue + "</searchValue></" + searchField + ">" + (searchValueType == null ? "" : String.format(xmlType, searchValueType)) + "</searchRecord></search>";
            LOGGER.debug("Using search body for sample data {}", (Object)searchBody);
            PagingProvider<NetSuiteSoapConnection, org.mule.runtime.extension.api.runtime.operation.Result<String, NetsuiteSoapAttributes>> searchResult = new RecordOperations().search(this.config, null, new ByteArrayInputStream(searchBody.getBytes()), 5, 1, true, true);
            List records = searchResult.getPage((Object)this.connection);
            if (records.isEmpty()) {
                throw new SampleDataException("Error while retrieving sample data", "NO_DATA_AVAILABLE");
            }
            org.mule.runtime.extension.api.runtime.operation.Result singleItem = (org.mule.runtime.extension.api.runtime.operation.Result)records.get(0);
            InputStream singleOutput = this.connection.getDocumentFactory().transform(outputScript, new ByteArrayInputStream(((String)singleItem.getOutput()).getBytes()));
            Result.Builder builder = Result.builder().output((Object)singleOutput).mediaType(MediaType.APPLICATION_XML);
            Optional attributes = singleItem.getAttributes();
            if (attributes.isPresent()) {
                builder.attributes(attributes.get());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new SampleDataException("Error while retrieving sample data", "NO_DATA_AVAILABLE", (Throwable)e);
        }
    }

    protected String getRecordType() {
        return this.recordType;
    }

    void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    void setConnection(NetSuiteSoapConnection connection) {
        this.connection = connection;
    }
}

