/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.sampledata;

import com.google.common.annotations.VisibleForTesting;
import com.mulesoft.connector.netsuite.internal.citizen.model.Query;
import com.mulesoft.connector.netsuite.internal.citizen.pagination.CitizenPaginatedGetRecords;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRecordsSampleDataProvider
implements SampleDataProvider<List<TypedValue<String>>, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRecordsSampleDataProvider.class);
    private static final int LIMIT = 5;
    @Parameter
    private String query;
    @Config
    private NetSuiteSoapConfig config;
    @Connection
    private NetSuiteSoapConnection connection;

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<List<TypedValue<String>>, Void> getSample() throws SampleDataException {
        LOGGER.info("Getting sample data for query {}", (Object)this.query);
        ByteArrayInputStream is = new ByteArrayInputStream(this.query.getBytes());
        Query queryObject = SearchUtils.parse(is);
        queryObject.getConditions().clear();
        queryObject.setLimit(5);
        return Optional.ofNullable(new CitizenPaginatedGetRecords(queryObject, this.config.getAdvancedConfig().getSeparator()).getPage(this.connection)).filter(list -> !list.isEmpty()).map(list -> list.subList(0, 1)).filter(list -> list.get(0) != null).map(sample -> Result.builder().output(sample).build()).orElseThrow(() -> new SampleDataException("No data available.", "NO_DATA_AVAILABLE"));
    }

    @VisibleForTesting
    public void setConnection(NetSuiteSoapConnection connection) {
        this.connection = connection;
    }

    @VisibleForTesting
    public void setConfig(NetSuiteSoapConfig config) {
        this.config = config;
    }

    @VisibleForTesting
    public void setQuery(String query) {
        this.query = query;
    }
}

