/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.source;

import com.google.common.annotations.VisibleForTesting;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceMetadataResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.FilteringUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CitizenAbstractSource
extends PollingSource<InputStream, NetsuiteSoapAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitizenAbstractSource.class);
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");
    public static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final String EXTRACT_ID_AND_WATERMARK = "%dw 2.0\noutput application/java\n---\n{\n    id: payload.record.@internalId,\n    watermark: payload.record.DATE_FIELD\n}";
    private String startSince;
    private static final String DW_RECORD_EXTRACTION = "payload";
    private static String MESSAGES_NS = "urn:messages_2020_2.platform.webservices.netsuite.com";
    private static String COMMON_NS = "urn:common_2020_2.platform.webservices.netsuite.com";
    @Connection
    private ConnectionProvider<NetSuiteSoapConnection> connectionProvider;
    @Config
    private NetSuiteSoapConfig config;
    private NetSuiteSoapConnection connection;
    @Parameter
    @Placement(order=1)
    @Summary(value="The type of record that will be retrieved when created.")
    @MetadataKeyId(value=CitizenSourceMetadataResolver.class)
    @DisplayName(value="Type of Record")
    protected String recordType;

    protected void doStart() throws MuleException {
        this.connection = (NetSuiteSoapConnection)this.connectionProvider.connect();
        this.startSince = ZonedDateTime.now().format(MULE_DATETIME_FORMAT);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<InputStream, NetsuiteSoapAttributes> pollContext) {
        if (pollContext.isSourceStopping()) {
            return;
        }
        try {
            CitizenSourceRecordEnum searchEnum = SearchUtils.isCustomRecordType(this.recordType) != false ? null : CitizenSourceRecordEnum.valueOf(this.recordType);
            this.searchRecordPollCreate(pollContext, searchEnum);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void onRejectedItem(Result<InputStream, NetsuiteSoapAttributes> result, SourceCallbackContext sourceCallbackContext) {
    }

    protected void searchRecordPollCreate(PollContext<InputStream, NetsuiteSoapAttributes> pollContext, CitizenSourceRecordEnum searchEnum) throws TransformerException, ParserConfigurationException {
        String since = pollContext.getWatermark().isPresent() ? this.formatSince(((Serializable)pollContext.getWatermark().get()).toString()) : this.formatSince(this.startSince);
        LOGGER.debug("Running poll with since = {} for {}", (Object)since, (Object)this.recordType);
        PagingProvider<NetSuiteSoapConnection, org.mule.runtime.extension.api.runtime.operation.Result<String, NetsuiteSoapAttributes>> searchResults = new RecordOperations().search(null, null, this.bodyRequest(searchEnum, since, this.recordType), 10, -1, false, true);
        List records = searchResults.getPage((Object)this.connection);
        while (!records.isEmpty()) {
            LOGGER.trace("Poll run finished, {} records returned.", (Object)records.size());
            for (int i = 0; i < records.size(); ++i) {
                if (pollContext.isSourceStopping()) {
                    return;
                }
                pollContext.accept(this.getPollItemConsumer((Result<InputStream, NetsuiteSoapAttributes>)Result.builder().output((Object)new ByteArrayInputStream(((String)((org.mule.runtime.extension.api.runtime.operation.Result)records.get(i)).getOutput()).getBytes())).attributes(((org.mule.runtime.extension.api.runtime.operation.Result)records.get(0)).getAttributes().orElse(null)).build(), this.getWatermarkField(searchEnum)));
            }
            if (pollContext.isSourceStopping()) {
                return;
            }
            records = searchResults.getPage((Object)this.connection);
        }
    }

    private String formatSince(String value) {
        ZonedDateTime fromDateTime = ZonedDateTime.parse(value, MULE_DATETIME_FORMAT);
        return ZonedDateTime.ofInstant(fromDateTime.toInstant(), ZONE_ID).format(MULE_DATETIME_FORMAT);
    }

    protected Consumer<PollContext.PollItem<InputStream, NetsuiteSoapAttributes>> getPollItemConsumer(Result<InputStream, NetsuiteSoapAttributes> record, String field) {
        Map<String, Object> recordSourceVars;
        InputStream output;
        String outputString = IOUtils.toString((InputStream)((InputStream)record.getOutput()));
        try {
            output = this.getConnection().getDocumentFactory().transform(FilteringUtils.getOutputScript("%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payloadObject = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payloadObject, namespace) = (if (payloadObject.customFieldList != null) {\n    namespace#customFieldList: payloadObject.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payloadObject, namespace) =\n  payloadObject match {\n      case is Object -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapValue(payloadObject) =\n  payloadObject match {\n      case is Array -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapRecord(payloadObject, rec) = {\n    record : rec ++\n       ns01#customFieldList: payloadObject.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payloadObject.record.@)): recursive(payloadObject.record, payloadObject.record.#)\n", this.recordType, DW_RECORD_EXTRACTION), this.getInputStream(outputString));
            recordSourceVars = this.getConnection().getDocumentFactory().transformToMap(EXTRACT_ID_AND_WATERMARK.replaceAll("DATE_FIELD", field), this.getInputStream(outputString));
        }
        catch (IOException e) {
            throw new NetSuiteSoapModuleException("Error processing payload", NetSuiteSoapErrorType.TRANSFORMATION);
        }
        if (recordSourceVars.values().stream().anyMatch(Objects::isNull)) {
            LOGGER.error("Could not process item in source: {} due to missing ID or watermark field.", recordSourceVars);
            throw new NetSuiteSoapModuleException("Cannot set valid id or watermark. Please add support date field", NetSuiteSoapErrorType.USER_ERROR);
        }
        return item -> {
            item.setResult(Result.builder().output((Object)output).mediaType(MediaType.APPLICATION_XML).attributes(record.getAttributes().get()).build());
            item.setId(recordSourceVars.get("id").toString());
            item.setWatermark((Serializable)((Object)recordSourceVars.get("watermark").toString()));
        };
    }

    private InputStream getInputStream(String outputString) throws IOException {
        return org.apache.commons.io.IOUtils.toInputStream((String)outputString, (String)"utf-8");
    }

    protected abstract String getSearchField(CitizenSourceRecordEnum var1);

    protected abstract String getWatermarkField(CitizenSourceRecordEnum var1);

    protected String getWatermarkFieldValue(CitizenSourceRecordEnum searchEnum, String customWatermarkFieldValue, String standardWatermarkFieldValue) {
        if (searchEnum == null) {
            return customWatermarkFieldValue;
        }
        if (standardWatermarkFieldValue != null) {
            return standardWatermarkFieldValue;
        }
        throw new NetSuiteSoapModuleException("Error processing watermark", NetSuiteSoapErrorType.TRANSFORMATION);
    }

    protected InputStream bodyRequest(CitizenSourceRecordEnum searchEnum, String since, String recordType) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element searchBody = document.createElementNS(MESSAGES_NS, "search");
        document.appendChild(searchBody);
        searchBody.setAttribute("xmlns:common", COMMON_NS);
        Element searchRecord = document.createElementNS(MESSAGES_NS, "searchRecord");
        searchRecord.setAttribute("xsi:type", "common:" + (searchEnum == null ? "CustomRecordSearchBasic" : searchEnum.getSearchType(CitizenRecordEnum.valueOf(searchEnum.name()).getQName())));
        searchRecord.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        searchBody.appendChild(searchRecord);
        Element dateCreated = document.createElementNS(COMMON_NS, this.getSearchField(searchEnum));
        dateCreated.setAttribute("operator", "within");
        searchRecord.appendChild(dateCreated);
        Element searchValue = document.createElement("searchValue");
        searchValue.setTextContent(since);
        dateCreated.appendChild(searchValue);
        Element searchValue2 = document.createElement("searchValue2");
        searchValue2.setTextContent(ZonedDateTime.ofInstant(Instant.now(), ZONE_ID).format(MULE_DATETIME_FORMAT));
        dateCreated.appendChild(searchValue2);
        if (this.hasSearchStage(searchEnum)) {
            this.addStage(searchEnum, document, COMMON_NS, searchRecord);
        }
        if (searchEnum == null) {
            Element recType = document.createElementNS(COMMON_NS, "recType");
            String[] parts = CitizenMetadataUtils.splitCustomRecordKey(recordType, this.config);
            recType.setAttribute("internalId", parts[2]);
            searchRecord.appendChild(recType);
        } else {
            if (searchEnum.getType() != null) {
                this.addSearchValueElement(document, COMMON_NS, "type", searchEnum.getType(), searchRecord);
            }
            if (searchEnum.getSubType() != null) {
                this.addSearchValueElement(document, COMMON_NS, "subType", searchEnum.getSubType(), searchRecord);
            }
            if (searchEnum.getCostingMethod() != null) {
                this.addSearchValueElement(document, COMMON_NS, "costingMethod", searchEnum.getCostingMethod(), searchRecord);
            }
            if (searchEnum.getIsLotItem()) {
                this.addSearchValueElement(document, COMMON_NS, "isLotItem", "true", searchRecord, null);
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private boolean hasSearchStage(CitizenSourceRecordEnum searchEnum) {
        return searchEnum != null && searchEnum.getSearchStage() != null;
    }

    private void addStage(CitizenSourceRecordEnum searchEnum, Document document, String commonNS, Element searchRecord) {
        Element stage = document.createElementNS(commonNS, "stage");
        stage.setAttribute("operator", "anyOf");
        searchRecord.appendChild(stage);
        Element stageSearchValue = document.createElement("searchValue");
        stageSearchValue.setTextContent(searchEnum.getSearchStage());
        stage.appendChild(stageSearchValue);
    }

    private void addSearchValueElement(Document document, String commonNS, String name, String searchEnum, Element searchRecord) {
        this.addSearchValueElement(document, commonNS, name, searchEnum, searchRecord, "anyOf");
    }

    private void addSearchValueElement(Document document, String commonNS, String name, String searchEnum, Element searchRecord, String operator) {
        Element type = document.createElementNS(commonNS, name);
        Element typeSearchValue = document.createElement("searchValue");
        typeSearchValue.setTextContent(searchEnum);
        type.appendChild(typeSearchValue);
        searchRecord.appendChild(type);
        Optional.ofNullable(operator).ifPresent(op -> type.setAttribute("operator", (String)op));
    }

    public NetSuiteSoapConnection getConnection() {
        return this.connection;
    }

    @VisibleForTesting
    protected void setConfig(NetSuiteSoapConfig config) {
        this.config = config;
    }
}

