/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import java.util.Optional;
import java.util.stream.Stream;

public enum CitizenCustomFieldType {
    CHECK_BOX("_checkBox", CitizenCustomFieldRefType.BOOLEAN),
    CURRENCY("_currency", CitizenCustomFieldRefType.DOUBLE),
    DATE("_date", CitizenCustomFieldRefType.DATE),
    DATE_TIME("_datetime", CitizenCustomFieldRefType.DATE),
    DECIMAL_NUMBER("_decimalNumber", CitizenCustomFieldRefType.DOUBLE),
    E_MAIL_ADDRESS("_eMailAddress", CitizenCustomFieldRefType.STRING),
    FREE_FORM_TEXT("_freeFormText", CitizenCustomFieldRefType.STRING),
    HELP("_help", CitizenCustomFieldRefType.STRING),
    HYPERLINK("_hyperlink", CitizenCustomFieldRefType.STRING),
    INLINE_HTML("_inlineHTML", CitizenCustomFieldRefType.STRING),
    INTEGER_NUMBER("_integerNumber", CitizenCustomFieldRefType.LONG),
    LIST_RECORD("_listRecord", CitizenCustomFieldRefType.SELECT),
    CUSTOM_LIST_RECORD("custom_listRecord", CitizenCustomFieldRefType.SELECT_LIST),
    LONG_TEXT("_longText", CitizenCustomFieldRefType.STRING),
    MULTIPLE_SELECT("_multipleSelect", CitizenCustomFieldRefType.MULTI_SELECT),
    CUSTOM_MULTIPLE_SELECT("custom_multipleSelect", CitizenCustomFieldRefType.MULTI_SELECT_LIST),
    PASSWORD("_password", CitizenCustomFieldRefType.STRING),
    PERCENT("_percent", CitizenCustomFieldRefType.DOUBLE),
    PHONE_NUMBER("_phoneNumber", CitizenCustomFieldRefType.STRING),
    RICH_TEXT("_richText", CitizenCustomFieldRefType.STRING),
    TEXT_AREA("_textArea", CitizenCustomFieldRefType.STRING),
    TIME_OF_DAY("_timeOfDay", CitizenCustomFieldRefType.DATE);

    private String netsuiteValue;
    private final CitizenCustomFieldRefType customFieldRefType;

    public static Optional<CitizenCustomFieldRefType> refTypeFromNetSuiteName(String name) {
        return Stream.of(CitizenCustomFieldType.values()).filter(v -> v.netsuiteValue.equalsIgnoreCase(name)).map(v -> v.customFieldRefType).findFirst();
    }

    private CitizenCustomFieldType(String value, CitizenCustomFieldRefType customFieldRefType) {
        this.netsuiteValue = value;
        this.customFieldRefType = customFieldRefType;
    }

    public String getNetsuiteValue() {
        return this.netsuiteValue;
    }

    public CitizenCustomFieldRefType getCustomFieldRefType() {
        return this.customFieldRefType;
    }
}

