/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.model.CustomRef;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenCustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.citizen.util.TransformationUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.util.CustomizationTypeEnum;
import com.mulesoft.connector.netsuite.internal.xml.XmlFactories;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomObjectUtils {
    private static final List<String> SELECT_CUSTOM_FIELD_NAMES = CustomObjectUtils.getNetsuiteValues(Arrays.asList(CitizenCustomFieldRefType.SELECT, CitizenCustomFieldRefType.SELECT_LIST));
    private static final List<String> ALL_SELECT_CUSTOM_FIELD_NAMES = CustomObjectUtils.getNetsuiteValues(Arrays.asList(CitizenCustomFieldRefType.SELECT, CitizenCustomFieldRefType.MULTI_SELECT, CitizenCustomFieldRefType.SELECT_LIST, CitizenCustomFieldRefType.MULTI_SELECT_LIST));

    public static CustomRef stringToCustomRef(String name, String separator) {
        List<String> elementsOfCustomField;
        if (!CustomObjectUtils.isCustomRef(name, separator).booleanValue()) {
            return null;
        }
        return new CustomRef(elementsOfCustomField.get(0), elementsOfCustomField.get(1), elementsOfCustomField.get(2), (elementsOfCustomField = Arrays.asList(name.split(separator))).size() < 4 ? null : elementsOfCustomField.get(3));
    }

    public static Boolean isCustomRef(String field, String separator) {
        if (field == null) {
            return false;
        }
        List<String> elementsOfCustomField = Arrays.asList(field.split(separator));
        if (CustomObjectUtils.isCustomObject(elementsOfCustomField.get(0))) {
            return true;
        }
        return Arrays.stream(CitizenCustomFieldRefType.values()).anyMatch(value -> value.getNetsuiteValue().equals(elementsOfCustomField.get(0))) && elementsOfCustomField.size() > 2;
    }

    public static boolean validCustomListResponse(Node node) {
        if (node == null) {
            return false;
        }
        Element status = (Element)node.getFirstChild();
        return status.getAttributeNode("isSuccess").getValue().equals(Boolean.toString(true));
    }

    public static Element transformToNetsuiteCustomField(Node field, Document document, Map<String, String> valueList, NetSuiteSoapConfig config) {
        List<Node> values = XMLUtils.getChildByName((Element)field, "value");
        CustomRef customField = CustomObjectUtils.stringToCustomRef(field.getLocalName(), config.getAdvancedConfig().getSeparator());
        if (customField == null) {
            throw new NetSuiteSoapModuleException(String.format("%s contains invalid value", field.getLocalName()), NetSuiteSoapErrorType.VALIDATION);
        }
        if (customField.getCustomListInternalId() != null) {
            values = XMLUtils.setReferenceToListValues(field, valueList);
            customField.setType(customField.getType().equals(CitizenCustomFieldRefType.SELECT_LIST.getNetsuiteValue()) ? CitizenCustomFieldRefType.SELECT.getNetsuiteValue() : CitizenCustomFieldRefType.MULTI_SELECT.getNetsuiteValue());
        }
        Element newNode = document.createElement("platformCore:customField");
        newNode.setAttribute("xmlns:platformCore", "urn:core_2020_2.platform.webservices.netsuite.com");
        newNode.setAttribute("xsi:type", String.format("platformCore:%s", customField.getType()));
        newNode.setAttribute("scriptId", customField.getScriptId());
        newNode.setAttribute("internalId", customField.getInternalId());
        if (!values.isEmpty()) {
            for (Node value : values) {
                Element valueNode = document.createElement("platformCore:value");
                Node internalIdAttribute = XMLUtils.getAttributeByName((Element)value, "internalId");
                Node externalIdAttribute = XMLUtils.getAttributeByName((Element)value, "externalId");
                if (internalIdAttribute != null) {
                    CustomObjectUtils.setInternalIdAttr(valueNode, internalIdAttribute);
                } else {
                    if (externalIdAttribute == null) continue;
                    CustomObjectUtils.setExternalIdAttr(valueNode, externalIdAttribute);
                }
                newNode.appendChild(valueNode);
            }
        } else {
            Element valueNode = document.createElement("platformCore:value");
            Node attrInternalId = XMLUtils.getAttributeByName((Element)field, "internalId");
            Node attrExternalId = XMLUtils.getAttributeByName((Element)field, "externalId");
            if (!ALL_SELECT_CUSTOM_FIELD_NAMES.contains(customField.getType()) || SELECT_CUSTOM_FIELD_NAMES.contains(customField.getType())) {
                CustomObjectUtils.setTextContent(field, valueNode);
                if (attrInternalId != null) {
                    CustomObjectUtils.setInternalIdAttr(valueNode, attrInternalId);
                }
                if (attrExternalId != null) {
                    CustomObjectUtils.setExternalIdAttr(valueNode, attrExternalId);
                }
            }
            newNode.appendChild(valueNode);
        }
        return newNode;
    }

    private static void setExternalIdAttr(Element valueNode, Node attr) {
        valueNode.setAttribute("externalId", attr.getTextContent());
    }

    private static void setInternalIdAttr(Element valueNode, Node attr) {
        valueNode.setAttribute("internalId", attr.getTextContent());
    }

    private static void setTextContent(Node field, Element valueNode) {
        valueNode.setTextContent(field.getTextContent());
    }

    public static boolean isCustomObject(String recordType) {
        return recordType.equals("CustomRecord");
    }

    public static Document getCustomListRequest(Collection<String> internalIds) throws ParserConfigurationException {
        Document document = XmlFactories.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Element getListBodyElement = document.createElement("getList");
        document.appendChild(getListBodyElement);
        internalIds.forEach(id -> {
            Element baseRefElement = document.createElement("baseRef");
            baseRefElement.setAttribute("xmlns", "urn:core_2020_2.platform.webservices.netsuite.com");
            baseRefElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            baseRefElement.setAttribute("internalId", (String)id);
            baseRefElement.setAttribute("type", CustomizationTypeEnum.CUSTOM_LIST.getNetsuiteValue());
            baseRefElement.setAttribute("xsi:type", "RecordRef");
            getListBodyElement.appendChild(baseRefElement);
        });
        return document;
    }

    public static boolean isCustomFieldCustomList(CustomRef customField) {
        if (customField.getCustomListInternalId() == null) {
            return false;
        }
        return TransformationUtils.isPositiveNumber(customField.getCustomListInternalId());
    }

    public static boolean isCustomFieldStandardList(CustomRef customField) {
        if (customField.getCustomListInternalId() == null) {
            return false;
        }
        return !CustomObjectUtils.isCustomFieldCustomList(customField);
    }

    private static List<String> getNetsuiteValues(List<CitizenCustomFieldRefType> citizenCustomFieldRefTypes) {
        return citizenCustomFieldRefTypes.stream().map(CitizenCustomFieldRefType::getNetsuiteValue).collect(Collectors.toList());
    }
}

