/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.model.Field;
import com.mulesoft.connector.netsuite.internal.citizen.util.SearchUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FilteringUtils {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final String NS_PLACEHOLDER = "TYPE_NS";
    private static final String RECORD_PLACEHOLDER = "RECORD_EXP";
    public static final String OUTPUT_SCRIPT = "%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payloadObject = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payloadObject, namespace) = (if (payloadObject.customFieldList != null) {\n    namespace#customFieldList: payloadObject.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payloadObject, namespace) =\n  payloadObject match {\n      case is Object -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapValue(payloadObject) =\n  payloadObject match {\n      case is Array -> ((payloadObject - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payloadObject, payloadObject.customFieldList.#)\n      else -> payloadObject\n  }\n\nfun mapRecord(payloadObject, rec) = {\n    record : rec ++\n       ns01#customFieldList: payloadObject.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payloadObject.record.@)): recursive(payloadObject.record, payloadObject.record.#)\n";

    private FilteringUtils() {
    }

    public static String getOutputScript(String outputScript, String recordType, String dwRecordExtraction) {
        CitizenRecordEnum citizenRecordEnum = SearchUtils.isCustomRecordType(recordType) != false ? CitizenRecordEnum.CUSTOM_RECORD : CitizenRecordEnum.valueOf(recordType);
        return outputScript.replace(NS_PLACEHOLDER, XMLUtils.getNamespace(citizenRecordEnum.getQName())).replace(RECORD_PLACEHOLDER, dwRecordExtraction);
    }

    public static String filterFields(InputStream query, List<Field> fieldList) {
        try {
            NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(WsdlVersion.getDefaultWsdlVersionStr(), null, null);
            factory.setNamespaceAware(true);
            Document queryDocument = factory.newDocumentBuilder().parse(query);
            Document newDocument = factory.newDocumentBuilder().newDocument();
            Element root = newDocument.createElementNS(queryDocument.getDocumentElement().getNamespaceURI(), queryDocument.getDocumentElement().getLocalName());
            NamedNodeMap attributes = queryDocument.getDocumentElement().getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                root.setAttribute(attributes.item(j).getNodeName(), attributes.item(j).getTextContent());
            }
            newDocument.appendChild(root);
            fieldList.forEach(field -> FilteringUtils.addNode(field.getElementsList(), newDocument.getDocumentElement(), queryDocument.getDocumentElement(), newDocument));
            return IOUtils.toString((InputStream)netsuiteDocumentFactory.transformToInputStream(newDocument.getChildNodes().item(0)));
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    public static void addNode(List<QName> path, Element newParent, Element original, Document newDocument) {
        for (int i = 1; i < path.size(); ++i) {
            String elementName = path.get(i).getLocalPart();
            List<Node> originalNodes = XMLUtils.getChildByName(original, elementName);
            List<Node> newNodes = XMLUtils.getChildByName(newParent, elementName);
            if (originalNodes.isEmpty()) break;
            if (newNodes.size() > 1) {
                for (int k = 0; k < originalNodes.size(); ++k) {
                    FilteringUtils.addNode(path.subList(i, path.size()), (Element)newNodes.get(k), (Element)originalNodes.get(k), newDocument);
                }
                continue;
            }
            if (newNodes.size() == 1) {
                newParent = (Element)newNodes.get(0);
                original = (Element)originalNodes.get(0);
                continue;
            }
            for (Node originalNode : originalNodes) {
                Element newElement = FilteringUtils.copyElementAndAppend(newDocument, newParent, originalNodes.get(0));
                FilteringUtils.addNode(path.subList(i, path.size()), newElement, (Element)originalNode, newDocument);
            }
        }
    }

    private static Element copyElementAndAppend(Document newDocument, Element newParent, Node originalNode) {
        Element newElement = newDocument.createElementNS(originalNode.getNamespaceURI(), originalNode.getNodeName());
        NamedNodeMap attributes = originalNode.getAttributes();
        for (int j = 0; j < attributes.getLength(); ++j) {
            newElement.setAttribute(attributes.item(j).getNodeName(), attributes.item(j).getTextContent());
        }
        if (originalNode.getFirstChild() != null && originalNode.getFirstChild().getFirstChild() == null && !originalNode.getFirstChild().getTextContent().trim().isEmpty()) {
            newElement.setTextContent(originalNode.getTextContent());
        }
        newParent.appendChild(newElement);
        return newElement;
    }
}

