/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.model.Condition;
import com.mulesoft.connector.netsuite.internal.citizen.model.CriteriaSelection;
import com.mulesoft.connector.netsuite.internal.citizen.model.Field;
import com.mulesoft.connector.netsuite.internal.citizen.model.Query;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.transaction.TransactionRequiredException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SearchUtils {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    private SearchUtils() {
    }

    public static Boolean isCustomSearchField(String field, String separator) {
        List<String> elementsOfCustomField = Arrays.asList(field.split(separator));
        return elementsOfCustomField.get(0).startsWith("Search") && elementsOfCustomField.get(0).endsWith("CustomField");
    }

    public static Boolean isCustomRecordType(String recordType) {
        return recordType.startsWith("CustomRecord");
    }

    private static void validate(Document query) {
        Integer number = null;
        String objectType = null;
        if (query.getElementsByTagName("objectType").getLength() == 0) {
            throw new NetSuiteSoapModuleException("Field objectType is required", NetSuiteSoapErrorType.VALIDATION);
        }
        objectType = query.getElementsByTagName("objectType").item(0).getTextContent();
        try {
            if (!SearchUtils.isCustomRecordType(objectType).booleanValue()) {
                CitizenRecordEnum.valueOf(objectType);
            }
        }
        catch (Exception e) {
            throw new NetSuiteSoapModuleException("Invalid object type", NetSuiteSoapErrorType.VALIDATION);
        }
        if (query.getElementsByTagName("limit").getLength() == 0) {
            throw new NetSuiteSoapModuleException("Field limit is required", NetSuiteSoapErrorType.VALIDATION);
        }
        try {
            number = Integer.valueOf(query.getElementsByTagName("limit").item(0).getTextContent());
        }
        catch (NumberFormatException nfe) {
            throw new NetSuiteSoapModuleException("Limit must be numeric", NetSuiteSoapErrorType.VALIDATION);
        }
        if (number < 1 || number > 500) {
            throw new NetSuiteSoapModuleException("Limit out of range", NetSuiteSoapErrorType.VALIDATION);
        }
    }

    public static Query parse(InputStream query) {
        try {
            Document queryDocument = factory.newDocumentBuilder().parse(query);
            SearchUtils.validate(queryDocument);
            Query result = new Query();
            result.setObjectType(queryDocument.getElementsByTagName("objectType").item(0).getTextContent());
            result.setCriteriaSelection(Optional.ofNullable(queryDocument.getElementsByTagName("criteriaSelection")).map(node -> node.item(0)).map(Node::getTextContent).map(CriteriaSelection::valueOf).orElse(CriteriaSelection.NONE));
            result.setLimit(Integer.valueOf(queryDocument.getElementsByTagName("limit").item(0).getTextContent()));
            NodeList conditions = queryDocument.getElementsByTagName("conditions");
            if (conditions.getLength() > 0) {
                NodeList conditionList = ((Element)conditions.item(0)).getElementsByTagName("condition");
                for (int temp = 0; temp < conditionList.getLength(); ++temp) {
                    Condition condition = new Condition();
                    NodeList field = ((Element)conditionList.item(temp)).getElementsByTagName("field");
                    if (field.getLength() == 0) {
                        throw new TransactionRequiredException("Condition field is required");
                    }
                    condition.setField(SearchUtils.getField(field.item(0).getTextContent()));
                    NodeList values = ((Element)conditionList.item(temp)).getElementsByTagName("values");
                    if (values.getLength() > 0) {
                        NodeList valueList = ((Element)values.item(0)).getElementsByTagName("value");
                        for (int v = 0; v < valueList.getLength(); ++v) {
                            String textContent = valueList.item(v).getTextContent();
                            condition.getValues().add(StringEscapeUtils.escapeXml10((String)textContent));
                        }
                    }
                    if (condition.getValues().isEmpty()) {
                        throw new TransactionRequiredException("Values cannot be empty");
                    }
                    NodeList operator = ((Element)conditionList.item(temp)).getElementsByTagName("operator");
                    if (operator.getLength() > 0 && !operator.item(0).getTextContent().isEmpty() && !SearchUtils.isBooleanType(operator.item(0).getTextContent(), condition.getValues()).booleanValue()) {
                        condition.setOperator(operator.item(0).getTextContent());
                    }
                    result.getConditions().add(condition);
                }
            }
            if (queryDocument.getElementsByTagName("fields").getLength() > 0) {
                NodeList fields = queryDocument.getElementsByTagName("fields").item(0).getChildNodes();
                ArrayList<Field> fieldList = new ArrayList<Field>();
                for (int i = 0; i < fields.getLength(); ++i) {
                    if (fields.item(i).getTextContent().trim().isEmpty()) continue;
                    fieldList.add(SearchUtils.getField(fields.item(i).getTextContent()));
                }
                result.setFields(fieldList);
            }
            return result;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    private static Field getField(String text) {
        List<String> elements = Arrays.asList(text.replace("]", "").replace("[", "").split(","));
        ArrayList<QName> qnameList = new ArrayList<QName>();
        elements.stream().map(String::trim).forEach(x -> qnameList.add(x.contains("{") && x.contains("}") ? SearchUtils.getQName(x) : new QName("", (String)x)));
        return new Field(qnameList);
    }

    public static QName getQName(String x) {
        String namespace = XMLUtils.getNamespace(x);
        String localPart = XMLUtils.getEntity(x);
        return new QName(namespace, localPart);
    }

    public static Boolean isBooleanType(String operator, List<String> values) throws TransactionRequiredException {
        if (values.size() > 1 || operator != null && !operator.equals("is")) {
            return false;
        }
        String value = values.get(0);
        if (value == null) {
            throw new TransactionRequiredException("Value cannot be null");
        }
        return value.equals(Boolean.toString(true)) || value.equals(Boolean.toString(false));
    }
}

