/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenActionRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.citizen.model.Behavior;
import com.mulesoft.connector.netsuite.internal.citizen.model.CustomRef;
import com.mulesoft.connector.netsuite.internal.citizen.util.CustomObjectUtils;
import com.mulesoft.connector.netsuite.internal.citizen.util.XMLUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.xml.XmlFactories;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformationUtils {
    private static final Integer pageSize = 1000;
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(WsdlVersion.getDefaultWsdlVersionStr(), null, null);
    private static final Logger logger = LoggerFactory.getLogger(TransformationUtils.class);

    public static InputStream inputStreamToNetsuiteXml(InputStream input, String recordType, String id, String idType, String operation, NetSuiteSoapConfig config, NetSuiteSoapConnection connection, Behavior behavior) {
        try {
            String entity;
            factory.setNamespaceAware(true);
            String separator = config.getAdvancedConfig().getSeparator();
            String[] recordTypeKeys = recordType.split(separator);
            boolean isCustomObject = CustomObjectUtils.isCustomObject(recordTypeKeys[0]);
            String recordTypeQName = isCustomObject ? CitizenRecordEnum.CUSTOM_RECORD.getQName() : Arrays.stream(CitizenActionRecordEnum.values()).filter(type -> type.name().equals(recordType)).findFirst().map(recordEnum -> CitizenRecordEnum.valueOf(recordType).getQNameForRequest()).orElseThrow(() -> new NetSuiteSoapModuleException("Invalid record type", NetSuiteSoapErrorType.VALIDATION));
            Document inputDocument = factory.newDocumentBuilder().parse(input);
            Document newDocument = factory.newDocumentBuilder().newDocument();
            Element recordElement = inputDocument.getDocumentElement();
            if (!recordElement.getLocalName().equals("record")) {
                throw new NetSuiteSoapModuleException("Invalid root record", NetSuiteSoapErrorType.VALIDATION);
            }
            Element operationElement = newDocument.createElement("ns1:" + operation);
            operationElement.setAttribute("xmlns:ns1", "urn:messages_2020_2.platform.webservices.netsuite.com");
            newDocument.appendChild(operationElement);
            if (isCustomObject) {
                entity = recordTypeKeys[0];
                Element recType = inputDocument.createElement("ns0:recType");
                recType.setAttribute("internalId", recordTypeKeys[2]);
                recordElement.appendChild(recType);
            } else {
                entity = XMLUtils.getEntity(recordTypeQName);
            }
            String namespace = XMLUtils.getNamespace(recordTypeQName);
            recordElement.setAttribute("xsi:type", "ns0:" + entity);
            recordElement.setAttribute("xmlns:ns0", namespace);
            recordElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (!StringUtils.isBlank((CharSequence)id)) {
                recordElement.setAttribute("ns0:" + idType.toLowerCase() + "Id", id);
            }
            HashMap<Node, String> customFieldLists = new HashMap<Node, String>();
            ObjectType root = null;
            if (behavior != null && behavior.isClearOnNullValues()) {
                root = CitizenMetadataUtils.loadStaticMetadata(CitizenMetadataUtils.getRecordEnum(recordType).getQName());
            }
            TransformationUtils.transformFieldToNetsuiteXml(recordElement, inputDocument, config, customFieldLists, recordType, behavior, root, null);
            if (!customFieldLists.isEmpty()) {
                TransformationUtils.setCustomListsToValidNetsuiteXML(recordElement, inputDocument, config, connection, customFieldLists);
            }
            operationElement.appendChild(newDocument.importNode(recordElement, true));
            return netsuiteDocumentFactory.transformToInputStream(newDocument.getChildNodes().item(0));
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new NetsuiteTransformationException("Could not read from the inbound message", e);
        }
        catch (MetadataResolvingException e) {
            throw new NetSuiteSoapModuleException("Could not read the record type metadata", NetSuiteSoapErrorType.TRANSFORMATION, e);
        }
        catch (DOMException e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new NetsuiteTransformationException(String.format("There was an error while replacing a Node. Message: %s", e.getMessage()), e.getCause());
        }
    }

    public static void transformFieldToNetsuiteXml(Node node, Document document, NetSuiteSoapConfig config, Map<Node, String> customLists, String recordType, Behavior behavior, ObjectType parentType, ObjectType greatParentType) throws MetadataResolvingException {
        ObjectType type;
        String separator = config.getAdvancedConfig().getSeparator();
        TransformationUtils.remapNullAttributes(node, behavior);
        NodeList nodeList = node.getChildNodes();
        boolean isCustomField = CustomObjectUtils.isCustomRef(node.getLocalName(), separator);
        ObjectType objectType = type = behavior != null && behavior.isClearOnNullValues() ? TransformationUtils.getChildType(parentType) : null;
        if (!isCustomField) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                if (currentNode.getNodeType() != 1) continue;
                TransformationUtils.transformFieldToNetsuiteXml(currentNode, document, config, customLists, recordType, behavior, type, parentType);
            }
        }
        if (isCustomField) {
            CustomRef customField = CustomObjectUtils.stringToCustomRef(node.getLocalName(), separator);
            if (TransformationUtils.isNodeToBeCleared(node, behavior) && customField != null) {
                TransformationUtils.addNodeToNullFieldListOrRemove(greatParentType, node, node.getParentNode(), document, customField.getScriptId(), behavior);
            } else if (customField != null && customField.getCustomListInternalId() != null) {
                customLists.put(node, customField.getCustomListInternalId());
            } else {
                node.getParentNode().replaceChild(CustomObjectUtils.transformToNetsuiteCustomField(node, document, null, config), node);
            }
        } else if (TransformationUtils.isNodeToBeCleared(node, behavior)) {
            TransformationUtils.addNodeToNullFieldListOrRemove(parentType, node, node, document, node.getLocalName(), behavior);
        }
    }

    private static void addNodeToNullFieldListOrRemove(ObjectType type, Node node, Node parentNode, Document document, String localName, Behavior behavior) {
        if (behavior != null && behavior.isClearOnNullValues() && TransformationUtils.hasNullFieldList(type)) {
            TransformationUtils.addNodeToNullFieldList(node, parentNode.getParentNode(), document, localName);
        } else {
            node.getParentNode().removeChild(node);
        }
    }

    private static ObjectType getChildType(ObjectType type) {
        if (type != null) {
            if (type.getFields().isEmpty()) {
                return null;
            }
            ObjectFieldType md = (ObjectFieldType)type.getFields().iterator().next();
            return md.getValue() instanceof ObjectType ? (ObjectType)md.getValue() : null;
        }
        return null;
    }

    private static boolean hasNullFieldList(ObjectType type) {
        if (type == null) {
            return false;
        }
        return type.getFields().stream().anyMatch(f -> "nullFieldList".equals(f.getKey().getName().getLocalPart()));
    }

    private static void addNodeToNullFieldList(Node node, Node parentRecordNode, Document document, String fieldName) {
        NodeList recordChildNodes = parentRecordNode.getChildNodes();
        Element nullFieldListNode = null;
        for (int i = 0; i < recordChildNodes.getLength(); ++i) {
            if (!"platformCore:nullFieldList".equals(recordChildNodes.item(i).getNodeName())) continue;
            nullFieldListNode = (Element)recordChildNodes.item(i);
            break;
        }
        Element fieldToNullNode = document.createElement("platformCore:name");
        fieldToNullNode.setTextContent(fieldName);
        if (nullFieldListNode == null) {
            nullFieldListNode = document.createElement("platformCore:nullFieldList");
            nullFieldListNode.setAttribute("xsi:type", "platformCore:NullField");
            nullFieldListNode.setAttribute("xmlns:platformCore", "urn:core_2020_2.platform.webservices.netsuite.com");
            parentRecordNode.appendChild(nullFieldListNode);
        }
        nullFieldListNode.appendChild(fieldToNullNode);
        node.getParentNode().removeChild(node);
    }

    private static boolean isNodeToBeCleared(Node node, Behavior behavior) {
        List<Node> values = XMLUtils.getChildByName((Element)node, "value");
        Behavior behaviorForValues = new Behavior();
        behaviorForValues.setClearOnNullValues(true);
        boolean hasValues = !values.isEmpty();
        Iterator<Node> i = values.iterator();
        while (i.hasNext()) {
            Node value = i.next();
            TransformationUtils.remapNullAttributes(value, behaviorForValues);
            if (!TransformationUtils.isValueToBeCleared(value)) continue;
            node.removeChild(value);
            i.remove();
        }
        if (hasValues && values.isEmpty() && (behavior == null || behavior != null && !behavior.isClearOnNullValues())) {
            return true;
        }
        return TransformationUtils.isValueToBeCleared(node) && node.getChildNodes().getLength() == 0;
    }

    private static boolean isValueToBeCleared(Node node) {
        List<String> attrList = TransformationUtils.getAttributeList(node);
        return StringUtils.isBlank((CharSequence)node.getTextContent()) && !attrList.contains("internalId") && !attrList.contains("externalId");
    }

    private static List<String> getAttributeList(Node node) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            if (node.getAttributes().item(i).getNodeName().startsWith("xmlns")) continue;
            attributes.add(node.getAttributes().item(i).getNodeName());
        }
        return attributes;
    }

    public static void transformStandardList(Node node, Document document, String recordType, NetSuiteSoapConfig config, NetSuiteSoapConnection connection) {
        boolean isSelectList = !XMLUtils.getChildByName((Element)node, "name").isEmpty() && !node.getLocalName().equals("value");
        boolean isMultiSelectList = XMLUtils.getChildByName((Element)node, "value").stream().anyMatch(valueNode -> !XMLUtils.getChildByName((Element)valueNode, "name").isEmpty());
        if (!isSelectList && !isMultiSelectList || node.getLocalName().equals("record") || !((Element)node).getAttribute("internalId").isEmpty()) {
            return;
        }
        Map<String, String> valueList = TransformationUtils.getStandardList(recordType, node.getLocalName(), config, connection);
        List<Node> values = XMLUtils.setReferenceToListValues(node, valueList);
        Element newNode = document.createElement(node.getNodeName());
        NamedNodeMap attr = node.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            newNode.setAttribute(attr.item(i).getNodeName(), attr.item(i).getTextContent());
        }
        if (isSelectList) {
            newNode.setAttribute("internalId", ((Element)values.get(0)).getAttribute("internalId"));
        } else {
            values.forEach(v -> {
                Element valueNode = document.createElement("value");
                valueNode.setAttribute("internalId", ((Element)v).getAttribute("internalId"));
                newNode.appendChild(valueNode);
            });
        }
        node.getParentNode().replaceChild(newNode, node);
    }

    public static Map<String, Map<String, String>> documentCustomListsToMap(Document document) {
        HashMap<String, Map<String, String>> response = new HashMap<String, Map<String, String>>();
        NodeList responseList = document.getElementsByTagName("platformMsgs:readResponse");
        for (int i = 0; i < responseList.getLength(); ++i) {
            NodeList msgRecordList;
            if (!CustomObjectUtils.validCustomListResponse(responseList.item(i)) || (msgRecordList = ((Element)responseList.item(i)).getElementsByTagName("platformMsgs:record")).getLength() < 1) continue;
            Node record = msgRecordList.item(0);
            String internalId = ((Element)record).getAttribute("internalId");
            NodeList setupCustomValueList = ((Element)responseList.item(i)).getElementsByTagName("setupCustom:customValueList");
            if (setupCustomValueList.getLength() < 1) continue;
            NodeList customValueList = setupCustomValueList.item(0).getChildNodes();
            HashMap<String, String> listValues = new HashMap<String, String>();
            for (int j = 0; j < customValueList.getLength(); ++j) {
                Element customValueListElementItem = (Element)customValueList.item(j);
                NodeList valueList = customValueListElementItem.getElementsByTagName("setupCustom:value");
                if (valueList.getLength() < 1) continue;
                String value = valueList.item(0).getTextContent();
                NodeList valueIdList = customValueListElementItem.getElementsByTagName("setupCustom:valueId");
                if (valueIdList.getLength() < 1) continue;
                String valueId = valueIdList.item(0).getTextContent();
                listValues.put(value.toLowerCase(), valueId);
            }
            response.put(internalId, listValues);
        }
        return response;
    }

    public static void setCustomListsToValidNetsuiteXML(Node node, Document document, NetSuiteSoapConfig config, NetSuiteSoapConnection connection, Map<Node, String> customLists) throws ParserConfigurationException, TransformerException {
        Map<String, Map<String, String>> customListsMap = TransformationUtils.getCustomListsMap(config, connection, customLists);
        for (Map.Entry<Node, String> entry : customLists.entrySet()) {
            Node key = entry.getKey();
            Element newNode = TransformationUtils.createNewNode((Element)node, document, config, connection, customListsMap, entry, key);
            NodeList valueIdList = ((Element)node).getElementsByTagName(key.getNodeName());
            try {
                TransformationUtils.replaceNode(key, newNode, valueIdList);
            }
            catch (DOMException e) {
                logger.error("Error while replacing child node {}.", (Object)key.getNodeName());
                throw new NetsuiteTransformationException(String.format("There was an error while replacing node %s. Message: %s", key.getNodeName(), e.getMessage()), e.getCause());
            }
        }
    }

    private static void replaceNode(Node key, Element newNode, NodeList valueIdList) {
        for (int i = 0; i < valueIdList.getLength(); ++i) {
            Node parentNode = valueIdList.item(i).getParentNode();
            NodeList childNodes = parentNode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                if (!childNodes.item(j).equals(key)) continue;
                childNodes.item(j).getParentNode().replaceChild(newNode, key);
                return;
            }
        }
    }

    private static Element createNewNode(Element node, Document document, NetSuiteSoapConfig config, NetSuiteSoapConnection connection, Map<String, Map<String, String>> customListsMap, Map.Entry<Node, String> entry, Node key) {
        String value = entry.getValue();
        CustomRef customField = CustomObjectUtils.stringToCustomRef(key.getLocalName(), config.getAdvancedConfig().getSeparator());
        Map<String, String> valueList = customField != null && CustomObjectUtils.isCustomFieldStandardList(customField) ? TransformationUtils.getStandardList(StringUtils.uncapitalize((String)XMLUtils.getEntity(node.getAttribute("xsi:type"))), customField.getScriptId(), config, connection) : customListsMap.get(value);
        Element newNode = CustomObjectUtils.transformToNetsuiteCustomField(key, document, valueList, config);
        return newNode;
    }

    private static Map<String, Map<String, String>> getCustomListsMap(NetSuiteSoapConfig config, NetSuiteSoapConnection connection, Map<Node, String> customLists) throws TransformerException, ParserConfigurationException {
        RecordOperations recordOperations = new RecordOperations();
        InputStream message = netsuiteDocumentFactory.transformToInputStream(CustomObjectUtils.getCustomListRequest(customLists.values()));
        Result<InputStream, NetsuiteSoapAttributes> recordOperationsList = recordOperations.getList(config, connection, new RecordRefAndTypeParameterGroup(), message);
        Document response = netsuiteDocumentFactory.transformToDocument((InputStream)recordOperationsList.getOutput());
        Map<String, Map<String, String>> customListsMap = TransformationUtils.documentCustomListsToMap(response);
        return customListsMap;
    }

    public static boolean isPositiveNumber(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, String> getStandardList(String recordType, String fieldName, NetSuiteSoapConfig config, NetSuiteSoapConnection connection) {
        Map<String, String> standardList;
        try {
            RecordOperations recordOperations = new RecordOperations();
            Document document = XmlFactories.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Element fieldDescriptionBodyElement = document.createElement("fieldDescription");
            fieldDescriptionBodyElement.setAttribute("xmlns", "urn:messages_2020_2.platform.webservices.netsuite.com");
            document.appendChild(fieldDescriptionBodyElement);
            Element recordTypeElement = document.createElement(StringUtils.uncapitalize((String)"RecordType"));
            recordTypeElement.setAttribute("xmlns", "urn:core_2020_2.platform.webservices.netsuite.com");
            recordTypeElement.setTextContent(recordType);
            Element fieldElement = document.createElement("field");
            fieldElement.setAttribute("xmlns", "urn:core_2020_2.platform.webservices.netsuite.com");
            fieldElement.setTextContent(fieldName);
            fieldDescriptionBodyElement.appendChild(recordTypeElement);
            fieldDescriptionBodyElement.appendChild(fieldElement);
            InputStream description = netsuiteDocumentFactory.transformToInputStream(document);
            List results = recordOperations.getSelectValue(config, description, pageSize).getPage((Object)connection);
            if (results.isEmpty()) {
                throw new NetSuiteSoapModuleException(String.format("%s is invalid or is dependent on other field. Please insert internalId", fieldName), NetSuiteSoapErrorType.VALIDATION);
            }
            standardList = results.stream().map(ref -> {
                try {
                    return netsuiteDocumentFactory.transformToDocument((String)ref.getOutput(), StandardCharsets.UTF_8).getFirstChild();
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new NetSuiteSoapModuleException(String.format("Standard list is invalid: %s", e.getMessage()), NetSuiteSoapErrorType.VALIDATION, e);
                }
            }).collect(Collectors.toMap(value -> value.getTextContent().toLowerCase().replaceAll("&nbsp;", ""), field -> ((Element)field).getAttribute("internalId")));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new NetSuiteSoapModuleException(String.format("Standard list is invalid: %s", e.getMessage()), NetSuiteSoapErrorType.VALIDATION);
        }
        return standardList;
    }

    private static void remapNullAttributes(Node node, Behavior behavior) {
        ArrayList<String> attrToRemove = new ArrayList<String>();
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attr2 = node.getAttributes().item(i);
            if (!"null".equals(attr2.getTextContent())) continue;
            if (behavior != null && behavior.isClearOnNullValues()) {
                attrToRemove.add(attr2.getNodeName());
                continue;
            }
            attr2.setTextContent("");
        }
        attrToRemove.forEach(attr -> node.getAttributes().removeNamedItem((String)attr));
    }
}

