/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.model.CustomRef;
import com.mulesoft.connector.netsuite.internal.citizen.util.CustomObjectUtils;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private XMLUtils() {
    }

    public static Node getBaseRef(String recordType, String separator) {
        CustomRef customRef = CustomObjectUtils.stringToCustomRef(recordType, separator);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            Element name = null;
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document xmlDoc = builder.newDocument();
            Element root = xmlDoc.createElement("root");
            Element item = xmlDoc.createElementNS("urn:messages_2020_2.platform.webservices.netsuite.com", "platformCore:CustomizationRef");
            XMLUtils.createAttribute(xmlDoc, item, "xmlns:q1", "urn:core_2020_2.platform.webservices.netsuite.com");
            XMLUtils.createAttribute(xmlDoc, item, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (customRef != null) {
                XMLUtils.createAttribute(xmlDoc, item, "internalId", customRef.getInternalId());
                XMLUtils.createAttribute(xmlDoc, item, "scriptId", customRef.getScriptId());
                name = xmlDoc.createElementNS("urn:core_2020_2.platform.webservices.netsuite.com", "name");
                name.setTextContent(customRef.getType());
            }
            XMLUtils.createAttribute(xmlDoc, item, "type", "customRecordType");
            XMLUtils.createAttribute(xmlDoc, item, "xsi:type", "q1:CustomizationRef");
            item.appendChild(name);
            root.appendChild(item);
            xmlDoc.appendChild(root);
            return item;
        }
        catch (ParserConfigurationException e) {
            throw new NetSuiteSoapModuleException("Could not create base ref XML element", NetSuiteSoapErrorType.TRANSFORMATION);
        }
    }

    public static List<Node> setReferenceToListValues(Node node, Map<String, String> valueList) {
        List<Node> values = XMLUtils.getChildByName((Element)node, XMLUtils.getChildByName((Element)node, "name").isEmpty() ? "value" : "name");
        for (Node value : values) {
            String internalId;
            boolean valueToClear = false;
            if (((Element)node).hasAttribute("internalId")) {
                internalId = ((Element)node).getAttribute("internalId");
            } else if (((Element)value).hasAttribute("internalId")) {
                internalId = ((Element)value).getAttribute("internalId");
            } else {
                NodeList nameList = ((Element)value).getElementsByTagName("name");
                if (nameList.getLength() > 0) {
                    if (nameList.getLength() > 1) {
                        throw new NetSuiteSoapModuleException(String.format("%s contains more than one name value", node.getLocalName()), NetSuiteSoapErrorType.VALIDATION);
                    }
                    String nameText = nameList.item(0).getTextContent().toLowerCase();
                    internalId = valueList.get(nameText);
                    if (StringUtils.isBlank((CharSequence)nameText)) {
                        internalId = "";
                        valueToClear = true;
                    }
                } else {
                    String valueText = value.getTextContent().toLowerCase();
                    internalId = valueList.get(valueText);
                    if (StringUtils.isBlank((CharSequence)valueText)) {
                        internalId = "";
                        valueToClear = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)internalId) && !valueToClear) {
                    throw new NetSuiteSoapModuleException(String.format("%s contains invalid value", node.getLocalName()), NetSuiteSoapErrorType.VALIDATION);
                }
            }
            ((Element)value).setAttribute("internalId", internalId);
        }
        return values;
    }

    public static Attr createAttribute(Document document, Node node, String name, String value) {
        Attr typeAttr = document.createAttribute(name);
        typeAttr.setValue(value);
        node.getAttributes().setNamedItem(typeAttr);
        return typeAttr;
    }

    public static Attr createAttributeNS(Document document, Node node, String namespace, String name, String value) {
        Attr typeAttr = document.createAttributeNS(namespace, name);
        typeAttr.setValue(value);
        node.getAttributes().setNamedItemNS(typeAttr);
        return typeAttr;
    }

    public static Node getAttributeByName(Element element, String name) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.item(i).getNodeName().equals(name)) continue;
            return attributes.item(i);
        }
        return null;
    }

    public static List<Node> getChildByName(Element element, String name) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getLocalName() == null || !nodeList.item(i).getLocalName().equals(name)) continue;
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public static String getNamespace(String value) {
        return value == null ? null : value.replaceFirst("^\\{([^}]+)}[^}]+$", "$1");
    }

    public static String getEntity(String value) {
        if (value == null) {
            return null;
        }
        String[] entity = value.replaceFirst("^\\{[^}]+}([^}]+)$", "$1").split(":");
        return entity.length > 1 ? entity[1] : entity[0];
    }
}

