/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public interface GzipResponseHandler {
    public static final String GZIP = "gzip";
    public static final String CONTENT_ENCODING = "content-encoding";

    default public InputStream handleCompressedInputStream(HttpResponse response) {
        try {
            InputStream content = response.getEntity().getContent();
            if (GZIP.equals(response.getHeaderValue(CONTENT_ENCODING))) {
                content = new GZIPInputStream(content);
            }
            return content;
        }
        catch (IOException e) {
            throw new ModuleException("Exception occurred while decompressing the response content. ", (ErrorTypeDefinition)MuleErrors.TRANSFORMATION, (Throwable)e);
        }
    }
}

