/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection;

import com.mulesoft.connector.netsuite.internal.connection.GzipResponseHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.soap.api.exception.DispatchingException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageDispatcher
implements TransportDispatcher,
GzipResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageDispatcher.class);
    private final HttpClient client;
    private final int responseTimeout;
    private final MultiMap<String, String> defaultHeaders;
    private final MultiMap<String, String> defaultQueryParams;
    private final String endpointUrl;

    public HttpMessageDispatcher(HttpClient client, String endpointUrl, int responseTimeout, MultiMap<String, String> defaultHeaders, MultiMap<String, String> defaultQueryParams) {
        this.client = client;
        this.endpointUrl = endpointUrl;
        this.responseTimeout = responseTimeout;
        this.defaultHeaders = defaultHeaders;
        this.defaultQueryParams = defaultQueryParams;
    }

    public TransportResponse dispatch(TransportRequest transportRequest) {
        String endpoint = StringUtils.isBlank((CharSequence)this.endpointUrl) ? transportRequest.getAddress() : this.endpointUrl;
        InputStream content = this.logIfNeeded(String.format("Soap Request to [%s]", endpoint), transportRequest.getContent());
        MultiMap mergedHeaders = new MultiMap();
        mergedHeaders.putAll(transportRequest.getHeaders());
        mergedHeaders.putAll(this.defaultHeaders);
        HttpRequestBuilder httpRequestBuilder = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder((boolean)true).method(HttpConstants.Method.POST).entity((HttpEntity)new InputStreamHttpEntity(content))).headers(mergedHeaders)).uri(endpoint).queryParams(this.defaultQueryParams);
        HttpRequest httpRequest = httpRequestBuilder.build();
        logger.debug("HttpRequest : {}", (Object)httpRequest);
        try {
            HttpResponse response = this.client.send(httpRequest, HttpRequestOptions.builder().responseTimeout(this.responseTimeout).followsRedirect(true).build());
            return new TransportResponse(this.logIfNeeded("Soap Response", this.handleCompressedInputStream(response)), this.toHeadersMap(response), this.toStatusLineMap(response));
        }
        catch (IOException e) {
            throw new DispatchingException("An error occurred while sending the SOAP request", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new DispatchingException("The SOAP request timed out", (Throwable)e);
        }
    }

    private InputStream logIfNeeded(String title, InputStream content) {
        if (logger.isDebugEnabled()) {
            String stringContent = IOUtils.toString((InputStream)content);
            String debugMessage = String.format("Logging %s", title) + "-----------------------------------" + stringContent + "-----------------------------------";
            logger.debug(debugMessage);
            return new ByteArrayInputStream(stringContent.getBytes(StandardCharsets.UTF_8));
        }
        return content;
    }

    private Map<String, String> toHeadersMap(HttpResponse response) {
        return response.getHeaderNames().stream().collect(Collectors.toMap(Function.identity(), name -> String.join((CharSequence)" ", response.getHeaderValues(name))));
    }

    private Map<String, String> toStatusLineMap(HttpResponse response) {
        HashMap<String, String> statusLine = new HashMap<String, String>();
        statusLine.put("statusCode", String.valueOf(response.getStatusCode()));
        statusLine.put("reasonPhrase", response.getReasonPhrase());
        return statusLine;
    }
}

