/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.citizen.concurrency.ConcurrencyAwareCaller;
import com.mulesoft.connector.netsuite.internal.citizen.concurrency.ResultFactory;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.HttpMessageDispatcher;
import com.mulesoft.connector.netsuite.internal.connection.SoapResponseParser;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.util.Timer;
import com.mulesoft.connector.netsuite.internal.util.Utils;
import com.mulesoft.connector.netsuite.internal.xml.NamespaceUtils;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.predic8.schema.SchemaComponent;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import com.predic8.xml.util.ClasspathResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.WsdlModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NetSuiteSoapConnection
implements ConnectorConnection {
    public static DataType DEFAULT_BODY_DATA_TYPE = DataType.builder().type(InputStream.class).mediaType(MediaType.XML).build();
    private static final Logger logger = LoggerFactory.getLogger(NetSuiteSoapConnection.class);
    public static final DateTimeFormatter DATETIME_FORMAT_TO_NETSUITE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final DateTimeFormatter DATETIME_FORMAT_FROM_NETSUITE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String LOCAL_WSDL_FILE = "netsuite.wsdl";
    private final HttpClient httpClient;
    private final SoapClient soapClient;
    private final String endpoint;
    private final Supplier<MultiMap<String, String>> headersSupplier;
    private final Supplier<String> wsdlUrlSupplier;
    private final Integer responseTimeout;
    private final SoapResponseParser soapResponseParser = new SoapResponseParser(XMLSecureFactories.createDefault());
    private LazyValue<WsdlModel> wsdlModel = new LazyValue(this::loadWsdlModel);
    private final LazyValue<Definitions> wsdlDefinitions = new LazyValue(this::loadWSDLDefinitions);
    private final LazyValue<Map<String, String>> schemaMappings = new LazyValue(this::loadSchemaMappings);
    private final LazyValue<Map<String, String>> complexTypesMapping = new LazyValue(this::loadComplexTypesMappings);
    private NetsuiteDocumentFactory documentFactory;
    private Optional<WsdlVersion> wsdlVersion;
    private final ConcurrencyAwareCaller<SoapResponse> concurrencyAwareCaller;

    public NetSuiteSoapConnection(HttpClient httpClient, SoapClient soapClient, String endpoint, Supplier<MultiMap<String, String>> headersSupplier, Supplier<String> wsdlUrlSupplier, Integer responseTimeout, Optional<WsdlVersion> wsdlVersion, MuleExpressionLanguage expressionExecutor, TransformationService transformationService, ConcurrencyAwareCaller<SoapResponse> concurrencyAwareCaller) {
        this.httpClient = httpClient;
        this.soapClient = soapClient;
        this.endpoint = endpoint;
        this.headersSupplier = headersSupplier;
        this.wsdlUrlSupplier = wsdlUrlSupplier;
        this.responseTimeout = responseTimeout;
        this.wsdlVersion = wsdlVersion;
        this.concurrencyAwareCaller = concurrencyAwareCaller;
        this.documentFactory = new NetsuiteDocumentFactory(wsdlVersion.orElse(WsdlVersion.getDefaultWsdlVersion()).getValue(), expressionExecutor, transformationService);
    }

    public void disconnect() {
    }

    public void validate() {
        logger.debug("Validating Connection ");
        Result<InputStream, NetsuiteSoapAttributes> serverTime = this.invokeWithoutBody(null, "getServerTime");
        try (InputStream value = (InputStream)serverTime.getOutput();){
            String response = IOUtils.toString((InputStream)value, (Charset)StandardCharsets.UTF_8);
            logger.debug(response);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not validate connection"), (Throwable)e);
        }
        logger.debug("Validated Connection successfully");
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeWithHeaderPreferences(NetSuiteSoapConfig config, String operation, String searchPreferencesHeader, InputStream message, boolean useEndpointFromWsdl) {
        logger.debug("Invoking with config={},operation={}", (Object)config, (Object)operation);
        String preferencesHeaderXml = null;
        try {
            if (config != null) {
                Document preferencesDocument = this.documentFactory.generateXmlHeaderPreferences(config.getPreferences());
                preferencesHeaderXml = this.documentFactory.convertToString(preferencesDocument);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return this.invoke(config, operation, preferencesHeaderXml, searchPreferencesHeader, message, useEndpointFromWsdl);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invoke(NetSuiteSoapConfig config, String operation, String preferencesXmlHeaders, String searchPreferencesHeader, InputStream message, boolean useEndpointFromWsdl) {
        boolean omitInternalIdFromCustomFieldNames = Utils.shouldOmitInternalIdCustomFieldNames(config, this.wsdlVersion);
        String separator = config != null ? config.getAdvancedConfig().getSeparator() : "__";
        Timer overallTime = Timer.fromNow();
        try {
            InputStream messageWithNamespaces;
            Timer outboundTimer = Timer.fromNow();
            try {
                messageWithNamespaces = this.wsdlVersion.isPresent() ? NamespaceUtils.addWsdlVersionToNS(message, this.wsdlVersion.get().getValue()) : message;
                logger.debug("Took {} to process the outbound message", (Object)outboundTimer.measure().toMillis());
            }
            catch (IOException e) {
                throw new NetsuiteTransformationException(String.format("Could not read from the input of the operation %s (took %s ms),", operation, outboundTimer.measure()), e);
            }
            String messageWithNamespacesString = this.bytesToString(messageWithNamespaces);
            Timer inboundTimer = Timer.fromNow();
            try {
                SoapResponse response = this.concurrencyAwareCaller.call(this.getResultSupplier(operation, useEndpointFromWsdl, messageWithNamespacesString, preferencesXmlHeaders, searchPreferencesHeader));
                InputStream resultsOutput = this.soapResponseParser.parseResponse(response.getContent());
                InputStream customFieldsOutgoing = this.getDocumentFactory().transformCustomFieldsIncomingToInputStream(resultsOutput, separator, omitInternalIdFromCustomFieldNames);
                InputStream resultWithoutNamespaces = this.wsdlVersion.isPresent() ? NamespaceUtils.removeWsdlVersionFromNS(customFieldsOutgoing) : customFieldsOutgoing;
                Result result = Result.builder().output((Object)resultWithoutNamespaces).mediaType(MediaType.parse((String)response.getContentType())).attributes((Object)new NetsuiteSoapAttributes(response.getTransportHeaders(), response.getTransportAdditionalData(), NetSuiteSoapConnection.wrapHeaders(response.getSoapHeaders()))).build();
                return result;
            }
            catch (IOException | InterruptedException | TransformerException | XPathExpressionException e) {
                throw new NetsuiteTransformationException(String.format("Could not read from the inbound message for the operation %s (took %s ms),", operation, inboundTimer.measure()), e);
            }
        }
        finally {
            logger.info("Took {} to process the soap invocation for operation {}", (Object)overallTime.measure().toMillis(), (Object)operation);
        }
    }

    @NotNull
    private Supplier<com.mulesoft.connector.netsuite.internal.citizen.concurrency.Result<SoapResponse>> getResultSupplier(String operation, boolean useEndpointFromWsdl, String messageWithNamespacesString, String preferencesXmlHeaders, String searchPreferencesHeader) {
        String contentType = MediaType.XML.toRfcString();
        return () -> {
            try {
                MultiMap<String, String> headers = this.getHeaders(preferencesXmlHeaders, searchPreferencesHeader);
                SoapResponse res = this.soapClient.consume((SoapRequest)SoapRequest.builder().operation(operation).soapHeaders(headers).content(messageWithNamespacesString).contentType(contentType).build(), (TransportDispatcher)new HttpMessageDispatcher(this.httpClient, useEndpointFromWsdl ? null : this.endpoint, this.responseTimeout, (MultiMap<String, String>)new MultiMap(), (MultiMap<String, String>)new MultiMap()));
                return new ResultFactory<SoapResponse>().resultWithResponse(res);
            }
            catch (SoapFaultException e) {
                return new ResultFactory().resultErrored((RuntimeException)((Object)this.soapResponseParser.parseSoapFault(e)));
            }
            catch (BadRequestException e) {
                throw new RuntimeException(String.format("There was a problem creating the Request to Netsuite. Operation: %s , Body: %s , Preference Headers: %s", operation, messageWithNamespacesString, preferencesXmlHeaders), e.getCause());
            }
        };
    }

    private MultiMap<String, String> getHeaders(String preferencesXmlHeaders, String searchPreferencesHeader) {
        logger.debug("Building SOAP request ");
        logger.debug("Adding SOAP request headers.");
        MultiMap<String, String> headers = this.headersSupplier.get();
        if (!Strings.isNullOrEmpty((String)preferencesXmlHeaders)) {
            headers.put((Object)"Preferences", (Object)preferencesXmlHeaders);
        }
        if (!Strings.isNullOrEmpty((String)searchPreferencesHeader)) {
            headers.put((Object)"searchPreferences", (Object)searchPreferencesHeader);
        }
        logger.debug("Sending SOAP request.");
        return headers;
    }

    public Result<InputStream, NetsuiteSoapAttributes> get(NetSuiteSoapConfig config, RecordRefAndTypeParameterGroup key, InputStream message) {
        try {
            Document doc = this.documentFactory.get(message, key);
            return this.doInvoke(config, () -> doc, "get");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    public Result<InputStream, NetsuiteSoapAttributes> getAll(NetSuiteSoapConfig config, String recordType) {
        return this.doInvoke(config, () -> this.documentFactory.getRecords(recordType), "getAll");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getSavedSearch(NetSuiteSoapConfig config, String searchType) {
        return this.doInvoke(config, () -> this.documentFactory.getSavedSearch(searchType), "getSavedSearch");
    }

    public Result<InputStream, NetsuiteSoapAttributes> search(NetSuiteSoapConfig config, InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences(config, "search", message, bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> searchMoreWithId(NetSuiteSoapConfig config, String searchId, Integer pageIndex, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences(config, "searchMoreWithId", () -> this.documentFactory.searchMoreWithId(searchId, pageIndex), bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> asyncSearch(NetSuiteSoapConfig config, InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences(config, "asyncSearch", message, bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> changeEmail(NetSuiteSoapConfig config, String newEmail, String currentCredentials, boolean justThisAccount) {
        return this.doInvoke(config, () -> this.documentFactory.changeEmail(newEmail, currentCredentials, justThisAccount), "changeEmail");
    }

    public Result<InputStream, NetsuiteSoapAttributes> changePassword(NetSuiteSoapConfig config, String newPassword, String currentCredentials) {
        return this.doInvoke(config, () -> this.documentFactory.changePassword(newPassword, currentCredentials), "changePassword");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getAsyncResult(NetSuiteSoapConfig config, String jobId, Integer pageIndex) {
        return this.doInvoke(config, () -> this.documentFactory.getAsyncResult(jobId, pageIndex), "getAsyncResult");
    }

    public Result<InputStream, NetsuiteSoapAttributes> checkAsyncStatus(NetSuiteSoapConfig config, String jobId) {
        return this.doInvoke(config, () -> this.documentFactory.checkAsyncStatus(jobId), "checkAsyncStatus");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getDeleted(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getDeleted", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getDataCenterUrls(NetSuiteSoapConfig config, String accountId) {
        return this.doInvokeWithoutHeaderPreferences(config, () -> this.documentFactory.getDataCenterUrls(accountId), "getDataCenterUrls", true);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getPostingTransactionSummary(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getPostingTransactionSummary", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getSelectValue(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getSelectValue", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeAdvancedOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeRecordOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeAsyncOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeInviteeOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeItemOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeOperationWithCustomFields(NetSuiteSoapConfig config, String operation, InputStream message, String recordType) {
        boolean omitInternalIdFromCustomFieldNames = Utils.shouldOmitInternalIdCustomFieldNames(config, this.wsdlVersion);
        try {
            InputStream customFieldsOutgoing = this.getDocumentFactory().transformCustomFieldsAndRecordsOutgoing(message, config.getAdvancedConfig().getSeparator(), recordType, omitInternalIdFromCustomFieldNames);
            return this.invokeWithHeaderPreferences(config, operation, null, customFieldsOutgoing, false);
        }
        catch (TransformerException | XPathExpressionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithSearchPreferences(NetSuiteSoapConfig config, String operation, TransformationSupplier<Document> transformSupplier, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.doInvokeWithSearchPreferences(config, operation, message, bodyFieldsOnly, returnSearchColumns, pageSize);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithSearchPreferences(NetSuiteSoapConfig config, String operation, InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        try {
            String searchPreferences = this.documentFactory.convertToString(this.documentFactory.generateXmlSearchPreferences(bodyFieldsOnly, returnSearchColumns, pageSize));
            return this.invokeWithHeaderPreferences(config, operation, searchPreferences, message, false);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvoke(NetSuiteSoapConfig config, TransformationSupplier<Document> transformSupplier, String operation) {
        return this.doInvoke(config, transformSupplier, operation, false);
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithoutHeaderPreferences(NetSuiteSoapConfig config, TransformationSupplier<Document> transformSupplier, String operation, boolean useEndpointFromWsdl) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.invoke(config, operation, null, null, message, useEndpointFromWsdl);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvoke(NetSuiteSoapConfig config, TransformationSupplier<Document> transformSupplier, String operation, boolean useEndpointFromWsdl) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.invokeWithHeaderPreferences(config, operation, null, message, useEndpointFromWsdl);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeWithoutBody(NetSuiteSoapConfig config, String operation) {
        return this.doInvoke(config, () -> this.documentFactory.generateOperationEmptyBody(operation), operation, false);
    }

    public NetsuiteDocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public LazyValue<Map<String, String>> getSchemaMap() {
        return this.schemaMappings;
    }

    public Definitions getDefinitions() {
        return (Definitions)this.wsdlDefinitions.get();
    }

    public WsdlModel getWsdlModel() {
        return (WsdlModel)this.wsdlModel.get();
    }

    @VisibleForTesting
    protected WsdlModel loadWsdlModel() {
        logger.debug("Creating WsdlModel for {}.", (Object)this.wsdlUrlSupplier.get());
        WsdlModel wsdl = WsdlParser.Companion.parse(this.wsdlUrlSupplier.get(), StandardCharsets.UTF_8.name());
        logger.debug("Created WsdlModel for {}.", (Object)this.wsdlUrlSupplier.get());
        return wsdl;
    }

    @VisibleForTesting
    protected Definitions loadWSDLDefinitions() {
        Definitions definitions;
        logger.debug("Loading WSDL model (Predic8)");
        try {
            definitions = this.loadLocalWsdlDefinitions();
        }
        catch (IOException e) {
            logger.debug("Failed to load  WSDL model (Predic8) from local schema files", (Throwable)e);
            logger.debug("Loading WSDL model (Predic8) from remote location {}.", (Object)this.wsdlUrlSupplier.get());
            definitions = new WSDLParser().parse("https://webservices.netsuite.com/wsdl/v2020_2_0/netsuite.wsdl");
            logger.debug("Loaded WSDL model (Predic8) from remote location {}.", (Object)this.wsdlUrlSupplier.get());
        }
        return definitions;
    }

    @VisibleForTesting
    protected Definitions loadRemoteWsdlDefinitions() throws IOException {
        logger.debug("Loading WSDL model (Predic8) from remote schema files");
        Definitions definitions = new WSDLParser().parse("https://webservices.netsuite.com/wsdl/v2020_2_0/netsuite.wsdl");
        logger.debug("Loaded WSDL model (Predic8) from remote schema files");
        return definitions;
    }

    @VisibleForTesting
    protected Definitions loadLocalWsdlDefinitions() throws IOException {
        logger.debug("Loading WSDL model (Predic8) from local schema files");
        ClasspathResolver classpathResolver = new ClasspathResolver();
        WSDLParser parser = new WSDLParser();
        parser.setResourceResolver((Object)classpathResolver);
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setBaseDir("/" + WsdlVersion.getBaseDir(this.wsdlVersion) + "/");
        try (InputStream wsdlStream = this.getClass().getResourceAsStream("/" + WsdlVersion.getBaseDir(this.wsdlVersion) + "/" + LOCAL_WSDL_FILE);){
            ctx.setInput((Object)wsdlStream);
            Definitions definitions = parser.parse(ctx);
            logger.debug("Loaded WSDL model (Predic8) from local schema files");
            Definitions definitions2 = definitions;
            return definitions2;
        }
    }

    private Map<String, String> loadSchemaMappings() {
        return this.getDefinitions().getSchemas().stream().flatMap(e -> e.getAllElements().stream()).distinct().collect(Collectors.toMap(SchemaComponent::getName, e -> e.getType().getNamespaceURI()));
    }

    private Map<String, String> loadComplexTypesMappings() {
        HashSet uniques = new HashSet();
        return this.getDefinitions().getSchemas().stream().flatMap(schema -> schema.getComplexTypes().stream()).filter(complexType -> uniques.add(complexType.getName())).collect(Collectors.toMap(SchemaComponent::getName, e -> e.getQname().getNamespaceURI()));
    }

    public LazyValue<Map<String, String>> getComplexTypesMap() {
        return this.complexTypesMapping;
    }

    private static Map<String, TypedValue<String>> wrapHeaders(Map<String, String> headers) {
        HashMap<String, TypedValue<String>> wrapped = new HashMap<String, TypedValue<String>>();
        headers.forEach((k, v) -> wrapped.put((String)k, (TypedValue<String>)new TypedValue(v, DataType.XML_STRING)));
        return wrapped;
    }

    public Optional<WsdlVersion> getWsdlVersion() {
        return this.wsdlVersion;
    }

    private String bytesToString(InputStream messageWithNamespaces) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = messageWithNamespaces.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString("UTF-8");
        }
        catch (IOException e) {
            throw new NetsuiteTransformationException(String.format("Could not read from the inbound message for the operation %s (took %s ms)", new Object[0]), e);
        }
    }

    protected static interface TransformationSupplier<T> {
        public T get() throws ParserConfigurationException, TransformerException;
    }
}

