/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection;

import com.google.common.annotations.VisibleForTesting;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.error.provider.NetSuiteErrorTypeProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.soap.api.exception.SoapFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SoapResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(SoapResponseParser.class);
    private final XMLSecureFactories xmlSecureFactories;

    SoapResponseParser(XMLSecureFactories xmlSecureFactories) {
        this.xmlSecureFactories = xmlSecureFactories;
    }

    @VisibleForTesting
    protected InputStream parseResponse(InputStream content) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(content), 10240){

            @Override
            public void close() throws IOException {
            }
        };
        bufferedInputStream.mark(0);
        try {
            XMLEventReader reader = this.xmlSecureFactories.getXMLInputFactory().createXMLEventReader(bufferedInputStream);
            ErrorAggregator errorAggregator = new ErrorAggregator();
            while (reader.hasNext()) {
                Attribute isSuccessAttribute;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement strtElm = event.asStartElement();
                String localPart = strtElm.getName().getLocalPart();
                if (localPart.equals("status") && ((isSuccessAttribute = strtElm.getAttributeByName(QName.valueOf("isSuccess"))) == null || Boolean.parseBoolean(isSuccessAttribute.getValue()))) {
                    bufferedInputStream.reset();
                    return bufferedInputStream;
                }
                errorAggregator.addError(reader, localPart);
            }
            bufferedInputStream.reset();
            String exceptionDetail = IOUtils.toString((InputStream)bufferedInputStream, (Charset)StandardCharsets.UTF_8);
            bufferedInputStream.close();
            throw new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_ERROR, errorAggregator.getExceptionMessage(), exceptionDetail);
        }
        catch (IOException | XMLStreamException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected NetSuiteSoapModuleException parseSoapFault(SoapFaultException soapFaultException) {
        if (Objects.nonNull(soapFaultException.getCause())) {
            logger.error(soapFaultException.getCause().getMessage());
        }
        try {
            return this.parseSoapXmlException(soapFaultException);
        }
        catch (XMLStreamException e) {
            if (Objects.nonNull(soapFaultException.getCause()) && Objects.nonNull(soapFaultException.getCause().getMessage())) {
                return this.tryAlternativeFaultParsing(soapFaultException);
            }
            return new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_SOAP_FAULT, "Netsuite Fault: " + soapFaultException.getReason(), soapFaultException.getDetail());
        }
    }

    @NotNull
    private NetSuiteSoapModuleException tryAlternativeFaultParsing(SoapFaultException soapFaultException) {
        String message;
        Pattern pattern = Pattern.compile("^(<soapenv:Envelope.*soapenv:Envelope>)$", 8);
        Matcher matcher = pattern.matcher(message = soapFaultException.getCause().getMessage());
        if (matcher.find()) {
            String group = matcher.group(0);
            try {
                return this.alternativeXmlParsing(group);
            }
            catch (XMLStreamException ex) {
                return new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_SOAP_FAULT, "Netsuite Fault: " + message, message);
            }
        }
        return new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_SOAP_FAULT, "An error occurred during the communication with Netsuite: \n" + message, message);
    }

    @NotNull
    private NetSuiteSoapModuleException alternativeXmlParsing(String xml) throws XMLStreamException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        XMLEventReader reader = this.xmlSecureFactories.getXMLInputFactory().createXMLEventReader(stream);
        String errorCode = null;
        String faultString = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            String name = event.asStartElement().getName().getLocalPart();
            if (name.equals("faultcode")) {
                errorCode = reader.nextEvent().asCharacters().getData();
                continue;
            }
            if (!name.equals("faultstring")) continue;
            faultString = reader.nextEvent().asCharacters().getData();
        }
        String errorMessage = String.format("An error occurred during the communication with Netsuite. Raw error: \n%s", xml);
        if (Objects.nonNull(errorCode) || Objects.nonNull(faultString)) {
            errorMessage = String.format("An error occurred during the communication with Netsuite. FaultCode: \"%s\". FaultString: \"%s\". Raw error:\n%s", errorCode, faultString, xml);
        }
        return new NetSuiteSoapModuleException(NetSuiteErrorTypeProvider.getErrorType(errorCode), errorMessage, xml);
    }

    @NotNull
    private NetSuiteSoapModuleException parseSoapXmlException(SoapFaultException soapFaultException) throws XMLStreamException {
        ByteArrayInputStream stream = new ByteArrayInputStream(soapFaultException.getDetail().getBytes());
        XMLEventReader reader = this.xmlSecureFactories.getXMLInputFactory().createXMLEventReader(stream);
        String errorCode = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("code")) continue;
            errorCode = reader.nextEvent().asCharacters().getData();
            break;
        }
        return new NetSuiteSoapModuleException(NetSuiteErrorTypeProvider.getErrorType(errorCode), soapFaultException.getReason(), soapFaultException.getDetail());
    }

    private static class NetsuiteErrorCodeAndMessage {
        private static final String ERROR_AND_MESSAGE_FORMAT = "code %s and message \"%s\"";
        private String code;
        private String message;

        private NetsuiteErrorCodeAndMessage() {
        }

        String getErrorMessage() {
            this.complete();
            return String.format(ERROR_AND_MESSAGE_FORMAT, this.code, this.message);
        }

        boolean isNotEmpty() {
            return Objects.nonNull(this.code) || Objects.nonNull(this.message);
        }

        boolean isCompleted() {
            return Objects.nonNull(this.code) && Objects.nonNull(this.message);
        }

        private boolean processNode(XMLEventReader reader, String localPart) throws XMLStreamException {
            if (localPart.equals("code")) {
                if (Objects.nonNull(this.code)) {
                    this.complete();
                    return false;
                }
                this.code = reader.nextEvent().asCharacters().getData();
            } else if (localPart.equals("message")) {
                if (Objects.nonNull(this.message)) {
                    this.complete();
                    return false;
                }
                this.message = Optional.of(reader.nextEvent()).filter(evt -> !evt.isEndElement()).map(evt -> evt.asCharacters().getData()).orElse(null);
                this.complete();
            }
            return true;
        }

        private void complete() {
            if (Objects.isNull(this.code)) {
                this.code = "-";
            }
            if (Objects.isNull(this.message)) {
                this.message = "-";
            }
        }
    }

    private static class ErrorAggregator {
        private final List<NetsuiteErrorCodeAndMessage> netsuiteErrorCodeAndMessages = new ArrayList<NetsuiteErrorCodeAndMessage>();

        private ErrorAggregator() {
        }

        public void addError(XMLEventReader reader, String localPart) throws XMLStreamException {
            NetsuiteErrorCodeAndMessage errorCodeAndMessage = this.getProcessingMessage();
            boolean correct = errorCodeAndMessage.processNode(reader, localPart);
            if (!correct) {
                errorCodeAndMessage = this.getProcessingMessage();
                errorCodeAndMessage.processNode(reader, localPart);
            }
        }

        private NetsuiteErrorCodeAndMessage getProcessingMessage() {
            if (this.netsuiteErrorCodeAndMessages.isEmpty() || this.netsuiteErrorCodeAndMessages.get(this.netsuiteErrorCodeAndMessages.size() - 1).isCompleted()) {
                NetsuiteErrorCodeAndMessage errorCodeAndMessage = new NetsuiteErrorCodeAndMessage();
                this.netsuiteErrorCodeAndMessages.add(errorCodeAndMessage);
                return errorCodeAndMessage;
            }
            return this.netsuiteErrorCodeAndMessages.get(this.netsuiteErrorCodeAndMessages.size() - 1);
        }

        public String getExceptionMessage() {
            return this.netsuiteErrorCodeAndMessages.stream().filter(NetsuiteErrorCodeAndMessage::isNotEmpty).map(NetsuiteErrorCodeAndMessage::getErrorMessage).collect(Collectors.joining(" & "));
        }
    }
}

