/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection.provider.config;

import com.mulesoft.connector.netsuite.api.ConcurrencyStrategyConfiguration;
import com.mulesoft.connector.netsuite.api.NoneConcurrencyManagement;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AdvancedConfig {
    @Parameter
    @Optional(defaultValue="-1")
    @Placement(tab="Advanced", order=2)
    @Summary(value="The maximum amount of connections that can be active to execute the http requests. If this is not set, the default is -1 which does not limit the amount of connections to the server")
    private Integer maximumConnections;
    @Parameter
    @Optional(defaultValue="60000")
    @Placement(tab="Advanced", order=3)
    @Summary(value="The amount of time that the client will wait for a response before it times out. 0 specifies that the client will wait indefinitely.")
    private Integer readTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=4)
    @Summary(value="The time unit for Read Timeout.")
    private TimeUnit readTimeoutUnit;
    @Parameter
    @Optional(defaultValue="60000")
    @Placement(tab="Advanced", order=5)
    @Summary(value="The amount of time that the client will attempt to establish a connection before it times out. 0 specifies that the client will continue to attempt to open a connection indefinitely.")
    private Integer connectionTimeout;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced", order=6)
    @Summary(value="The time unit for Connection Timeout.")
    private TimeUnit connectionTimeoutUnit;
    @Parameter
    @Optional(defaultValue="https://webservices.netsuite.com")
    @Example(value="https://webservices.netsuite.com")
    @Placement(tab="Advanced", order=7)
    @DisplayName(value="Base Netsuite Address")
    @Summary(value="The base address to use to connect to netsuite. The default value is the main netsuite site. This is used to automatically obtain the endpoint for the service based on the credentials configured, and will need no change.")
    private String baseAddress;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    @DisplayName(value="Concurrency Management Strategy")
    @Optional
    @Summary(value="A strategy for dealing with TOO_MANY_REQUEST error.")
    @Placement(tab="Advanced", order=8)
    private ConcurrencyStrategyConfiguration concurrencyStrategy;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    @Optional
    @DisplayName(value="TLS configuration")
    @Placement(tab="Security", order=1)
    private TlsContextFactory tlsContext;

    public ConcurrencyStrategyConfiguration getConcurrencyStrategy() {
        if (Objects.isNull(this.concurrencyStrategy)) {
            return NoneConcurrencyManagement.INSTANCE;
        }
        return this.concurrencyStrategy;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout == 0 ? -1 : this.readTimeout;
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.connectionTimeoutUnit;
    }

    public Integer getMaximumConnections() {
        return this.maximumConnections;
    }

    public Integer getReadTimeout() {
        return this.readTimeout == 0 ? -1 : this.readTimeout;
    }

    public TimeUnit getReadTimeoutUnit() {
        return this.readTimeoutUnit;
    }

    public Integer getConnectionTimeoutInMillis() {
        return Math.toIntExact(this.connectionTimeoutUnit.toMillis(this.getConnectionTimeout().intValue()));
    }

    public Integer getReadTimeoutInMillis() {
        return Math.toIntExact(this.readTimeoutUnit.toMillis(this.getReadTimeout().intValue()));
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }
}

