/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.error.exception;

import com.mulesoft.connector.netsuite.internal.error.ErrorContent;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import java.util.Optional;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class NetSuiteSoapModuleException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;
    private static final String SIMPLE_MESSAGE_FORMAT = "%s: %s";
    private static final String COMPOSED_MESSAGE_FORMAT = "%s: Status was not successful with %s";

    public NetSuiteSoapModuleException(ErrorTypeDefinition<NetSuiteSoapErrorType> code, String errorMessage, String errorDetail) {
        super(String.format(SIMPLE_MESSAGE_FORMAT, code, errorMessage), code);
        this.message = this.buildErrorMessage(errorMessage, code.getType(), errorDetail);
    }

    public NetSuiteSoapModuleException(NetSuiteSoapErrorType code, String composedErrorMessage, String errorDetail) {
        super(String.format(COMPOSED_MESSAGE_FORMAT, new Object[]{code, composedErrorMessage}), (ErrorTypeDefinition)code);
        this.message = this.buildErrorMessage(composedErrorMessage, code.toString(), errorDetail);
    }

    public NetSuiteSoapModuleException(String message, ErrorTypeDefinition code) {
        super(String.format(SIMPLE_MESSAGE_FORMAT, code, message), code);
        this.message = this.buildErrorMessage(message, code.toString(), null);
    }

    public NetSuiteSoapModuleException(String message, ErrorTypeDefinition code, Throwable cause) {
        super(String.format(SIMPLE_MESSAGE_FORMAT, code, message), code, cause);
        this.message = this.buildErrorMessage(message, code.toString(), null);
    }

    public Message getErrorMessage() {
        return Optional.ofNullable(this.message).orElse(null);
    }

    private Message buildErrorMessage(String message, String errorCode, String errorDetail) {
        return Message.builder().payload(new TypedValue((Object)new ErrorContent(errorCode, message, errorDetail), DataType.OBJECT)).build();
    }
}

