/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata;

import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.metadata.GenericMetadataResolver;
import com.mulesoft.connector.netsuite.internal.metadata.generic.GenericDeletedRecordMetadataResolver;
import com.predic8.schema.ComplexContent;
import com.predic8.schema.ComplexType;
import com.predic8.schema.SchemaComponent;
import com.predic8.schema.Sequence;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

public class SourcesMetadataResolvers {
    private SourcesMetadataResolvers() {
    }

    public static class OnNewSourceMetadataResolver
    extends OnNewAndOnModifiedSourceAbstractMetadataResolver {
        public OnNewSourceMetadataResolver() {
            super("on-new-source");
        }

        public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
            return super.getKeys(metadataContext, true);
        }
    }

    public static abstract class OnNewAndOnModifiedSourceAbstractMetadataResolver
    extends GenericMetadataResolver
    implements TypeKeysResolver {
        protected static final String SEARCH_BASIC = "SearchBasic";
        private static final String SEARCH_RECORD = "SearchRecord";
        public static final List<String> MODIFIED_FIELDS = Arrays.asList("lastModifiedDate", "modified");
        public static final List<String> CREATED_FIELDS = Arrays.asList("createdDate", "created", "dateCreated");

        protected OnNewAndOnModifiedSourceAbstractMetadataResolver(String operationName) {
            super(operationName);
        }

        @Override
        public MetadataType getOutputType(MetadataContext metadataContext, Object recordType) {
            return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().id("#root:record").build();
        }

        public static Map<String, String> getBasicKeysWithFields(NetSuiteSoapConnection connection, boolean isNewSource) throws ConnectionException, MetadataResolvingException {
            HashMap<String, String> keysMap = new HashMap<String, String>();
            for (String searchBasicKey : OnNewAndOnModifiedSourceAbstractMetadataResolver.getSearchBasicKeys(connection)) {
                ComplexType foundComplexType = OnNewAndOnModifiedSourceAbstractMetadataResolver.getSearchBasicComplexTypes(connection).stream().filter(complexType -> complexType.getName().equals(searchBasicKey)).findFirst().orElseThrow(() -> new MetadataResolvingException("Key not found: " + searchBasicKey, FailureCode.COMPONENT_NOT_FOUND));
                Set complexTypeFields = ((Sequence)((ComplexContent)foundComplexType.getModel()).getDerivation().getModel()).getElements().stream().map(SchemaComponent::getName).collect(Collectors.toSet());
                (isNewSource ? CREATED_FIELDS : MODIFIED_FIELDS).stream().filter(complexTypeFields::contains).findFirst().ifPresent(foundField -> keysMap.put(searchBasicKey, (String)foundField));
            }
            return keysMap;
        }

        protected Set<MetadataKey> getKeys(MetadataContext metadataContext, boolean isNewSource) throws ConnectionException, MetadataResolvingException {
            NetSuiteSoapConnection connection = (NetSuiteSoapConnection)metadataContext.getConnection().orElseThrow(() -> new NullPointerException("Connection not found"));
            return OnNewAndOnModifiedSourceAbstractMetadataResolver.getBasicKeysWithFields(connection, isNewSource).keySet().stream().sorted().map(searchBasicKey -> MetadataKeyBuilder.newKey((String)searchBasicKey).withDisplayName(searchBasicKey.substring(0, searchBasicKey.length() - SEARCH_BASIC.length())).build()).collect(Collectors.toSet());
        }

        private static Set<String> getSearchBasicKeys(NetSuiteSoapConnection connection) throws ConnectionException {
            return OnNewAndOnModifiedSourceAbstractMetadataResolver.getSearchBasicComplexTypes(connection).stream().map(complexType -> complexType.getQname().getLocalPart()).filter(searchType -> searchType.endsWith(SEARCH_BASIC)).collect(Collectors.toSet());
        }

        private static Set<ComplexType> getSearchBasicComplexTypes(NetSuiteSoapConnection connection) {
            return connection.getDefinitions().getSchemas().stream().flatMap(schema -> schema.getComplexTypes().stream()).filter(complexType -> complexType.getSuperTypes().stream().anyMatch(superType -> superType.getLocalPart().equals(SEARCH_RECORD))).collect(Collectors.toSet());
        }
    }

    public static class OnModifiedSourceMetadataResolver
    extends OnNewAndOnModifiedSourceAbstractMetadataResolver {
        public OnModifiedSourceMetadataResolver() {
            super("on-modified-source");
        }

        public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
            return super.getKeys(metadataContext, false);
        }
    }

    public static class OnDeletedSourceMetadataResolver
    extends GenericDeletedRecordMetadataResolver {
        public OnDeletedSourceMetadataResolver() {
            super("on-deleted-source");
        }
    }
}

