/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata.factory;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connector.netsuite.internal.metadata.factory.CachedXmlTypeLoader;
import com.predic8.schema.Import;
import com.predic8.wsdl.Definitions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTypeLoaderFactory {
    public static final String OVERRIDES_JSON = "wsdl/_overrides.json";
    public static final String OVERRIDES = "overrides";
    private static final Logger logger = LoggerFactory.getLogger(XmlTypeLoaderFactory.class);

    private XmlTypeLoaderFactory() {
    }

    public static XmlTypeLoader createCachedXmlTypeLoaderWithLocalDefinitions(Definitions definitions, String definitionsDirectory) {
        Map<String, String> schemaLocations = definitions.getSchemas().stream().flatMap(e -> e.getImports().stream()).collect(Collectors.toMap(Import::getNamespace, v -> definitionsDirectory + "/" + v.getSchemaLocation(), (a, b) -> a));
        schemaLocations.put("connectorCommons", definitionsDirectory + "/connector.xsd");
        ArrayList<URL> schemaUrls = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
            schemaUrls.add(Thread.currentThread().getContextClassLoader().getResource(entry.getValue()));
        }
        SchemaCollector schemaCollector = SchemaCollector.getInstance();
        schemaUrls.forEach(arg_0 -> ((SchemaCollector)schemaCollector).addSchema(arg_0));
        CachedXmlTypeLoader xmlTypeLoader = new CachedXmlTypeLoader(schemaCollector);
        logger.debug("finished creating XmlTypeLoader");
        return xmlTypeLoader;
    }

    public static XmlTypeLoader createOverrideXmlTypeLoader(String type, String baseDir) {
        logger.debug("Loading xsd override for {} record type.", (Object)type);
        SchemaCollector schemaCollector = SchemaCollector.getInstance();
        XmlTypeLoaderFactory.getXSDFileNames(type.toLowerCase(Locale.ROOT)).ifPresent(files -> files.forEach(file -> {
            String filePath = baseDir + File.separator + file;
            logger.debug("Adding {} to schemaCollector.", (Object)filePath);
            schemaCollector.addSchema(Thread.currentThread().getContextClassLoader().getResource(filePath));
        }));
        return new CachedXmlTypeLoader(schemaCollector);
    }

    public static Optional<List<String>> getXSDFileNames(String type) {
        logger.debug("Loading list of file names for {} record type.", (Object)type);
        try {
            Map result = (Map)new ObjectMapper().readValue(Thread.currentThread().getContextClassLoader().getResourceAsStream(OVERRIDES_JSON), (TypeReference)new TypeReference<Map<String, Object>>(){});
            List files = (List)((Map)result.get(OVERRIDES)).get(type);
            logger.debug("Loaded list of file names for {} record type. Files : {}.", (Object)type, (Object)files);
            return Optional.ofNullable(files);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

