/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata.query;

import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQuery;
import com.mulesoft.connector.netsuite.internal.util.Utils;
import com.predic8.schema.ComplexType;
import com.predic8.schema.Element;
import com.predic8.schema.Schema;
import com.predic8.schema.SimpleType;
import com.predic8.soamodel.TypeRefAccessException;
import com.predic8.wsdl.Definitions;
import groovy.xml.QName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefinitionsQueryImpl
implements DefinitionsQuery {
    private Definitions definitions;

    public DefinitionsQueryImpl(Definitions definitions) {
        this.definitions = definitions;
    }

    @Override
    public List<ComplexType> getComplexSuperTypes(String localName) {
        return this.getComplexTypes().stream().filter(v -> this.hasAncestor((ComplexType)v, localName)).collect(Collectors.toList());
    }

    @Override
    public List<ComplexType> getComplexTypes() {
        return this.definitions.getSchemas().stream().map(Schema::getComplexTypes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<ComplexType> getSuperTypes(String superTypeLocalName) {
        return this.getComplexTypes().stream().filter(v -> superTypeLocalName.equals(v.getQname().getLocalPart())).collect(Collectors.toList());
    }

    @Override
    public boolean hasAncestor(ComplexType complexType, String superTypeLocalName) {
        List superTypesLocalNames = complexType.getSuperTypes().stream().map(QName::getLocalPart).collect(Collectors.toList());
        List parentComplexTypes = this.getComplexTypes().stream().filter(v -> superTypesLocalNames.contains(v.getQname().getLocalPart())).collect(Collectors.toList());
        for (ComplexType eachComplexType : parentComplexTypes) {
            if (!superTypeLocalName.equals(eachComplexType.getQname().getLocalPart()) && !this.hasAncestor(eachComplexType, superTypeLocalName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getRecordTypes() {
        Optional<SimpleType> recordTypeSimpleType = this.getSimpleType("RecordType");
        if (!recordTypeSimpleType.isPresent()) {
            return Collections.emptyList();
        }
        List lowerCaseRecordTypes = recordTypeSimpleType.get().getRestriction().getEnumerationFacets().stream().map(e -> e.getValue()).map(String::toLowerCase).collect(Collectors.toList());
        return this.getAllElements().stream().map(e -> e.getName()).filter(e -> lowerCaseRecordTypes.contains(e.toLowerCase())).collect(Collectors.toList());
    }

    @Override
    public Optional<String> getElement(String localPartName) {
        Optional<Element> foundElement = this.getAllElements().stream().filter(v -> v.getQname().getLocalPart().equalsIgnoreCase(localPartName)).findFirst();
        return foundElement.map(element -> Optional.ofNullable(element.getQname().getLocalPart())).orElseGet(() -> Optional.of(Utils.toLowerCamelCase(localPartName)));
    }

    @Override
    public Optional<String> resolveNamespaceFor(String localPart) {
        String found = this.getElementNameToNamespaceURIMappings().get(localPart);
        if (found == null) {
            found = localPart.equals("file") ? this.getComplexTypeNameToNamespaceURIMappings().get("File") : this.getComplexTypeNameToNamespaceURIMappings().get(localPart);
        }
        return Optional.ofNullable(found);
    }

    Map<String, String> getElementNameToNamespaceURIMappings() {
        return this.getAllElements().stream().distinct().collect(Collectors.toMap(e -> e.getName(), e -> e.getType().getNamespaceURI()));
    }

    Map<String, String> getComplexTypeNameToNamespaceURIMappings() {
        return this.getComplexTypes().stream().distinct().collect(Collectors.toMap(e -> e.getName(), e -> e.getNamespaceUri(), (a, b) -> a));
    }

    List<Element> getAllElements() {
        return this.definitions.getSchemas().stream().flatMap(e -> e.getAllElements().stream()).collect(Collectors.toList());
    }

    Optional<SimpleType> getSimpleType(String simpleTypeLocalName) {
        return this.definitions.getSchemas().stream().map(e -> {
            try {
                return e.getSimpleType(simpleTypeLocalName);
            }
            catch (TypeRefAccessException ex) {
                return null;
            }
        }).filter(e -> e != null).findFirst();
    }

    @Override
    public List<String> getGetAllTypes() {
        Optional<SimpleType> getAllRecordType = this.getSimpleType("GetAllRecordType");
        if (!getAllRecordType.isPresent()) {
            return Collections.emptyList();
        }
        List lowerCaseGetAllTypes = getAllRecordType.get().getRestriction().getEnumerationFacets().stream().map(e -> e.getValue().toLowerCase()).collect(Collectors.toList());
        return this.getAllElements().stream().map(e -> StringUtils.capitalize((String)e.getName())).sorted().filter(e -> lowerCaseGetAllTypes.contains(e.toLowerCase())).collect(Collectors.toList());
    }
}

