/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.source;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.metadata.SourcesMetadataResolvers;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import com.mulesoft.connector.netsuite.internal.source.AbstractPollingSource;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.w3c.dom.Document;

@Alias(value="modified-object-listener")
@DisplayName(value="On Modified Object")
@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
@MetadataScope(outputResolver=SourcesMetadataResolvers.OnModifiedSourceMetadataResolver.class, keysResolver=SourcesMetadataResolvers.OnModifiedSourceMetadataResolver.class)
@MediaType(value="text/xml")
public class OnModifiedSource
extends AbstractPollingSource {
    @Parameter
    @Placement(order=1)
    @Summary(value="The type of record that will be retrieved when modified.")
    @MetadataKeyId(value=SourcesMetadataResolvers.OnModifiedSourceMetadataResolver.class)
    private String objectType;

    protected void doStart() throws MuleException {
        Map<String, String> basicKeysWithFields = SourcesMetadataResolvers.OnNewAndOnModifiedSourceAbstractMetadataResolver.getBasicKeysWithFields(this.getConnection(), false);
        this.setWaterMarkFieldName(basicKeysWithFields.get(this.objectType));
    }

    @Override
    protected Function<Document, Optional<String>> watermarkParser() {
        return node -> this.extractFirstOf((Document)node, SourcesMetadataResolvers.OnNewAndOnModifiedSourceAbstractMetadataResolver.MODIFIED_FIELDS);
    }

    @Override
    protected IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> getResultsIterator(NetSuiteSoapConnection connection, ZonedDateTime queryStartDateTime) throws TransformerException, ParserConfigurationException {
        InputStream searchBody = connection.getDocumentFactory().newAndModifiedSourceBodyRequest(this.objectType, queryStartDateTime, this.getWaterMarkFieldName(), NetSuiteSoapConnection.DATETIME_FORMAT_FROM_NETSUITE);
        return (IterablePagingProvider)new RecordOperations().search(this.getConfig(), "", searchBody, this.getPageSize(), -1, this.isBodyFieldsOnly(), false);
    }
}

