/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.util;

import com.mulesoft.connector.netsuite.api.WsdlVersion;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.wsdl.parser.model.message.MessageDefinition;
import org.mule.wsdl.parser.model.message.MessagePart;
import org.mule.wsdl.parser.model.operation.Type;

public final class MetadataUtils {
    private static final String SOAP_HEADERS = "soapHeaders";
    private static final String ATTACHMENTS = "attachments";

    private MetadataUtils() {
    }

    public static MetadataType buildNetsuiteSoapAttributeMetadataObject(Type outputType, BaseTypeBuilder baseTypeBuilder) {
        MetadataType attachments = outputType.getAttachments();
        MetadataType soaHeaders = outputType.getHeaders();
        return MetadataUtils.buildNetsuiteSoapAttributeMetadataObject(attachments, soaHeaders, baseTypeBuilder);
    }

    public static MetadataType buildNetsuiteSoapAttributeMetadataObject(MetadataType attachments, MetadataType soaHeaders, BaseTypeBuilder baseTypeBuilder) {
        ObjectTypeBuilder output = baseTypeBuilder.objectType();
        MetadataUtils.add(output, ATTACHMENTS, attachments);
        MetadataUtils.add(output, SOAP_HEADERS, soaHeaders);
        return output.build();
    }

    private static void add(ObjectTypeBuilder typeBuilder, String fieldName, MetadataType fieldType) {
        typeBuilder.addField().key(fieldName).value(fieldType);
    }

    public static Type removeWsdlVersionInType(Type type, Optional<WsdlVersion> wsdlVersion) throws MetadataResolvingException {
        if (wsdlVersion.isPresent()) {
            MetadataUtils.replaceWsdlVersionInMessage(type.getMessage(), wsdlVersion.get().getValue());
        }
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(type.getBody(), wsdlVersion);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(type.getHeaders(), wsdlVersion);
        return type;
    }

    private static void removeWsdlVersionInField(Object targetObject, String fieldName, String valueToReplace, String wsdlVersion) throws MetadataResolvingException {
        try {
            ClassUtils.setFieldValue((Object)targetObject, (String)fieldName, (Object)valueToReplace.replace("_" + wsdlVersion, ""), (boolean)false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MetadataResolvingException("Error replacing Wsdl Version in metadata namespaces", FailureCode.RESOURCE_UNAVAILABLE);
        }
    }

    public static void replaceWsdlVersionInMetadataTypeIfPossible(MetadataType type, Optional<WsdlVersion> wsdlVersion) throws MetadataResolvingException {
        if (wsdlVersion.isPresent() && type instanceof DefaultObjectType) {
            String wsdlVersionValue = wsdlVersion.get().getValue();
            if (((DefaultObjectType)type).getFields().isEmpty()) {
                MetadataUtils.removeNamespaceInAnnotations(type.getAnnotations(), wsdlVersionValue);
            } else {
                for (ObjectFieldType fieldType : ((DefaultObjectType)type).getFields()) {
                    if (!(fieldType instanceof DefaultObjectFieldType)) continue;
                    DefaultObjectFieldType defaultObjectFieldType = (DefaultObjectFieldType)fieldType;
                    QName qName = defaultObjectFieldType.getKey().getName();
                    MetadataUtils.removeWsdlVersionInField(qName, "namespaceURI", qName.getNamespaceURI(), wsdlVersionValue);
                    MetadataUtils.removeNamespaceInAnnotations(type.getAnnotations(), wsdlVersionValue);
                    if (!(defaultObjectFieldType.getValue() instanceof DefaultObjectType)) continue;
                    MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(defaultObjectFieldType.getValue(), wsdlVersion);
                }
            }
        }
    }

    private static void replaceWsdlVersionInMessage(MessageDefinition message, String wsdlVersion) throws MetadataResolvingException {
        MetadataUtils.removeWsdlVersionInField(message, "name", message.getName(), wsdlVersion);
        for (MessagePart part : message.getParts()) {
            MetadataUtils.removeWsdlVersionInField(part.getElementName(), "namespaceURI", Objects.requireNonNull(part.getElementName()).getNamespaceURI(), wsdlVersion);
        }
    }

    private static void removeNamespaceInAnnotations(Set<TypeAnnotation> annotations, String wsdlVersion) throws MetadataResolvingException {
        for (TypeAnnotation annotation : annotations) {
            if (!(annotation instanceof TypeIdAnnotation)) continue;
            MetadataUtils.removeWsdlVersionInField(annotation, "value", ((TypeIdAnnotation)annotation).getValue(), wsdlVersion);
        }
    }
}

