/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Document;

public class XmlFactories {
    private static final XMLSecureFactories xmlSecureFactories = XMLSecureFactories.createDefault();
    private static LazyValue<TransformerFactory> singletonTransformerFactory = new LazyValue(XmlFactories::loadTransformerFactory);
    private static LazyValue<DocumentBuilderFactory> singletonDocumentFactory = new LazyValue(XmlFactories::loadDocumentFactory);

    private XmlFactories() {
    }

    public static synchronized TransformerFactory getTransformerFactory() throws TransformerConfigurationException {
        return (TransformerFactory)singletonTransformerFactory.get();
    }

    public static synchronized DocumentBuilderFactory getDocumentTransformerFactory() throws TransformerConfigurationException {
        return (DocumentBuilderFactory)singletonDocumentFactory.get();
    }

    public static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        return xmlSecureFactories.getDocumentBuilderFactory();
    }

    public static synchronized Document createNewDocument() throws ParserConfigurationException {
        return XmlFactories.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
    }

    public static DocumentBuilderFactory loadDocumentFactory() {
        DocumentBuilderFactory documentBuilderFactory = xmlSecureFactories.getDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        return documentBuilderFactory;
    }

    public static TransformerFactory loadTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }
}

