/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.xml;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtils {
    private XmlUtils() {
    }

    public static <T> T executeXPath(String expression, Node source, QName returnType) throws XPathExpressionException {
        return (T)XmlUtils.executeinternalXPath(expression, source, returnType);
    }

    public static String executeXPath(String expression, Node source) throws XPathExpressionException {
        return XmlUtils.executeinternalXPath(expression, source);
    }

    public static Object executeXPath(String expression, InputStream source, QName returnType) throws XPathExpressionException {
        return XmlUtils.executeinternalXPath(expression, new InputSource(source), returnType);
    }

    public static Object executeXPath(String expression, InputStream source) throws XPathExpressionException {
        return XmlUtils.executeinternalXPath(expression, new InputSource(source));
    }

    protected static String executeinternalXPath(String expression, Node node) throws XPathExpressionException {
        XPathExpression compile = XmlUtils.getXPath(node).compile(expression);
        return compile.evaluate(node);
    }

    protected static Object executeinternalXPath(String expression, Node node, QName returnType) throws XPathExpressionException {
        XPathExpression compile = XmlUtils.getXPath(node).compile(expression);
        return compile.evaluate(node, returnType);
    }

    protected static String executeinternalXPath(String expression, InputSource source) throws XPathExpressionException {
        XPathExpression compile = XmlUtils.getXPath().compile(expression);
        return compile.evaluate(source);
    }

    protected static Object executeinternalXPath(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        XPathExpression compile = XmlUtils.getXPath().compile(expression);
        return compile.evaluate(source, returnType);
    }

    private static synchronized XPath getXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceResolverFromNodesDocument(null));
        return xPath;
    }

    private static synchronized XPath getXPath(Node node) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceResolverFromNodesDocument(node.getOwnerDocument()));
        return xPath;
    }

    public static List<Node> toList(NodeList nodeList) {
        if (nodeList != null) {
            return IntStream.range(0, nodeList.getLength()).mapToObj(i -> nodeList.item(i)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static class NamespaceResolverFromNodesDocument
    implements NamespaceContext {
        private Document sourceDocument;

        public NamespaceResolverFromNodesDocument(Document document) {
            this.sourceDocument = document;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceDocument.lookupNamespaceURI(null);
            }
            return this.sourceDocument.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceDocument.lookupPrefix(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

