/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.BaseCommand;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandException;
import org.openas2.cmd.CommandResult;

public class MultiCommand
extends BaseCommand {
    private List<Command> cmds;

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.getParameter("name", true);
        this.getParameter("description", true);
        if (this.getUsage() == null) {
            this.setUsage(this.getName() + " <command> <parameters>");
        }
    }

    public Command getCommand(String name) {
        name = name.toLowerCase();
        List<Command> commands = this.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            Command cmd = commands.get(i);
            if (!cmd.getName().equals(name)) continue;
            return cmd;
        }
        return null;
    }

    public List<Command> getCommands() {
        if (this.cmds == null) {
            this.cmds = new ArrayList<Command>();
        }
        return this.cmds;
    }

    public String getDescription(String name) {
        Command cmd = this.getCommand(name);
        if (cmd != null) {
            return cmd.getDescription();
        }
        return null;
    }

    public String getUsage(String name) {
        Command cmd = this.getCommand(name);
        if (cmd != null) {
            return cmd.getUsage();
        }
        return null;
    }

    @Override
    public CommandResult execute(Object[] params) {
        String subName;
        Command subCmd;
        if (params.length > 0 && (subCmd = this.getCommand(subName = params[0].toString())) != null) {
            List<Object> paramList = Arrays.asList(params);
            ArrayList<Object> subParams = new ArrayList<Object>(paramList);
            subParams.remove(0);
            return subCmd.execute(subParams.toArray());
        }
        CommandResult listCmds = new CommandResult("ERROR", "List of valid subcommands:");
        for (Command currentCmd : this.getCommands()) {
            listCmds.getResults().add(currentCmd.getName());
        }
        return listCmds;
    }

    public CommandResult execute(String name, Object[] params) throws OpenAS2Exception {
        Command cmd = this.getCommand(name);
        if (cmd != null) {
            return cmd.execute(params);
        }
        throw new CommandException("Command doesn't exist: " + name);
    }

    public boolean supports(String name) {
        return this.getCommand(name) != null;
    }

    @Override
    public String getDefaultName() {
        return null;
    }

    @Override
    public String getDefaultDescription() {
        return null;
    }

    @Override
    public String getDefaultUsage() {
        return null;
    }
}

