/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.message;

import org.openas2.message.AS2Message;
import org.openas2.message.BaseMessageMDN;
import org.openas2.params.InvalidParameterException;
import org.openas2.util.AS2Util;

public class AS2MessageMDN
extends BaseMessageMDN {
    public static final String MDNA_REPORTING_UA = "REPORTING_UA";
    public static final String MDNA_ORIG_RECIPIENT = "ORIGINAL_RECIPIENT";
    public static final String MDNA_FINAL_RECIPIENT = "FINAL_RECIPIENT";
    public static final String MDNA_ORIG_MESSAGEID = "ORIGINAL_MESSAGE_ID";
    public static final String MDNA_DISPOSITION = "DISPOSITION";
    public static final String MDNA_MIC = "MIC";
    private static final long serialVersionUID = 1L;

    public AS2MessageMDN(AS2Message msg, boolean copyMsgHeaders) {
        super(msg);
        if (copyMsgHeaders) {
            this.copyHeaders(msg.getHeaders());
        }
        this.setHeader("AS2-To", msg.getHeader("AS2-From"));
        this.setHeader("AS2-From", msg.getHeader("AS2-To"));
    }

    @Override
    public String generateMessageID() throws InvalidParameterException {
        return AS2Util.generateMessageID(this.getMessage(), true);
    }
}

