/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.message.InvalidMessageException;
import org.openas2.message.Message;
import org.openas2.params.CompositeParameters;
import org.openas2.params.DateParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.processor.receiver.BaseReceiverModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.HTTPUtil;
import org.openas2.util.IOUtil;
import org.openas2.util.Properties;
import org.openas2.util.ResponseWrapper;

public abstract class NetModule
extends BaseReceiverModule {
    public static final String PARAM_ADDRESS = "address";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_PROTOCOL = "protocol";
    public static final String PARAM_SSL_KEYSTORE = "ssl_keystore";
    public static final String PARAM_SSL_KEYSTORE_PASSWORD = "ssl_keystore_password";
    public static final String PARAM_SSL_PROTOCOL = "ssl_protocol";
    public static final String PARAM_ERROR_DIRECTORY = "errordir";
    public static final String PARAM_ERRORS = "errors";
    public static final String DEFAULT_ERRORS = "$date.yyyyMMddhhmmss$";
    private HTTPServerThread mainThread;
    private Log logger = LogFactory.getLog((String)NetModule.class.getSimpleName());

    @Override
    public void doStart() throws OpenAS2Exception {
        try {
            this.mainThread = new HTTPServerThread(this, this.getParameter(PARAM_ADDRESS, false), this.getParameterInt(PARAM_PORT, true));
            this.mainThread.start();
        }
        catch (IOException ioe) {
            String host = this.getParameter(PARAM_ADDRESS, false);
            if (host == null || host.length() < 1) {
                host = "localhost";
            }
            this.logger.error((Object)("Error in HTTP connection starting server thread on host::port: " + host + "::" + this.getParameterInt(PARAM_PORT, true)), (Throwable)ioe);
            throw new WrappedException(ioe);
        }
    }

    @Override
    public void doStop() throws OpenAS2Exception {
        if (this.mainThread != null) {
            this.mainThread.terminate();
            this.mainThread = null;
        }
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        this.getParameter(PARAM_PORT, true);
        String pwd = System.getProperty("org.openas2.ssl.Password");
        if (pwd != null) {
            this.setParameter(PARAM_SSL_KEYSTORE_PASSWORD, pwd);
        }
    }

    @Override
    public boolean healthcheck(List<String> failures) {
        try {
            String hcHost = this.getParameter(PARAM_ADDRESS, Properties.getProperty("ssl_host_name", "localhost"));
            String hcPort = this.getParameter(PARAM_PORT, true);
            String hcProtocol = this.getParameter(PARAM_PROTOCOL, "http");
            String urlString = hcProtocol + "://" + hcHost + ":" + hcPort + "/" + Properties.getProperty("health_check_uri", "healthcheck");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Helthcheck about to try URL: " + urlString));
            }
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("http_override_ssl_checks", "true");
            ResponseWrapper rw = HTTPUtil.execRequest("GET", urlString, null, null, null, options);
            if (200 != rw.getStatusCode()) {
                failures.add(this.getClass().getSimpleName() + " - Error making HTTP connection. Response code: " + rw.getStatusCode() + " " + rw.getStatusPhrase());
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to execute healthcheck.", (Throwable)e);
            failures.add(this.getClass().getSimpleName() + " - Failed to execute HTTP connection to listener: " + e.getMessage());
            return false;
        }
        return true;
    }

    protected abstract NetModuleHandler getHandler();

    protected void handleError(Message msg, OpenAS2Exception oae) {
        oae.addSource("message", msg);
        oae.terminate();
        try {
            CompositeParameters params = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(msg));
            String name = params.format(this.getParameter(PARAM_ERRORS, DEFAULT_ERRORS));
            String directory = this.getParameter(PARAM_ERROR_DIRECTORY, true);
            File msgFile = IOUtil.getUnique(IOUtil.getDirectoryFile(directory), IOUtil.cleanFilename(name));
            String msgText = msg.toString();
            FileOutputStream fOut = new FileOutputStream(msgFile);
            fOut.write(msgText.getBytes());
            fOut.close();
            InvalidMessageException im = new InvalidMessageException("Stored invalid message to " + msgFile.getAbsolutePath());
            im.terminate();
        }
        catch (OpenAS2Exception oae2) {
            oae2.addSource("message", msg);
            oae2.terminate();
        }
        catch (IOException ioe) {
            WrappedException we = new WrappedException(ioe);
            we.addSource("message", msg);
            we.terminate();
        }
    }

    protected class HTTPServerThread
    extends Thread {
        private NetModule owner;
        private ServerSocket socket;
        private boolean terminated;

        HTTPServerThread(@Nullable NetModule owner, String address, int port) throws IOException {
            super(ClassUtils.getSimpleName(HTTPServerThread.class) + " (" + (String)StringUtils.defaultIfBlank((CharSequence)address, (CharSequence)"0.0.0.0") + ":" + port + ")");
            this.owner = owner;
            String protocol = "http";
            String sslProtocol = "TLS";
            try {
                protocol = owner.getParameter(NetModule.PARAM_PROTOCOL, "http");
                sslProtocol = owner.getParameter(NetModule.PARAM_SSL_PROTOCOL, "TLS");
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            if ("https".equalsIgnoreCase(protocol)) {
                SSLContext sc;
                TrustManagerFactory tmf;
                KeyManagerFactory kmf;
                KeyStore ks;
                char[] ksPass;
                String ksName;
                try {
                    ksName = owner.getParameter(NetModule.PARAM_SSL_KEYSTORE, true);
                    ksPass = owner.getParameter(NetModule.PARAM_SSL_KEYSTORE_PASSWORD, true).toCharArray();
                }
                catch (InvalidParameterException e) {
                    NetModule.this.logger.error((Object)"Required SSL parameter missing.", (Throwable)e);
                    throw new IOException("Failed to retireve require SSL parameters. Check config XML");
                }
                try {
                    ks = KeyStore.getInstance("JKS");
                }
                catch (KeyStoreException e) {
                    NetModule.this.logger.error((Object)"Failed to initialise SSL keystore.", (Throwable)e);
                    throw new IOException("Error initialising SSL keystore");
                }
                try {
                    ks.load(new FileInputStream(ksName), ksPass);
                }
                catch (NoSuchAlgorithmException e) {
                    NetModule.this.logger.error((Object)("Failed to load keystore: " + ksName), (Throwable)e);
                    throw new IOException("Error loading SSL keystore");
                }
                catch (CertificateException e) {
                    NetModule.this.logger.error((Object)("Failed to load SSL certificate: " + ksName), (Throwable)e);
                    throw new IOException("Error loading SSL certificate");
                }
                try {
                    kmf = KeyManagerFactory.getInstance("SunX509");
                }
                catch (NoSuchAlgorithmException e) {
                    NetModule.this.logger.error((Object)"Failed to create key manager instance", (Throwable)e);
                    throw new IOException("Error creating SSL key manager instance");
                }
                try {
                    kmf.init(ks, ksPass);
                }
                catch (Exception e) {
                    NetModule.this.logger.error((Object)"Failed to initialise key manager instance", (Throwable)e);
                    throw new IOException("Error initialising SSL key manager instance");
                }
                try {
                    tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(ks);
                }
                catch (Exception e1) {
                    NetModule.this.logger.error((Object)"Failed to create trust manager instance", (Throwable)e1);
                    throw new IOException("Error creating SSL trust manager instance");
                }
                try {
                    sc = SSLContext.getInstance(sslProtocol);
                }
                catch (NoSuchAlgorithmException e) {
                    NetModule.this.logger.error((Object)"Failed to create SSL context instance", (Throwable)e);
                    throw new IOException("Error creating SSL context instance");
                }
                try {
                    sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                }
                catch (KeyManagementException e) {
                    NetModule.this.logger.error((Object)"Failed to initialise SSL context instance", (Throwable)e);
                    throw new IOException("Error initialising SSL context instance");
                }
                SSLServerSocketFactory ssf = sc.getServerSocketFactory();
                this.socket = address != null ? ssf.createServerSocket(port, 0, InetAddress.getByName(address)) : ssf.createServerSocket(port);
            } else {
                this.socket = new ServerSocket();
                if (address != null) {
                    this.socket.bind(new InetSocketAddress(address, port));
                } else {
                    this.socket.bind(new InetSocketAddress(port));
                }
            }
        }

        NetModule getOwner() {
            return this.owner;
        }

        public ServerSocket getSocket() {
            return this.socket;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.owner.forceStop(e);
                }
            }
        }

        @Override
        public void run() {
            while (!this.isTerminated()) {
                try {
                    Socket conn = this.socket.accept();
                    conn.setSoLinger(true, 60);
                    new ConnectionThread(this.getOwner(), conn);
                }
                catch (IOException e) {
                    if (this.isTerminated()) continue;
                    this.owner.forceStop(e);
                }
            }
        }

        public void terminate() {
            this.setTerminated(true);
        }
    }

    protected class ConnectionThread
    extends Thread {
        private NetModule owner;
        private Socket socket;

        public ConnectionThread(NetModule owner, Socket socket) {
            super(ClassUtils.getSimpleName(ConnectionThread.class) + "-Thread");
            this.owner = owner;
            this.socket = socket;
            this.start();
        }

        public NetModule getOwner() {
            return this.owner;
        }

        public Socket getSocket() {
            return this.socket;
        }

        @Override
        public void run() {
            Socket s = this.getSocket();
            try {
                this.getOwner().getHandler().handle(this.getOwner(), s);
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException sce) {
                    new WrappedException(sce).terminate();
                }
            }
        }
    }
}

