/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.openas2.WrappedException;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandResult;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.util.CommandTokenizer;

public class StreamCommandProcessor
extends BaseCommandProcessor {
    public static final String COMMAND_NOT_FOUND = "Error: command not found";
    public static final String COMMAND_ERROR = "Error executing command";
    public static final String EXIT_COMMAND = "exit";
    public static final String PROMPT = "#>";
    private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));

    public BufferedReader getReader() {
        return this.reader;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Override
    public void processCommand() throws Exception {
        try {
            String str = this.readLine();
            if (str != null) {
                CommandTokenizer strTkn = new CommandTokenizer(str);
                if (strTkn.hasMoreTokens()) {
                    String commandName = strTkn.nextToken().toLowerCase();
                    if (commandName.equals(EXIT_COMMAND)) {
                        this.terminate();
                    } else {
                        ArrayList<String> params = new ArrayList<String>();
                        while (strTkn.hasMoreTokens()) {
                            params.add(strTkn.nextToken());
                        }
                        Command cmd = this.getCommand(commandName);
                        if (cmd != null) {
                            CommandResult result = cmd.execute(params.toArray());
                            if (result.getType() == "OK") {
                                this.writeLine(result.toString());
                            } else {
                                this.writeLine(COMMAND_ERROR);
                                this.writeLine(result.getResult());
                            }
                        } else {
                            this.writeLine("Error: command not found> " + commandName);
                            List<Command> l = this.getCommands();
                            this.writeLine("List of commands:");
                            this.writeLine(EXIT_COMMAND);
                            for (int i = 0; i < l.size(); ++i) {
                                cmd = l.get(i);
                                this.writeLine(cmd.getName());
                            }
                        }
                    }
                }
                this.write(PROMPT);
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
    }

    public String readLine() throws IOException {
        BufferedReader rd = this.getReader();
        return rd.readLine().trim();
    }

    public void write(String text) throws IOException {
        BufferedWriter wr = this.getWriter();
        wr.write(text);
        wr.flush();
    }

    public void writeLine(String line) throws IOException {
        BufferedWriter wr = this.getWriter();
        wr.write(line + "\r\n");
        wr.flush();
    }

    @Override
    public void destroy() throws Exception {
        this.reader = null;
        super.destroy();
    }
}

