/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor;

import java.util.List;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.message.Message;
import org.openas2.processor.ActiveModule;
import org.openas2.processor.BaseProcessorModule;
import org.openas2.processor.ForcedStopException;
import org.openas2.processor.UnsupportedException;

public abstract class BaseActiveModule
extends BaseProcessorModule
implements ActiveModule {
    private boolean running;

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public abstract void doStart() throws OpenAS2Exception;

    public abstract void doStop() throws OpenAS2Exception;

    @Override
    public abstract boolean healthcheck(List<String> var1);

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        return false;
    }

    public void forceStop(Exception cause) {
        try {
            throw new ForcedStopException(cause);
        }
        catch (ForcedStopException fse) {
            fse.terminate();
            try {
                this.stop();
            }
            catch (OpenAS2Exception oae) {
                oae.terminate();
            }
            return;
        }
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        throw new UnsupportedException("Active modules don't handle anything by default");
    }

    @Override
    public void start() throws OpenAS2Exception {
        this.doStart();
        this.setRunning(true);
    }

    @Override
    public void stop() throws OpenAS2Exception {
        this.doStop();
        this.setRunning(false);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName() + ": " + this.getParameters());
        return buf.toString();
    }

    private void setRunning(boolean running) {
        this.running = running;
    }
}

