/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.msgtracking;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.Server;
import org.openas2.OpenAS2Exception;
import org.openas2.processor.msgtracking.DbTrackingModule;
import org.openas2.processor.msgtracking.IDBHandler;

class EmbeddedDBHandler
extends DbTrackingModule
implements IDBHandler {
    @Nullable
    private JdbcConnectionPool cp = null;
    private Server server = null;
    private String connectString = "jdbc:h2:file:DB/openas2";

    EmbeddedDBHandler() {
    }

    @Override
    public void createConnectionPool(String connectString, String userName, String pwd) throws OpenAS2Exception {
        if (this.cp != null) {
            throw new OpenAS2Exception("Connection pool already initialized. Cannot create a new connection pool. Stop current one first. DB connect string:" + connectString + " :: Active pool connect string: " + this.connectString);
        }
        this.connectString = connectString;
        this.cp = JdbcConnectionPool.create((String)connectString, (String)userName, (String)pwd);
    }

    @Override
    public void start(String connectString, String userName, String pwd, Map<String, String> params) throws OpenAS2Exception {
        this.createConnectionPool(connectString, userName, pwd);
        if ("true".equalsIgnoreCase(this.getParameter("tcp_server_start", "true"))) {
            String dbDirectory;
            String tcpPwd;
            String tcpPort = params.get("tcp_server_port");
            if (tcpPort == null || tcpPort.length() < 1) {
                tcpPort = "9092";
            }
            if ((tcpPwd = params.get("tcp_server_password")) == null || tcpPwd.length() < 1) {
                tcpPwd = "OpenAS2";
            }
            if ((dbDirectory = params.get("db_directory")) == null || dbDirectory.length() < 1) {
                throw new OpenAS2Exception("TCP server requireds parameter: db_directory");
            }
            try {
                this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", tcpPort, "-tcpPassword", tcpPwd, "-baseDir", dbDirectory, "-tcpAllowOthers"}).start();
            }
            catch (SQLException e) {
                throw new OpenAS2Exception("Failed to start TCP server", e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        } else {
            try {
                this.shutdown(this.connectString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.destroyConnectionPool();
        }
    }

    @Override
    public void destroyConnectionPool() {
        if (this.cp == null) {
            return;
        }
        this.cp.dispose();
        this.cp = null;
    }

    @Override
    public Connection getConnection() throws SQLException, OpenAS2Exception {
        if (this.cp == null) {
            throw new OpenAS2Exception("Connection pool not initialized.");
        }
        return this.cp.getConnection();
    }

    @Override
    public boolean shutdown(String connectString) throws SQLException, OpenAS2Exception {
        try {
            for (int waitCount = 0; this.cp != null && this.cp.getActiveConnections() > 0 && waitCount < 10; ++waitCount) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Connection c = this.getConnection();
        Statement st = c.createStatement();
        boolean result = st.execute("SHUTDOWN");
        c.close();
        return result;
    }
}

