/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.cert.CertificateFactory;
import org.openas2.cert.CertificateNotFoundException;
import org.openas2.cert.KeyNotFoundException;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.util.MimeUtil;
import org.openas2.message.AS2Message;
import org.openas2.message.AS2MessageMDN;
import org.openas2.message.MessageMDN;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.partner.Partnership;
import org.openas2.processor.receiver.AS2ReceiverModule;
import org.openas2.processor.receiver.NetException;
import org.openas2.processor.receiver.NetModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.AS2Util;
import org.openas2.util.ByteArrayDataSource;
import org.openas2.util.DateUtil;
import org.openas2.util.DispositionOptions;
import org.openas2.util.DispositionType;
import org.openas2.util.HTTPUtil;
import org.openas2.util.IOUtil;
import org.openas2.util.Profiler;
import org.openas2.util.ProfilerStub;
import org.openas2.util.Properties;

public class AS2ReceiverHandler
implements NetModuleHandler {
    private AS2ReceiverModule module;
    private Log logger = LogFactory.getLog((String)AS2ReceiverHandler.class.getSimpleName());

    public AS2ReceiverHandler(AS2ReceiverModule module) {
        this.module = module;
    }

    public String getClientInfo(Socket s) {
        return " " + s.getInetAddress().getHostAddress() + " " + Integer.toString(s.getPort());
    }

    public AS2ReceiverModule getModule() {
        return this.module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(NetModule owner, Socket s) {
        BufferedOutputStream out;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("incoming connection" + this.getClientInfo(s)));
        }
        AS2Message msg = this.createMessage(s);
        byte[] data = null;
        msg.setOption("DIRECTION", "RECEIVE");
        try {
            out = new BufferedOutputStream(s.getOutputStream());
        }
        catch (IOException e1) {
            msg.setLogMsg("Failed to get outputstream on received socket. Response cannot be sent.");
            this.logger.error((Object)msg, (Throwable)e1);
            return;
        }
        try {
            ProfilerStub transferStub = Profiler.startProfile();
            try {
                data = HTTPUtil.readData(s.getInputStream(), s.getOutputStream(), msg);
            }
            catch (Exception e) {
                msg.setLogMsg("HTTP connection error on inbound message.");
                this.logger.error((Object)msg, (Throwable)e);
                NetException ne = new NetException(s.getInetAddress(), s.getPort(), e);
                ne.terminate();
            }
            Profiler.endProfile(transferStub);
            String mic = null;
            if (data == null) {
                if ("true".equalsIgnoreCase(msg.getAttribute("isHealthCheck"))) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Healthcheck ping detected [" + this.getClientInfo(s) + "]" + msg.getLogMsgID()));
                    }
                    return;
                }
                try {
                    HTTPUtil.sendHTTPResponse(s.getOutputStream(), 400, null);
                }
                catch (IOException e) {
                    // empty catch block
                }
                OpenAS2Exception oe = new OpenAS2Exception("Missing data in AS2 request.");
                msg.setLogMsg("Error receiving message for inbound AS2 request. There is no data.");
                this.logger.error((Object)msg, (Throwable)oe);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("received " + IOUtil.getTransferRate(data.length, transferStub) + this.getClientInfo(s) + msg.getLogMsgID()));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Received msg built from HTTP input stream: " + msg.toString() + msg.getLogMsgID()));
            }
            try {
                ContentType receivedContentType = null;
                try {
                    receivedContentType = new ContentType(msg.getHeader("Content-Type"));
                    MimeBodyPart receivedPart = new MimeBodyPart();
                    receivedPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, receivedContentType.toString(), null)));
                    if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                        this.logger.trace((Object)("Received MimeBodyPart for inbound message: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(receivedPart, true)));
                    }
                    receivedPart.setHeader("Content-Type", receivedContentType.toString());
                    String cte = receivedPart.getEncoding();
                    if (cte == null) {
                        cte = msg.getHeader("Content-Transfer-Encoding");
                        if (cte == null) {
                            cte = "binary";
                        }
                        receivedPart.setHeader("Content-Transfer-Encoding", cte);
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Received msg MimePart has transfer encoding: " + cte + msg.getLogMsgID()));
                    }
                    msg.setData(receivedPart);
                }
                catch (Exception e) {
                    msg.setLogMsg("Error extracting received message.");
                    this.logger.error((Object)msg, (Throwable)e);
                    throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured while parsing the MIME content.", e);
                }
                String sourceIpAddress = msg.getXForwardedFor();
                if (sourceIpAddress == null) {
                    sourceIpAddress = msg.getXRealIP();
                }
                if (sourceIpAddress != null) {
                    this.logger.info((Object)(msg.getLogMsgID() + " AS2 message has been forwarded by the proxy " + msg.getAttribute("source_ip") + ", the original server IP address is " + sourceIpAddress));
                    msg.setAttribute("source_ip", sourceIpAddress);
                }
                try {
                    msg.getPartnership().setSenderID("as2_id", msg.getHeader("AS2-From"));
                    msg.getPartnership().setReceiverID("as2_id", msg.getHeader("AS2-To"));
                    this.getModule().getSession().getPartnershipFactory().updatePartnership(msg, false);
                }
                catch (OpenAS2Exception oae) {
                    throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "authentication-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but the Sender $sender.as2_id$ and/or Recipient $receiver.as2_id$ are unknown.", oae);
                }
                msg.setOption("STATE", "msg_receive_start");
                msg.trackMsgState(this.getModule().getSession());
                mic = this.decryptAndVerify(msg);
                try {
                    msg.setPayloadFilename(msg.extractPayloadFilename());
                }
                catch (ParseException e1) {
                    this.logger.error((Object)"Failed to extract the file name from received content-disposition", (Throwable)e1);
                }
                try {
                    this.getModule().getSession().getProcessor().handle("store", msg, null);
                }
                catch (OpenAS2Exception oae) {
                    msg.setLogMsg("Error handling received message: " + oae.getCause());
                    this.logger.error((Object)msg, (Throwable)oae);
                    msg.setOption("STATE", "msg_receive_exception");
                    msg.trackMsgState(this.getModule().getSession());
                    throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message.  An error occured while storing the data to the file system.", oae);
                }
                try {
                    if (msg.isRequestingMDN()) {
                        msg.setOption("STATE", "mdn_send_start");
                        msg.trackMsgState(this.getModule().getSession());
                        boolean sentMDN = this.sendResponse(msg, out, new DispositionType("automatic-action", "MDN-sent-automatically", "processed"), mic, "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. There is no guarantee however that the EDI Interchange was syntactically correct, or was received by the EDI application/translator.");
                        if (!sentMDN && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Received message processed but MDN could not be sent for Message-ID: " + msg.getMessageID()));
                        }
                    } else {
                        HTTPUtil.sendHTTPResponse(out, 200, null);
                        out.flush();
                        this.logger.info((Object)("Msg received, no MDN requested. Sent HTTP OK" + this.getClientInfo(s) + msg.getLogMsgID()));
                    }
                }
                catch (Exception e) {
                    msg.setLogMsg("Error processing MDN for received message: " + e.getCause());
                    this.logger.error((Object)msg, (Throwable)e);
                    msg.setOption("STATE", "mdn_sending_exception");
                    msg.trackMsgState(this.getModule().getSession());
                    throw new WrappedException("Error creating and returning MDN, message was still processed", e);
                }
            }
            catch (DispositionException de) {
                this.sendResponse(msg, out, de.getDisposition(), mic, de.getText());
                this.getModule().handleError(msg, de);
            }
            catch (OpenAS2Exception oae) {
                msg.setOption("STATE", "msg_receive_fail");
                msg.trackMsgState(this.getModule().getSession());
                this.getModule().handleError(msg, oae);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    msg.setLogMsg("Failed to close output connection.");
                    this.logger.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    protected AS2Message createMessage(Socket s) {
        AS2Message msg = new AS2Message();
        msg.setAttribute("source_ip", s.getInetAddress().toString());
        msg.setAttribute("source_port", Integer.toString(s.getPort()));
        msg.setAttribute("destination_ip", s.getLocalAddress().toString());
        msg.setAttribute("destination_port", Integer.toString(s.getLocalPort()));
        return msg;
    }

    protected String decryptAndVerify(AS2Message msg) throws OpenAS2Exception {
        DispositionOptions dispOptions;
        ICryptoHelper ch;
        CertificateFactory certFx = this.getModule().getSession().getCertificateFactory();
        String mic = null;
        try {
            ch = AS2Util.getCryptoHelper();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        boolean isDecompressed = false;
        try {
            if (ch.isEncrypted(msg.getData())) {
                msg.setRxdMsgWasEncrypted(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("decrypting :::" + msg.getLogMsgID()));
                }
                X509Certificate receiverCert = certFx.getCertificate(msg, "receiver");
                PrivateKey receiverKey = certFx.getPrivateKey(msg, receiverCert);
                msg.setData(AS2Util.getCryptoHelper().decrypt(msg.getData(), receiverCert, receiverKey));
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after decryption: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Error extracting received message: " + e.getCause());
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decryption-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decrypting the content.", e);
        }
        try {
            if (ch.isCompressed(msg.getData())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Decompressing received message before checking signature...");
                }
                AS2Util.getCryptoHelper().decompress(msg);
                isDecompressed = true;
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after decompression: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e1) {
            msg.setLogMsg("Error decompressing received message: " + e1.getCause());
            this.logger.error((Object)msg, (Throwable)e1);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompresion-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", e1);
        }
        try {
            if (ch.isSigned(msg.getData())) {
                msg.setRxdMsgWasSigned(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("verifying signature" + msg.getLogMsgID()));
                }
                X509Certificate senderCert = certFx.getCertificate(msg, "sender");
                msg.setData(AS2Util.getCryptoHelper().verifySignature(msg.getData(), senderCert));
                if (this.logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMsgMimeBodyParts", "false"))) {
                    this.logger.trace((Object)("Received MimeBodyPart for inbound message after signature verification: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(msg.getData(), true)));
                }
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Error decrypting received message: " + org.openas2.logging.Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "integrity-check-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.", e);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("SMIME Decrypted Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type received: " + msg.getContentType() + "\n      HEADERS after decryption: " + msg.getData().getAllHeaders() + "\n      Content-Disposition in MSG getData() MIMEPART after decryption: " + msg.getData().getContentType()));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        if ((dispOptions = new DispositionOptions(msg.getHeader("Disposition-Notification-Options"))).getMicalg() != null) {
            try {
                mic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), msg.isRxdMsgWasSigned() || msg.isRxdMsgWasEncrypted(), msg.getPartnership().isPreventCanonicalization());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Prevent Canonicalization: " + msg.getPartnership().isPreventCanonicalization() + " ::: MIC calc on rxd msg: " + mic));
                }
                if (this.logger.isTraceEnabled()) {
                    String tmic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), msg.isRxdMsgWasSigned() || msg.isRxdMsgWasEncrypted(), !msg.getPartnership().isPreventCanonicalization());
                    this.logger.trace((Object)("MIC with forced reversed prevent canocalization: " + tmic + msg.getLogMsgID()));
                    tmic = ch.calculateMIC(msg.getData(), dispOptions.getMicalg(), false, msg.getPartnership().isPreventCanonicalization());
                    this.logger.trace((Object)("MIC with forced exclude headers flag: " + tmic + msg.getLogMsgID()));
                }
            }
            catch (Exception e) {
                msg.setLogMsg("Error calculating MIC on received message: " + e.getCause());
                this.logger.error((Object)msg, (Throwable)e);
                throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Calculation of the MIC for the message failed.", e);
            }
        }
        try {
            if (ch.isCompressed(msg.getData())) {
                if (isDecompressed) {
                    throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", new Exception("Message has already been decompressed. Per RFC5402 it cannot occur twice."));
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Decompressing received message after decryption...");
                }
                AS2Util.getCryptoHelper().decompress(msg);
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Unexepcted error checking for compressed message after signing");
            this.logger.error((Object)msg, (Throwable)e);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", new Exception("Unexpected error occurred checking for compressed message: " + e.getMessage()));
        }
        return mic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean sendResponse(AS2Message msg, BufferedOutputStream out, DispositionType disposition, String mic, String text) {
        boolean mdnBlocked = false;
        boolean bl = mdnBlocked = msg.getPartnership().getAttribute("blockerrormdn") != null;
        if (!mdnBlocked) {
            try {
                this.createMDN(this.getModule().getSession(), msg, mic, disposition, text);
            }
            catch (Exception e1) {
                try {
                    HTTPUtil.sendHTTPResponse(out, 500, null);
                }
                catch (IOException e) {
                    if (!this.logger.isErrorEnabled()) return false;
                    this.logger.error((Object)("Error sending HTTP_INTERNAL_ERROR response. " + msg.getLogMsgID()), (Throwable)e);
                    return false;
                }
                WrappedException we = new WrappedException("Error creating MDN", e1);
                we.addSource("message", msg);
                we.terminate();
                msg.setLogMsg("Unexpected error occurred creating MDN: " + org.openas2.logging.Log.getExceptionMsg(e1));
                this.logger.error((Object)msg, (Throwable)e1);
                return false;
            }
            try {
                HashMap<Object, Object> options = new HashMap<Object, Object>();
                options.put("buffered_output_stream", out);
                this.getModule().getSession().getProcessor().handle("sendmdn", msg, options);
                if (!this.logger.isInfoEnabled()) return true;
                this.logger.info((Object)("Sent MDN [" + disposition.toString() + "]" + msg.getLogMsgID()));
                return true;
            }
            catch (Exception e) {
                WrappedException we = new WrappedException("Error sending MDN", e);
                we.addSource("message", msg);
                we.terminate();
                msg.setLogMsg("Unexpected error occurred sending MDN: " + org.openas2.logging.Log.getExceptionMsg(e));
                this.logger.error((Object)msg, (Throwable)e);
                return false;
            }
        }
        try {
            HTTPUtil.sendHTTPResponse(out, 200, null);
            return true;
        }
        catch (IOException e) {
            if (!this.logger.isErrorEnabled()) return false;
            this.logger.error((Object)("Error sending HTTP OK response. " + msg.getLogMsgID()), (Throwable)e);
            return false;
        }
    }

    public MessageMDN createMDN(Session session, AS2Message msg, String mic, DispositionType disposition, String text) throws Exception {
        AS2MessageMDN mdn = new AS2MessageMDN(msg, false);
        mdn.setHeader("AS2-Version", "1.1");
        mdn.setHeader("Date", DateUtil.formatDate("EEE, dd MMM yyyy HH:mm:ss Z"));
        mdn.setHeader("Connection", "close, TE");
        String userAgent = Properties.getProperty(Properties.HTTP_USER_AGENT_PROP, msg.getAppTitle());
        mdn.setHeader("User-Agent", userAgent);
        mdn.setHeader("Server", userAgent);
        mdn.setHeader("Mime-Version", "1.0");
        mdn.getPartnership().setSenderID("as2_id", mdn.getHeader("AS2-From"));
        mdn.getPartnership().setReceiverID("as2_id", mdn.getHeader("AS2-To"));
        session.getPartnershipFactory().updatePartnership(mdn, true);
        mdn.setHeader("From", msg.getPartnership().getReceiverID("email"));
        String subject = mdn.getPartnership().getAttribute("subject");
        if (subject != null) {
            mdn.setHeader("Subject", ParameterParser.parse(subject, new MessageParameters(msg)));
        } else {
            mdn.setHeader("Subject", "Your Requested MDN Response");
        }
        mdn.setText(ParameterParser.parse(text, new MessageParameters(msg)));
        mdn.setAttribute("REPORTING_UA", session.getAppTitle() + "@" + msg.getAttribute("destination_ip") + ":" + msg.getAttribute("destination_port"));
        mdn.setAttribute("ORIGINAL_RECIPIENT", "rfc822; " + msg.getHeader("AS2-To"));
        mdn.setAttribute("FINAL_RECIPIENT", "rfc822; " + msg.getPartnership().getReceiverID("as2_id"));
        mdn.setAttribute("ORIGINAL_MESSAGE_ID", msg.getHeader("Message-ID"));
        mdn.setAttribute("DISPOSITION", disposition.toString());
        DispositionOptions dispOptions = new DispositionOptions(msg.getHeader("Disposition-Notification-Options"));
        mdn.setAttribute("MIC", mic);
        this.createMDNData(session, mdn, dispOptions.getMicalg(), dispOptions.getProtocol());
        mdn.updateMessageID();
        msg.setMDN(mdn);
        return mdn;
    }

    public void createMDNData(Session session, MessageMDN mdn, String micAlg, String signatureProtocol) throws Exception {
        MimeMultipart reportParts = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        String text = mdn.getText() + "\r\n";
        textPart.setContent((Object)text, "text/plain");
        textPart.setHeader("Content-Type", "text/plain");
        reportParts.addBodyPart((BodyPart)textPart);
        MimeBodyPart reportPart = new MimeBodyPart();
        InternetHeaders reportValues = new InternetHeaders();
        reportValues.setHeader("Reporting-UA", mdn.getAttribute("REPORTING_UA"));
        reportValues.setHeader("Original-Recipient", mdn.getAttribute("ORIGINAL_RECIPIENT"));
        reportValues.setHeader("Final-Recipient", mdn.getAttribute("FINAL_RECIPIENT"));
        reportValues.setHeader("Original-Message-ID", mdn.getAttribute("ORIGINAL_MESSAGE_ID"));
        reportValues.setHeader("Disposition", mdn.getAttribute("DISPOSITION"));
        reportValues.setHeader("Received-Content-MIC", mdn.getAttribute("MIC"));
        Enumeration reportEn = reportValues.getAllHeaderLines();
        StringBuffer reportData = new StringBuffer();
        while (reportEn.hasMoreElements()) {
            reportData.append((String)reportEn.nextElement()).append("\r\n");
        }
        reportData.append("\r\n");
        String reportText = reportData.toString();
        reportPart.setContent((Object)reportText, "message/disposition-notification");
        reportPart.setHeader("Content-Type", "message/disposition-notification");
        reportParts.addBodyPart((BodyPart)reportPart);
        MimeBodyPart report = new MimeBodyPart();
        reportParts.setSubType("report; report-type=disposition-notification");
        report.setContent((Multipart)reportParts);
        String contentType = reportParts.getContentType();
        if ("true".equalsIgnoreCase(Properties.getProperty("remove_multipart_content_type_header_folding", "false"))) {
            contentType = contentType.replaceAll("\r\n[ \t]*", " ");
        }
        report.setHeader("Content-Type", contentType);
        if (signatureProtocol != null) {
            CertificateFactory certFx = session.getCertificateFactory();
            try {
                X509Certificate senderCert = certFx.getCertificate(mdn, "receiver");
                PrivateKey senderKey = certFx.getPrivateKey(mdn, senderCert);
                Partnership p = mdn.getPartnership();
                String contentTxfrEncoding = p.getAttribute("content_transfer_encoding");
                boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(p.getAttribute("remove_cms_algorithm_protection_attrib"));
                if (contentTxfrEncoding == null) {
                    contentTxfrEncoding = "binary";
                }
                MimeBodyPart signedReport = AS2Util.getCryptoHelper().sign(report, senderCert, senderKey, micAlg, contentTxfrEncoding, false, isRemoveCmsAlgorithmProtectionAttr);
                mdn.setData(signedReport);
            }
            catch (CertificateNotFoundException cnfe) {
                cnfe.terminate();
                mdn.setData(report);
            }
            catch (KeyNotFoundException knfe) {
                knfe.terminate();
                mdn.setData(report);
            }
        } else {
            mdn.setData(report);
        }
        MimeBodyPart data = mdn.getData();
        String headerContentType = data.getContentType();
        if ("true".equalsIgnoreCase(Properties.getProperty("remove_http_header_folding", "true"))) {
            headerContentType = headerContentType.replaceAll("\r\n[ \t]*", " ");
        }
        mdn.setHeader("Content-Type", headerContentType);
    }
}

